/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.util;

import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class RomHolder {
    private static final Logger LOG = LogHelper.getLogger(RomHolder.class.getSimpleName());
    public static final RomHolder EMPTY_ROM = new RomHolder(new byte[1024]);
    public final int baseSize;
    public final int size;
    public final int romMask;
    public final byte[] data;

    public RomHolder(byte[] rom) {
        this.data = Util.getPaddedRom(rom);
        this.size = this.data.length;
        this.baseSize = rom.length;
        this.romMask = Util.getRomMask(this.size);
        assert (this.romMask == this.size - 1);
        if (this.baseSize != this.size) {
            LOG.info(this.toString());
        }
    }

    public String toString() {
        return "RomHolder{romSize=" + Util.th(this.baseSize) + ", paddedSize=" + Util.th(this.size) + ", romMask=" + Util.th(this.romMask) + "}";
    }
}

