/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp;

import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import omegadrive.Device;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.VdpInterruptHandlerHelper;
import omegadrive.vdp.VdpRenderDump;
import omegadrive.vdp.md.VdpInterruptHandler;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.Tms9918a;
import omegadrive.vdp.model.VdpMisc;
import org.slf4j.Logger;

public class Tms9918aVdp
implements Tms9918a,
Device {
    private static final Logger LOG = LogHelper.getLogger(Tms9918aVdp.class.getSimpleName());
    private static final boolean verbose = false;
    public static final int VDP_WIDTH = 256;
    public static final int VDP_HEIGHT = 192;
    public static final int MODE0_OFFSET = 8;
    private Tms9918a.TmsMode vdpMode;
    private VdpInterruptHandler interruptHandler;
    private VdpRenderDump renderDump;
    private List<BaseVdpAdapterEventSupport.VdpEventListener> list;
    private int[] screenDataLinear;
    public byte[] mem;
    private final int[] registers = new int[8];
    private byte statusRegister = 0;
    private short readWriteAddr;
    private byte readAhead;
    private boolean secondByteFlag = false;
    private byte ioByte0;
    private byte ioByte1;
    private final int[] spriteLineCount = new int[208];
    private final boolean[][] spritePriorityMatrix = new boolean[272][208];
    private final boolean[][] spriteCollisionMatrix = new boolean[272][208];

    public Tms9918aVdp() {
        this.setupVdp();
        this.init();
    }

    @Override
    public void reset() {
        Arrays.fill(this.registers, 0);
        Arrays.fill(this.mem, (byte)0);
        this.registers[1] = 16;
        this.readWriteAddr = 0;
        this.secondByteFlag = false;
        this.ioByte0 = 0;
        this.ioByte1 = 0;
        this.statusRegister = 0;
        this.updateTmsMode();
    }

    @Override
    public void init() {
        this.reset();
    }

    private void setupVdp() {
        this.list = new ArrayList<BaseVdpAdapterEventSupport.VdpEventListener>();
        this.screenDataLinear = new int[49152];
        this.interruptHandler = VdpInterruptHandlerHelper.createTmsInstance(this);
        this.mem = Util.initMemoryRandomBytes(new byte[16384]);
        this.renderDump = new VdpRenderDump();
    }

    @Override
    public int runSlot() {
        boolean vBlankTrigger;
        boolean vBlank = this.interruptHandler.isvBlankSet();
        this.interruptHandler.increaseHCounter();
        boolean bl = vBlankTrigger = !vBlank && this.interruptHandler.isvBlankSet();
        if (vBlankTrigger) {
            this.setStatusINT(true);
            this.drawScreen();
        }
        if (this.interruptHandler.isEndOfFrameCounter()) {
            this.list.forEach(BaseVdpAdapterEventSupport.VdpEventListener::onNewFrame);
        }
        return 0;
    }

    @Override
    public int[] getScreenDataLinear() {
        return this.screenDataLinear;
    }

    @Override
    public int getRegisterData(int reg) {
        return this.registers[reg];
    }

    @Override
    public void updateRegisterData(int reg, int data) {
        this.registers[reg] = (byte)data;
    }

    @Override
    public VideoMode getVideoMode() {
        return VideoMode.NTSCJ_H32_V24;
    }

    @Override
    public void setRegion(RegionDetector.Region region) {
    }

    public VdpInterruptHandler getInterruptHandler() {
        return this.interruptHandler;
    }

    private void updateTmsMode() {
        Tms9918a.TmsMode mode = null;
        int val = (this.getM1() ? 1 : 0) << 0 | (this.getM2() ? 1 : 0) << 1 | (this.getM3() ? 1 : 0) << 2;
        switch (val) {
            case 0: {
                mode = Tms9918a.TmsMode.MODE_0;
                break;
            }
            case 1: 
            case 3: {
                mode = Tms9918a.TmsMode.MODE_1;
                break;
            }
            case 2: {
                mode = Tms9918a.TmsMode.MODE_2;
                break;
            }
            case 4: {
                mode = Tms9918a.TmsMode.MODE_3;
                break;
            }
            default: {
                LOG.error("Unsupported mode selected: {}", (Object)val);
                mode = this.vdpMode;
            }
        }
        if (mode != this.vdpMode) {
            LOG.info("Mode change from: {}, to: {}", (Object)this.vdpMode, (Object)mode);
            this.vdpMode = mode;
        }
    }

    public boolean getStatusBit(int bit) {
        return Tms9918aVdp.getBit(this.statusRegister, bit);
    }

    public void setStatusBit(int bit, boolean v) {
        this.statusRegister = Tms9918aVdp.setBit(this.statusRegister, bit, v);
    }

    public boolean getStatusINT() {
        return this.getStatusBit(7);
    }

    public void setStatusINT(boolean v) {
        this.setStatusBit(7, v);
    }

    public void setStatus5S(boolean v) {
        this.setStatusBit(6, v);
    }

    public void setStatusC(boolean v) {
        this.setStatusBit(5, v);
    }

    public boolean getRegisterBit(int reg, int bit) {
        return Tms9918aVdp.getBit(this.registers[reg], bit);
    }

    public void setRegisterBit(int reg, int bit, boolean value) {
        this.registers[reg] = Tms9918aVdp.setBit(this.registers[reg], bit, value);
        if (reg < 2) {
            this.updateTmsMode();
        }
    }

    public static int setBit(int in, int bit, boolean v) {
        return v ? in | 1 << bit : in & -2 << bit;
    }

    public static byte setBit(byte in, int bit, boolean v) {
        return v ? (byte)(in | 1 << bit) : (byte)(in & -2 << bit);
    }

    public static boolean getBit(byte in, int bit) {
        return (in & 1 << bit) != 0;
    }

    public static boolean getBit(int in, int bit) {
        return (in & 1 << bit) != 0;
    }

    public boolean getEXTVID() {
        return this.getRegisterBit(0, 0);
    }

    public boolean getM2() {
        return this.getRegisterBit(0, 1);
    }

    public boolean getMAG() {
        return this.getRegisterBit(1, 0);
    }

    public boolean getSI() {
        return this.getRegisterBit(1, 1);
    }

    public boolean getM3() {
        return this.getRegisterBit(1, 3);
    }

    public boolean getM1() {
        return this.getRegisterBit(1, 4);
    }

    public boolean getGINT() {
        return this.getRegisterBit(1, 5);
    }

    public void setGINT(boolean b) {
        this.setRegisterBit(1, 5, b);
    }

    public boolean getBL() {
        return this.getRegisterBit(1, 6);
    }

    public boolean get416K() {
        return this.getRegisterBit(1, 7);
    }

    public boolean getPG13() {
        return this.getRegisterBit(4, 2);
    }

    public boolean getCT13() {
        return this.getRegisterBit(3, 7);
    }

    public int getNameTableAddr() {
        return (this.registers[Tms9918a.TmsRegisterName.TILEMAP_NAMETABLE.ordinal()] & 0xF) << 10;
    }

    public int getColorTableAddr() {
        return this.registers[Tms9918a.TmsRegisterName.COLORMAP_NAMETABLE.ordinal()] << 6;
    }

    public int getPatternTableAddr() {
        return (this.registers[Tms9918a.TmsRegisterName.TILE_START_ADDRESS.ordinal()] & 7) << 11;
    }

    public int getSpriteAttrTable() {
        return (this.registers[Tms9918a.TmsRegisterName.SPRITE_TABLE_LOC.ordinal()] & 0x7F) << 7;
    }

    public int getSpriteGenTable() {
        return (this.registers[Tms9918a.TmsRegisterName.SPRITE_TILE_BASE_ADDR.ordinal()] & 7) << 11;
    }

    public int getOnBitColor() {
        return this.registers[Tms9918a.TmsRegisterName.BACKGROUND_COLOR.ordinal()] >> 4;
    }

    public int getOffBitColor() {
        return this.registers[Tms9918a.TmsRegisterName.BACKGROUND_COLOR.ordinal()] & 0xF;
    }

    public int getFifthSpriteNr() {
        return this.registers[Tms9918a.TmsRegisterName.BACKGROUND_COLOR.ordinal()] & 0xF;
    }

    public int getSpriteX(int sprite) {
        int attrTable = this.getSpriteAttrTable();
        return this.mem[attrTable + sprite * 4 + 1];
    }

    public int getSpriteY(int sprite) {
        int attrTable = this.getSpriteAttrTable();
        return this.mem[attrTable + sprite * 4 + 0];
    }

    public int getSpritePattern(int sprite) {
        int attrTable = this.getSpriteAttrTable();
        return this.mem[attrTable + sprite * 4 + 2];
    }

    public int getSpriteColour(int sprite) {
        int attrTable = this.getSpriteAttrTable();
        return this.mem[attrTable + sprite * 4 + 3];
    }

    public final byte readVRAMData() {
        byte result = this.readAhead;
        this.readAhead = this.mem[this.readWriteAddr];
        this.increaseReadWriteAddr();
        this.secondByteFlag = false;
        return result;
    }

    public final void writeVRAMData(byte value) {
        this.mem[this.readWriteAddr] = this.readAhead = value;
        this.increaseReadWriteAddr();
        this.secondByteFlag = false;
    }

    public final void writeRegister(byte value) {
        if (!this.secondByteFlag) {
            this.ioByte0 = value;
            this.secondByteFlag = true;
        } else {
            boolean isReg;
            this.ioByte1 = value;
            boolean bl = isReg = (this.ioByte1 & 0x80) >> 7 == 1;
            if (!isReg) {
                this.readWriteAddr = (short)(this.ioByte0 & 0xFF | (this.ioByte1 & 0x3F) << 8);
                if ((this.ioByte1 & 0xC0) >> 6 == 0) {
                    this.readAhead = this.mem[this.readWriteAddr];
                    this.increaseReadWriteAddr();
                }
            } else {
                int regNum = this.ioByte1 & 7;
                this.updateRegister(regNum, this.ioByte0 & 0xFF);
            }
            this.secondByteFlag = false;
        }
    }

    private void updateRegister(int regNum, int value) {
        if (regNum < 8 && this.registers[regNum] != value) {
            this.registers[regNum] = value;
            if (regNum < 2) {
                this.updateTmsMode();
            }
        }
    }

    public final void increaseReadWriteAddr() {
        this.readWriteAddr = (short)(this.readWriteAddr + 1 & 0x3FFF);
    }

    public final byte readStatus() {
        this.secondByteFlag = false;
        byte value = this.statusRegister;
        this.setStatusINT(false);
        this.setStatusC(false);
        return value;
    }

    public void drawBackDrop() {
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 192; ++y) {
                this.setPixel(x, y, colors[1]);
            }
        }
    }

    public void drawMode0() {
        int nameTablePtr = this.getNameTableAddr();
        int patternTableBase = this.getPatternTableAddr();
        int colorTableBase = this.getColorTableAddr();
        for (int y = 0; y < 24; ++y) {
            for (int x = 0; x < 32; ++x) {
                int patternIdx = this.mem[nameTablePtr] & 0xFF;
                int patternAddr = patternTableBase + (patternIdx << 3);
                for (int charLine = 0; charLine < 8; ++charLine) {
                    int line = this.mem[patternAddr + charLine] & 0xFF;
                    for (int linePos = 0; linePos < 8; ++linePos) {
                        int px = 7 + (x * 8 - linePos);
                        int py = y * 8 + charLine;
                        int colorTableAddr = colorTableBase + (patternIdx >> 3);
                        int color = this.mem[colorTableAddr] & 0xFF;
                        Color fg = colors[(color & 0xF0) >> 4];
                        Color bg = colors[color & 0xF];
                        this.setPixel(px, py, Tms9918aVdp.getBit(line, linePos) ? fg : bg);
                    }
                }
                ++nameTablePtr;
            }
        }
    }

    private void setPixel(int px, int py, Color color) {
        this.screenDataLinear[py * 256 + px] = color.getRGB() & 0xFFFFFF;
    }

    public void drawMode1() {
        int nameTablePtr = this.getNameTableAddr();
        int patternTableBase = this.getPatternTableAddr();
        Color offBit = colors[this.getOffBitColor()];
        Color onBit = colors[this.getOnBitColor()];
        for (int y = 0; y < 24; ++y) {
            for (int x = 0; x < 40; ++x) {
                int patternIdx = this.mem[nameTablePtr] & 0xFF;
                int patternAddr = patternTableBase + (patternIdx << 3);
                for (int charLine = 0; charLine < 8; ++charLine) {
                    int line = this.mem[patternAddr + charLine] & 0xFF;
                    for (int linePos = 0; linePos < 6; ++linePos) {
                        int px = 5 + (x * 6 - linePos);
                        int py = y * 8 + charLine;
                        this.setPixel(px + 8, py, Tms9918aVdp.getBit(line, linePos + 2) ? onBit : offBit);
                    }
                }
                ++nameTablePtr;
            }
        }
    }

    public void drawMode2() {
        int nameTableBase = this.getNameTableAddr();
        int nameTableIdx = 0;
        int patternTableBase = this.getPG13() ? 8192 : 0;
        boolean bit0 = this.getRegisterBit(4, 0);
        boolean bit1 = this.getRegisterBit(4, 1);
        int colorTableBase = this.getCT13() ? 8192 : 0;
        for (int y = 0; y < 24; ++y) {
            for (int x = 0; x < 32; ++x) {
                int patternIdx = this.mem[nameTableBase + nameTableIdx] & 0xFF;
                int patternAddr = patternTableBase + (patternIdx << 3);
                if (bit0 && nameTableIdx / 256 == 1) {
                    patternAddr += 2048;
                }
                if (bit1 && nameTableIdx / 256 == 2) {
                    patternAddr += 4096;
                }
                for (int charLine = 0; charLine < 8; ++charLine) {
                    int line = this.mem[patternAddr + charLine] & 0xFF;
                    int colorTableAddr = colorTableBase + (patternIdx << 3);
                    if (bit0 && nameTableIdx / 256 == 1) {
                        colorTableAddr += 2048;
                    }
                    if (bit1 && nameTableIdx / 256 == 2) {
                        colorTableAddr += 4096;
                    }
                    int lineColor = this.mem[colorTableAddr + charLine] & 0xFF;
                    Color fg = colors[(lineColor & 0xF0) >> 4];
                    Color bg = colors[lineColor & 0xF];
                    int py = y * 8 + charLine;
                    for (int linePos = 0; linePos < 8; ++linePos) {
                        int px = 7 + (x * 8 - linePos);
                        this.setPixel(px, py, Tms9918aVdp.getBit(line, linePos) ? fg : bg);
                    }
                }
                ++nameTableIdx;
            }
        }
    }

    public void drawSprites() {
        int y;
        int x;
        int i;
        int patternTableAddr = this.getSpriteGenTable();
        boolean siFlag = this.getSI();
        for (i = 0; i < 192; ++i) {
            this.spriteLineCount[i] = 0;
        }
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 192; ++y) {
                this.spritePriorityMatrix[x][y] = false;
            }
        }
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 192; ++y) {
                this.spriteCollisionMatrix[x][y] = false;
            }
        }
        for (i = 0; i < 32 && (this.getSpriteY(i) & 0xFF) != 208; ++i) {
            int sx = this.getSpriteX(i) & 0xFF;
            int sy = (this.getSpriteY(i) & 0xFF) + 1;
            int patternIdx = this.getSpritePattern(i) & 0xFF;
            int colour = this.getSpriteColour(i);
            if ((colour & 0x80) != 0) {
                sx -= 32;
            }
            int yPos = sy;
            while (yPos < sy + (siFlag ? 16 : 8) && yPos < 192) {
                int n = yPos++;
                this.spriteLineCount[n] = this.spriteLineCount[n] + 1;
            }
            if ((colour & 0xF) == 0) continue;
            for (int qx = 0; qx < (siFlag ? 2 : 1); ++qx) {
                for (int qy = 0; qy < (siFlag ? 2 : 1); ++qy) {
                    int quadrantNumber = 2 * qx + qy;
                    for (int y2 = 0; y2 < 8; ++y2) {
                        for (int x2 = 0; x2 < 8; ++x2) {
                            boolean fill;
                            int xPos = sx + x2 + qx * 8;
                            int yPos2 = sy + y2 + qy * 8;
                            if (xPos >= 256 || yPos2 >= 192 || xPos < 0 || yPos2 < 0) continue;
                            if (this.spriteCollisionMatrix[xPos][yPos2]) {
                                this.setStatusC(true);
                            }
                            this.spriteCollisionMatrix[xPos][yPos2] = true;
                            boolean bl = fill = (this.mem[(short)(patternTableAddr + (8 * (patternIdx + quadrantNumber) + y2))] & 1 << 7 - x2) != 0;
                            if (!fill) continue;
                            if (this.spriteLineCount[yPos2] > 4) {
                                this.setStatus5S(true);
                                this.statusRegister = (byte)(this.statusRegister & 0xE0 | i & 0x1F);
                                continue;
                            }
                            if (this.spritePriorityMatrix[xPos][yPos2]) continue;
                            this.spritePriorityMatrix[xPos][yPos2] = true;
                            this.setPixel(xPos, yPos2, colors[colour & 0xF]);
                        }
                    }
                }
            }
        }
    }

    private void drawMode3() {
        if (!this.getBL()) {
            return;
        }
        int nameTableBase = this.getNameTableAddr();
        int patternTableBase = this.getPatternTableAddr();
        int nameTableAddr = nameTableBase;
        for (int y = 0; y < 24; ++y) {
            int py = y << 3;
            int ptShift = patternTableBase + ((y & 3) << 1);
            for (int x = 0; x < 32; ++x) {
                int px = x << 3;
                int patternTableAddr = ptShift + ((this.mem[nameTableAddr] & 0xFF) << 3);
                for (int i = 0; i < 2; ++i) {
                    int byteColor = this.mem[patternTableAddr] & 0xFF;
                    Color c1 = colors[byteColor >> 4 & 0xF];
                    Color c2 = colors[byteColor & 0xF];
                    int by = py + i * 4;
                    for (int blockIdx = 0; blockIdx < 4; ++blockIdx) {
                        int uy = by + blockIdx;
                        this.setPixel(px, uy, c1);
                        this.setPixel(px + 1, uy, c1);
                        this.setPixel(px + 2, uy, c1);
                        this.setPixel(px + 3, uy, c1);
                        this.setPixel(px + 4, uy, c2);
                        this.setPixel(px + 5, uy, c2);
                        this.setPixel(px + 6, uy, c2);
                        this.setPixel(px + 7, uy, c2);
                    }
                    ++patternTableAddr;
                }
                ++nameTableAddr;
            }
        }
    }

    private void drawScreen() {
        this.drawBackDrop();
        switch (this.vdpMode) {
            case MODE_0: {
                this.drawMode0();
                break;
            }
            case MODE_1: {
                this.drawMode1();
                break;
            }
            case MODE_2: {
                this.drawMode2();
                break;
            }
            case MODE_3: {
                this.drawMode3();
            }
        }
        if (!this.getM1() && this.getBL()) {
            this.drawSprites();
        }
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        IntStream.range(0, 16384).forEach(i -> {
            this.mem[i] = buffer.get();
        });
        IntStream.range(0, 8).forEach(i -> this.updateRegisterData(i, (int)buffer.get()));
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        IntStream.range(0, 16384).forEach(i -> buffer.put((byte)(this.mem[i] & 0xFF)));
        IntStream.range(0, 8).forEach(i -> buffer.put((byte)this.registers[i]));
    }

    @Override
    public List<BaseVdpAdapterEventSupport.VdpEventListener> getVdpEventListenerList() {
        return this.list;
    }

    public byte[] getVram() {
        return this.mem;
    }

    @Override
    public void dumpScreenData() {
        this.renderDump.saveRenderToFile(this.screenDataLinear, this.getVideoMode(), VdpMisc.RenderType.FULL);
    }
}

