/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.md;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.IntStream;
import omegadrive.SystemLoader;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.md.MdVdpMemoryInterface;
import omegadrive.vdp.md.VdpDmaHandlerImpl;
import omegadrive.vdp.md.VdpFifo;
import omegadrive.vdp.md.VdpInterruptHandler;
import omegadrive.vdp.md.VdpRenderHandlerImpl;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.InterlaceMode;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.VdpDmaHandler;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.model.VdpRenderHandler;
import omegadrive.vdp.util.UpdatableViewer;
import omegadrive.vdp.util.VdpDebugView;
import omegadrive.vdp.util.VdpPortAccessLogger;
import org.slf4j.Logger;

public class MdVdp
implements MdVdpProvider,
BaseVdpAdapterEventSupport.VdpEventListener {
    public static final boolean verbose = false;
    public static final boolean regVerbose = false;
    private static final Logger LOG = LogHelper.getLogger(MdVdp.class.getSimpleName());
    private static final boolean ENABLE_READ_AHEAD = Boolean.parseBoolean(System.getProperty("vdp.enable.read.ahead", "false"));
    private MdVdpProvider.VramMode vramMode;
    private InterlaceMode interlaceMode;
    final int[] registers = new int[24];
    final VdpFifo.VdpFifoEntry pendingReadEntry = new VdpFifo.VdpFifoEntry();
    boolean writePendingControlPort = false;
    int firstWrite;
    int addressRegister;
    int codeRegister;
    boolean lcb;
    int ieMask;
    boolean m3;
    boolean exVram;
    boolean displayEnable;
    boolean m1;
    boolean m2;
    boolean m5;
    boolean h40;
    boolean ste;
    int autoIncrementData;
    int vip;
    int sovr;
    int scol;
    int odd;
    int vb;
    int hb;
    int dma;
    int pal;
    int satStart;
    int fifoEmpty = 1;
    int fifoFull = 0;
    private MdMainBusProvider bus;
    protected VdpInterruptHandler interruptHandler;
    private VdpMemoryInterface memoryInterface;
    private VdpDmaHandler dmaHandler;
    private VdpRenderHandler renderHandler;
    private VdpFifo fifo;
    private VideoMode videoMode;
    private RegionDetector.Region region;
    private List<BaseVdpAdapterEventSupport.VdpEventListener> list;
    private UpdatableViewer debugViewer;
    private VdpPortAccessLogger vdpPortAccessLogger;
    private int lastControl = -1;
    private int lastVCounter = 0;
    private int lastHCounter = 0;

    public static MdVdp createInstance(MdMainBusProvider bus, VdpMemoryInterface memoryInterface, VdpDmaHandler dmaHandler, RegionDetector.Region region) {
        MdVdp v = new MdVdp();
        v.bus = bus;
        v.memoryInterface = memoryInterface;
        v.dmaHandler = dmaHandler;
        v.region = region;
        v.setupVdp();
        return v;
    }

    public static MdVdp createInstance(MdMainBusProvider bus, VdpMemoryInterface memoryInterface) {
        MdVdp v = new MdVdp();
        v.bus = bus;
        v.memoryInterface = memoryInterface;
        v.dmaHandler = VdpDmaHandlerImpl.createInstance(v, v.memoryInterface, bus);
        v.region = RegionDetector.Region.EUROPE;
        v.setupVdp();
        return v;
    }

    public static MdVdp createInstance(MdMainBusProvider bus) {
        return MdVdp.createInstance(bus, MdVdpMemoryInterface.createInstance());
    }

    private MdVdp() {
    }

    @Override
    public void init() {
        this.vb = 1;
        this.writeRegister(0, 4);
        this.writeRegister(1, 20);
        this.writeRegister(2, 48);
        this.writeRegister(3, 60);
        this.writeRegister(4, 7);
        this.writeRegister(5, 108);
        this.writeRegister(6, 0);
        this.writeRegister(7, 0);
        this.writeRegister(8, 0);
        this.writeRegister(9, 0);
        this.writeRegister(10, 255);
        IntStream.range(11, 24).forEach(i -> this.writeRegister(i, 0));
        this.initMode();
    }

    private void initMode() {
        this.vramMode = MdVdpProvider.VramMode.getVramMode(this.codeRegister & 0xF);
        this.interlaceMode = InterlaceMode.NONE;
        this.resetVideoMode(true);
        this.reloadRegisters();
    }

    private void reloadRegisters() {
        IntStream.range(0, 24).forEach(i -> this.updateVariables(i, this.registers[i]));
    }

    private void setupVdp() {
        this.list = SystemLoader.testMode ? new CopyOnWriteArrayList() : new ArrayList();
        this.list.add(this);
        this.interruptHandler = VdpInterruptHandler.createMdInstance(this);
        this.renderHandler = VdpRenderHandlerImpl.createInstance(this, this.memoryInterface);
        this.debugViewer = VdpDebugView.createInstance(this, this.memoryInterface, this.renderHandler);
        this.fifo = new VdpFifo();
        this.vdpPortAccessLogger = VdpPortAccessLogger.NO_LOGGER;
        this.initMode();
    }

    @Override
    public int getHCounter() {
        if (this.m3) {
            return this.lastHCounter;
        }
        return this.interruptHandler.getHCounterExternal();
    }

    @Override
    public int getRegisterData(int reg) {
        return this.registers[reg];
    }

    @Override
    public int getAddressRegister() {
        return this.addressRegister;
    }

    @Override
    public void setAddressRegister(int value) {
        this.addressRegister = value;
    }

    @Override
    public void updateRegisterData(int reg, int data) {
        this.writeRegister(reg, data);
    }

    @Override
    public boolean getVip() {
        return this.interruptHandler.isvIntPending();
    }

    @Override
    public void setVip(boolean value) {
        this.interruptHandler.setvIntPending(value);
        this.vip = value ? 1 : 0;
    }

    @Override
    public boolean getHip() {
        return this.interruptHandler.isHIntPending();
    }

    @Override
    public void setHip(boolean value) {
        assert (!value);
        this.interruptHandler.setHIntPending(false);
    }

    @Override
    public boolean isDisplayEnabled() {
        return this.displayEnable;
    }

    @Override
    public VideoMode getVideoMode() {
        return this.videoMode;
    }

    private VideoMode getVideoMode(RegionDetector.Region region, boolean isH40, boolean isV30) {
        return VideoMode.getVideoMode(region, isH40, isV30, this.videoMode);
    }

    @Override
    public boolean isShadowHighlight() {
        return this.ste;
    }

    @Override
    public int readVdpPortWord(MdVdpProvider.VdpPortType type) {
        this.writePendingControlPort = false;
        switch (type) {
            case DATA: {
                return this.readDataPort();
            }
            case CONTROL: {
                return this.readControl();
            }
        }
        LOG.error("Unexpected portType: {}", (Object)type);
        return 0;
    }

    private int readControl() {
        int control;
        if (!this.bus.is68kRunning()) {
            LOG.warn("readControl with 68k stopped, address: {}", (Object)this.addressRegister);
        }
        if ((control = this.fifoEmpty << 9 | this.fifoFull << 8 | this.vip << 7 | this.odd << 4 | this.vb << 3 | this.hb << 2 | this.dma << 1 | this.pal << 0) != this.lastControl) {
            this.lastControl = control;
        }
        return control;
    }

    private void writeControlPortInternal(int data) {
        int mode = data >>> 14;
        boolean isRegisterWrite = !this.writePendingControlPort && mode == 2;
        this.updateStateFromControlPortWrite(isRegisterWrite, data);
        if (isRegisterWrite) {
            this.writePendingControlPort = false;
            this.writeRegister(data);
        } else {
            this.writeControlReg(data);
        }
    }

    private void updateStateFromControlPortWrite(boolean isRegisterWrite, int data) {
        if (this.writePendingControlPort) {
            this.codeRegister = data >> 2 & 0xFF | this.codeRegister & 3;
            this.addressRegister = this.addressRegister & 0x3FFF | (data & 3) << 14;
        } else {
            this.codeRegister = this.codeRegister & 0x3C | data >> 14 & 3;
            this.addressRegister = this.addressRegister & 0xC000 | data & 0x3FFF;
        }
        boolean verboseCheck = !isRegisterWrite && this.writePendingControlPort;
        this.vramMode = MdVdpProvider.VramMode.getVramMode(this.codeRegister & 0xF, verboseCheck);
    }

    protected void writeDataPortInternal(int data) {
        this.writePendingControlPort = false;
        if (this.vramMode == null) {
            LogHelper.logWarnOnce(LOG, "Invalid writeDataPort, vramMode: null", new Object[0]);
        }
        this.fifoPush(this.addressRegister, data);
        this.addressRegister += this.autoIncrementData;
        this.dmaHandler.setupDmaFillMaybe(this.dma == 1, data);
    }

    @Override
    public void fifoPush(int addressRegister, int data) {
        int a = addressRegister;
        if (this.exVram) {
            a = (a & 2) >> 1 ^ 1 | (a & 0x400) >> 9 | a & 0x3FC | (a & 0x1F800) >> 1;
        }
        this.fifo.push(this.vramMode, a, data);
        this.updateFifoState(this.fifo);
    }

    private void fifoPop() {
        this.fifo.pop();
        this.updateFifoState(this.fifo);
    }

    private void writeDataToVram(boolean vramSlot) {
        boolean byteWide;
        boolean invalidEntry;
        if (!vramSlot || this.fifo.isEmpty()) {
            return;
        }
        boolean wasFull = this.fifo.isFull();
        boolean doWrite = true;
        VdpFifo.VdpFifoEntry entry = (VdpFifo.VdpFifoEntry)this.fifo.peek();
        boolean bl = invalidEntry = entry.vdpRamMode == null || !entry.vdpRamMode.isWriteMode();
        if (invalidEntry) {
            this.fifoPop();
            doWrite = false;
            this.evaluateVdpBusyState();
        }
        boolean bl2 = byteWide = entry.vdpRamMode == MdVdpProvider.VramMode.vramWrite;
        if (byteWide && !entry.firstByteWritten) {
            entry.firstByteWritten = true;
            doWrite = false;
        }
        if (doWrite) {
            this.fifoPop();
            if (this.exVram && entry.vdpRamMode == MdVdpProvider.VramMode.vramWrite) {
                this.memoryInterface.writeVideoRamByte(MdVdpProvider.VdpRamType.VRAM, entry.addressRegister, (byte)entry.data);
            } else {
                this.memoryInterface.writeVideoRamWord(entry.vdpRamMode, entry.data, entry.addressRegister);
            }
            if (wasFull && !this.fifo.isFull()) {
                this.evaluateVdpBusyState();
            }
        }
    }

    private int readDataPort() {
        if (!this.bus.is68kRunning()) {
            LOG.warn("readDataPort with 68k stopped, address: {}", (Object)this.addressRegister);
        }
        if (this.fifo.isFull()) {
            LOG.warn("readDataPort with FIFO full, address: {}", (Object)this.addressRegister);
        }
        if (!this.fifo.isEmpty()) {
            // empty if block
        }
        int value = this.readDataPortInternal();
        if (ENABLE_READ_AHEAD) {
            int readAhead = this.pendingReadEntry.data;
            this.pendingReadEntry.data = value;
            this.pendingReadEntry.vdpRamMode = this.vramMode;
            value = readAhead;
        }
        return value;
    }

    private int readDataPortInternal() {
        int res = this.memoryInterface.readVideoRamWord(this.vramMode, this.addressRegister);
        if (this.vramMode == null || this.vramMode.isWriteMode()) {
            LOG.error("Unexpected vramMode: {}, vdp should lock up", (Object)this.vramMode);
            return res;
        }
        int fifoData = ((VdpFifo.VdpFifoEntry)this.fifo.peek()).data;
        switch (this.vramMode) {
            case vramRead_8bit: {
                res = this.memoryInterface.readVideoRamByte(MdVdpProvider.VdpRamType.VRAM, this.addressRegister ^ 1);
                res = fifoData & 0xFF00 | res & 0xFF;
                break;
            }
            case cramRead: {
                res = fifoData & 0xF111 | res & 0xEEE;
                break;
            }
            case vsramRead: {
                res = fifoData & 0xF800 | res & 0x7FF;
                break;
            }
            case vramRead: {
                break;
            }
            default: {
                LOG.error("Unexpected vramMode: {}", (Object)this.vramMode);
            }
        }
        this.addressRegister += this.autoIncrementData;
        return res;
    }

    private void writeControlReg(int data) {
        if (!this.writePendingControlPort) {
            this.firstWrite = data;
            this.writePendingControlPort = true;
        } else {
            this.writePendingControlPort = false;
            int all = this.firstWrite << 16 | data;
            if ((this.codeRegister & 0x20) > 0) {
                VdpDmaHandler.DmaMode dmaMode = this.dmaHandler.setupDma(this.vramMode, all, this.m1);
                if (dmaMode == VdpDmaHandler.DmaMode.MEM_TO_VRAM) {
                    this.bus.setVdpBusyState(MdVdpProvider.VdpBusyState.MEM_TO_VRAM);
                }
            } else if (ENABLE_READ_AHEAD && (this.codeRegister & 1) == 0) {
                this.pendingReadEntry.data = this.readDataPortInternal();
                this.pendingReadEntry.vdpRamMode = this.vramMode;
            }
        }
    }

    private void writeRegister(int data) {
        this.writeRegister(data >> 8 & 0x1F, data & 0xFF);
    }

    private void writeRegister(int reg, int dataControl) {
        boolean invalidWrite;
        boolean bl = invalidWrite = reg >= 24 || !this.m5 && reg > 10;
        if (invalidWrite) {
            LogHelper.logWarnOnce(LOG, "Ignoring write to invalid VPD register: {}, mode5: {}", Util.th(reg), this.m5);
            return;
        }
        this.logRegisterChange(reg, dataControl);
        this.registers[reg] = dataControl;
        this.updateVariables(reg, dataControl);
    }

    @Override
    public int getVCounter() {
        if (this.m3) {
            return this.lastVCounter;
        }
        return this.interruptHandler.getVCounterExternal();
    }

    private void updateSatLocation() {
        int res = VdpRenderHandler.getSpriteTableLocation(this, this.videoMode.isH40());
        if (res != this.satStart) {
            this.satStart = res;
            this.memoryInterface.setSatBaseAddress(this.satStart);
        }
    }

    private void logRegisterChange(int reg, int data) {
        int current = this.registers[reg];
    }

    private void updateM3(boolean newM3) {
        if (newM3 && !this.m3) {
            this.lastVCounter = this.getVCounter();
            this.lastHCounter = this.getHCounter();
        }
        this.m3 = newM3;
    }

    private void updateIe(MdVdpProvider.VDP_INT ie, boolean newIe) {
        int prev = this.ieMask;
        this.ieMask = Util.setBit(this.ieMask, ie.ordinal(), newIe ? 1 : 0);
        if (prev != this.ieMask) {
            this.fireVdpEvent(ie.event, newIe);
        }
    }

    private void updateLcb(boolean newLcb) {
        if (newLcb != this.lcb) {
            this.lcb = newLcb;
            this.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.LEFT_COL_BLANK, this.lcb);
        }
    }

    private void doDma(boolean externalSlot) {
        if (externalSlot && this.dma == 1) {
            boolean dmaDone = this.dmaHandler.doDmaSlot(this.videoMode);
            int n = this.dma = dmaDone ? 0 : this.dma;
            if (this.dma == 0 && dmaDone) {
                this.evaluateVdpBusyState();
            }
        }
    }

    private void evaluateVdpBusyState() {
        MdVdpProvider.VdpBusyState state;
        MdVdpProvider.VdpBusyState vdpBusyState = state = this.fifo.isFull() ? MdVdpProvider.VdpBusyState.FIFO_FULL : MdVdpProvider.VdpBusyState.NOT_BUSY;
        if (state == MdVdpProvider.VdpBusyState.NOT_BUSY && this.dma == 1 && this.dmaHandler.dmaInProgress()) {
            state = MdVdpProvider.VdpBusyState.getVdpBusyState(this.dmaHandler.getDmaMode());
        }
        this.bus.setVdpBusyState(state);
    }

    @Override
    public int runSlot() {
        this.interruptHandler.increaseHCounterSlot();
        this.processExternalSlot();
        return this.interruptHandler.getVdpClockSpeed();
    }

    @Override
    public void writeVdpPortWord(MdVdpProvider.VdpPortType type, int data) {
        if (this.vdpPortAccessLogger != VdpPortAccessLogger.NO_LOGGER) {
            this.vdpPortAccessLogger.logVdpWrite(type, data);
        }
        switch (type) {
            case DATA: {
                this.writeDataPortInternal(data);
                break;
            }
            case CONTROL: {
                this.writeControlPortInternal(data);
            }
        }
        this.evaluateVdpBusyState();
    }

    private void updateVariables(int regNumber, int data) {
        MdVdpProvider.VdpRegisterName reg = MdVdpProvider.VdpRegisterName.getRegisterName(regNumber);
        switch (reg) {
            case MODE_1: {
                this.updateLcb(Util.bitSetTest(data, 5));
                this.updateM3(Util.bitSetTest(data, 1));
                this.updateIe(MdVdpProvider.VDP_INT.IE1, Util.bitSetTest(data, 4));
                break;
            }
            case MODE_2: {
                boolean ext = Util.bitSetTest(data, 7);
                if (this.exVram != ext) {
                    this.exVram = ext;
                    if (this.exVram) {
                        LogHelper.logWarnOnce(LOG, "128kb VRAM Mode: {}", this.exVram);
                    }
                }
                this.displayEnable = Util.bitSetTest(data, 6);
                this.updateIe(MdVdpProvider.VDP_INT.IE0, Util.bitSetTest(data, 5));
                this.m1 = Util.bitSetTest(data, 4);
                this.m2 = Util.bitSetTest(data, 3);
                boolean mode5 = Util.bitSetTest(data, 2);
                if (this.m5 != mode5) {
                    LOG.info("Mode5: {}", (Object)mode5);
                    this.m5 = mode5;
                }
                this.handleDisplayEnabled();
                break;
            }
            case MODE_4: {
                boolean rs0 = Util.bitSetTest(data, 7);
                boolean rs1 = Util.bitSetTest(data, 0);
                if (rs0 != rs1) {
                    LogHelper.logWarnOnce(LOG, "rs0 and rs1 not matching, using rs1=" + rs1, new Object[0]);
                    rs0 = rs1;
                }
                this.h40 = rs1 && rs0;
                boolean val = Util.bitSetTest(data, 3);
                if (val != this.ste) {
                    // empty if block
                }
                this.ste = val;
                InterlaceMode prev = this.interlaceMode;
                this.interlaceMode = InterlaceMode.getInterlaceMode((data & 7) >> 1);
                if (prev != this.interlaceMode) {
                    LOG.info("InterlaceMode {} -> {}", (Object)prev, (Object)this.interlaceMode);
                }
                this.fireVdpEventOnChange(BaseVdpAdapterEventSupport.VdpEvent.INTERLACE_MODE_CHANGE, (Object)prev, (Object)this.interlaceMode);
                break;
            }
            case AUTO_INCREMENT: {
                this.autoIncrementData = data;
                break;
            }
            case HCOUNTER_VALUE: {
                this.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.REG_H_LINE_COUNTER_CHANGE, data);
                break;
            }
            case SPRITE_TABLE_LOC: {
                this.updateSatLocation();
                break;
            }
            case MODE_3: {
                this.updateIe(MdVdpProvider.VDP_INT.IE2, Util.bitSetTest(data, 3));
                break;
            }
        }
    }

    private void processExternalSlot() {
        boolean isExternalSlot = this.interruptHandler.isExternalSlot(this.vb == 1);
        if (this.fifo.isEmpty()) {
            this.doDma(isExternalSlot);
        }
        this.writeDataToVram(isExternalSlot);
    }

    private void updateFifoState(VdpFifo fifo) {
        this.fifoFull = fifo.isFullBit();
        this.fifoEmpty = fifo.isEmptyBit();
    }

    @Override
    public void onVdpEvent(BaseVdpAdapterEventSupport.VdpEvent event, Object value) {
        switch (event) {
            case VDP_ACTIVE_DISPLAY_CHANGE: {
                if (((Boolean)value).booleanValue()) break;
                this.handleEndOfActiveDisplay();
                break;
            }
            case H_BLANK_CHANGE: {
                this.hb = (Boolean)value != false ? 1 : 0;
                break;
            }
            case V_BLANK_CHANGE: {
                boolean valv = (Boolean)value;
                this.handleDisplayEnabled();
                if (!valv) break;
                this.handleVBlankOn();
                break;
            }
            case VDP_VINT_PENDING: {
                boolean valvip = (Boolean)value;
                this.vip = valvip ? 1 : this.vip;
            }
        }
    }

    private void handleDisplayEnabled() {
        this.vb = this.interruptHandler.isvBlankSet() || !this.displayEnable ? 1 : 0;
    }

    private void handleVBlankOn() {
        int prevOdd = this.odd;
        this.odd = this.interlaceMode.isInterlaced() ? this.odd + 1 & 1 : this.odd;
        this.fireVdpEventOnChange(BaseVdpAdapterEventSupport.VdpEvent.INTERLACE_FIELD_CHANGE, prevOdd, this.odd);
        this.debugViewer.update();
        this.list.forEach(BaseVdpAdapterEventSupport.VdpEventListener::onNewFrame);
        this.resetVideoMode(false);
    }

    private void handleEndOfActiveDisplay() {
        this.renderHandler.renderLine(this.interruptHandler.vCounterInternal);
        this.debugViewer.updateLine(this.interruptHandler.vCounterInternal);
    }

    @Override
    public void resetVideoMode(boolean force) {
        VideoMode newVideoMode = this.getVideoMode(this.region, this.h40, this.m2);
        if (this.videoMode != newVideoMode || force) {
            this.videoMode = newVideoMode;
            LOG.info("Video mode changed: {}, {}", (Object)this.videoMode, (Object)this.videoMode.getDimension());
            this.pal = this.videoMode.isPal() ? 1 : 0;
            this.updateSatLocation();
            this.fireVdpEvent(BaseVdpAdapterEventSupport.VdpEvent.VIDEO_MODE, (Object)newVideoMode);
        }
    }

    @Override
    public int[] getScreenDataLinear() {
        return this.renderHandler.getScreenDataLinear();
    }

    @Override
    public List<BaseVdpAdapterEventSupport.VdpEventListener> getVdpEventListenerList() {
        return this.list;
    }

    public VdpPortAccessLogger toggleVdpPortAccessLogger(boolean enable) {
        if (!enable) {
            this.vdpPortAccessLogger.reset();
            this.vdpPortAccessLogger = VdpPortAccessLogger.NO_LOGGER;
        } else {
            this.vdpPortAccessLogger = new VdpPortAccessLogger(this.interruptHandler);
        }
        return this.vdpPortAccessLogger;
    }

    @Override
    public void dumpScreenData() {
        this.renderHandler.dumpScreenData();
    }

    @Override
    public void setDmaFlag(int value) {
        this.dma = value;
    }

    @Override
    public VdpFifo getFifo() {
        return this.fifo;
    }

    @Override
    public VdpMemoryInterface getVdpMemory() {
        return this.memoryInterface;
    }

    @Override
    public MdVdpProvider.VramMode getVramMode() {
        return this.vramMode;
    }

    @Override
    public InterlaceMode getInterlaceMode() {
        return this.interlaceMode;
    }

    @Override
    public String getVdpStateString() {
        return this.getVdpStateString("");
    }

    private String getVdpStateString(String head) {
        return this.interruptHandler.getStateString(head + " - ") + ", ie0_VINT" + (this.ieMask & MdVdpProvider.VDP_INT.IE0.ordinal()) + ",ie1_HINT" + (this.ieMask & MdVdpProvider.VDP_INT.IE1.ordinal());
    }

    public UpdatableViewer getDebugViewer() {
        return this.debugViewer;
    }

    @Override
    public void setRegion(RegionDetector.Region region) {
        this.region = region;
    }

    @Override
    public void reload() {
        this.initMode();
        IntStream.range(0, 128).forEach(i -> this.memoryInterface.writeVideoRamByte(MdVdpProvider.VdpRamType.CRAM, i, this.memoryInterface.readVideoRamByte(MdVdpProvider.VdpRamType.CRAM, i)));
        this.renderHandler.initLineData(0);
    }

    @Override
    public void reset() {
        this.debugViewer.reset();
        this.list.clear();
    }
}

