/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.md;

import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.md.VdpFifo;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.VdpDmaHandler;
import omegadrive.vdp.model.VdpMemoryInterface;
import org.slf4j.Logger;

public class VdpDmaHandlerImpl
implements VdpDmaHandler {
    public static final boolean verbose = false;
    public static final boolean lessVerbose = false;
    public static final boolean printToSysOut = false;
    private static final Logger LOG = LogHelper.getLogger(VdpDmaHandlerImpl.class.getSimpleName());
    protected MdVdpProvider vdpProvider;
    protected VdpMemoryInterface memoryInterface;
    protected MdMainBusProvider busProvider;
    private int dmaFillData;
    private VdpDmaHandler.DmaMode dmaMode = null;
    private boolean dmaFillReady;
    private final VdpFifo.VdpFifoEntry pendingReadEntry = new VdpFifo.VdpFifoEntry();

    public static VdpDmaHandler createInstance(MdVdpProvider vdpProvider, VdpMemoryInterface memoryInterface, MdMainBusProvider busProvider) {
        VdpDmaHandlerImpl d = new VdpDmaHandlerImpl();
        d.vdpProvider = vdpProvider;
        d.busProvider = busProvider;
        d.memoryInterface = memoryInterface;
        return d;
    }

    @Override
    public VdpDmaHandler.DmaMode setupDma(MdVdpProvider.VramMode vramMode, int data, boolean m1) {
        if (!m1) {
            return null;
        }
        this.dmaMode = this.getDmaMode(this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.DMA_SOURCE_HIGH), vramMode);
        if (this.dmaMode != null) {
            this.vdpProvider.setDmaFlag(1);
            this.printLessVerboseInfo(this.dmaMode == VdpDmaHandler.DmaMode.VRAM_FILL ? "SETUP" : "START");
            this.handleDmaFastMemory();
        }
        return this.dmaMode;
    }

    private void handleDmaFastMemory() {
        boolean megaCdDma;
        if (this.dmaMode != VdpDmaHandler.DmaMode.MEM_TO_VRAM) {
            return;
        }
        int dmaSrcHigh = this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.DMA_SOURCE_HIGH);
        boolean svpDma = this.busProvider.isSvp() && (dmaSrcHigh & 0x60) == 0;
        boolean isMegaCd = this.busProvider.getSystem().getSystemType().isMegaCdAttached();
        boolean bl = megaCdDma = isMegaCd && ((dmaSrcHigh & 0xF0) == 48 || (dmaSrcHigh & 0xF0) == 16);
        if (isMegaCd && ((dmaSrcHigh & 0xFF) == 2 || (dmaSrcHigh & 0xFF) == 3)) assert (false);
        if (megaCdDma || svpDma) {
            this.decreaseDmaLength();
            this.increaseDestAddress();
        }
    }

    @Override
    public void setupDmaFillMaybe(boolean isDma, int data) {
        if (isDma && this.dmaMode == VdpDmaHandler.DmaMode.VRAM_FILL) {
            if (!this.dmaFillReady) {
                this.printLessVerboseInfo("START");
                this.dmaFillReady = true;
            }
            this.dmaFillData = data;
        }
    }

    @Override
    public boolean dmaInProgress() {
        return this.dmaMode != null && this.dmaMode == VdpDmaHandler.DmaMode.VRAM_FILL && this.dmaFillReady || this.dmaMode != null && this.dmaMode != VdpDmaHandler.DmaMode.VRAM_FILL;
    }

    private int getDmaLength() {
        return this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.DMA_LENGTH_HIGH) << 8 | this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.DMA_LENGTH_LOW);
    }

    private int getSourceAddressLow() {
        int reg22 = this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.DMA_SOURCE_MID);
        int reg21 = this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.DMA_SOURCE_LOW);
        return (reg22 & 0xFF) << 8 | reg21;
    }

    private int getSourceAddress() {
        int sourceAddress = this.getSourceAddressLow();
        if (this.dmaMode == VdpDmaHandler.DmaMode.MEM_TO_VRAM) {
            sourceAddress = (this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.DMA_SOURCE_HIGH) & 0x7F) << 16 | sourceAddress;
        }
        return sourceAddress;
    }

    private int getDestAddress() {
        return this.vdpProvider.getAddressRegister();
    }

    private void printInfo(String head) {
        this.printInfo(head, Integer.MIN_VALUE);
    }

    private void printLessVerboseInfo(String head) {
    }

    private void printInfo(String head, int srcAddress, int data) {
    }

    private void printInfo(String head, int srcAddress) {
    }

    private void printInfoLess(String head, int srcAddress, Integer data) {
        String str = this.getDmaStateString(head, srcAddress, data);
        LogHelper.logWarnOnce(LOG, str, new Object[0]);
    }

    @Override
    public String getDmaStateString() {
        return this.getDmaStateString("", Integer.MIN_VALUE, null);
    }

    private String getDmaStateString(String head, int srcAddress, Integer data) {
        int dmaLen = this.getDmaLength();
        String str = String.valueOf((Object)this.dmaMode) + " " + head;
        String src = Util.th(srcAddress > Integer.MIN_VALUE ? srcAddress : this.getSourceAddress());
        String dest = Util.th(this.getDestAddress());
        int destAddressIncrement = this.getDestAddressIncrement();
        str = str + (this.dmaMode == VdpDmaHandler.DmaMode.VRAM_FILL ? " fillData: " + Util.th(this.dmaFillData) : " srcAddr: " + src);
        str = str + ", destAddr: " + dest + ", destAddrInc: " + destAddressIncrement + ", dmaLen: " + dmaLen + (String)(data != null ? ", data: " + Util.th(data) : "") + ", vramMode: " + String.valueOf((Object)this.vdpProvider.getVramMode());
        str = str + this.vdpProvider.getVdpStateString();
        return str;
    }

    @Override
    public VdpDmaHandler.DmaMode getDmaMode() {
        return this.dmaMode;
    }

    @Override
    public boolean doDmaSlot(VideoMode videoMode) {
        int delay = MdRuntimeData.getCpuDelayExt(BufferUtil.CpuDeviceAccess.M68K);
        BufferUtil.CpuDeviceAccess prev = MdRuntimeData.setAccessTypeExt(BufferUtil.CpuDeviceAccess.M68K);
        boolean done = true;
        switch (this.dmaMode) {
            case VRAM_FILL: {
                if (this.dmaFillReady) {
                    this.dmaFillSingleByte();
                }
                done = this.dmaFillReady;
                break;
            }
            case VRAM_COPY: {
                this.dmaCopySingleByte();
                break;
            }
            case MEM_TO_VRAM: {
                this.dma68kToVram();
                break;
            }
            default: {
                LOG.error("Unexpected dma setting: {}", (Object)this.dmaMode);
            }
        }
        if (done &= this.getDmaLength() == 0) {
            this.printLessVerboseInfo("DONE");
            this.dmaMode = null;
            this.dmaFillReady = false;
        }
        MdRuntimeData.resetCpuDelayExt(BufferUtil.CpuDeviceAccess.M68K, delay);
        MdRuntimeData.setAccessTypeExt(prev);
        return done;
    }

    private void dmaFillSingleByte() {
        this.dmaVramWriteByte((byte)(this.dmaFillData >> 8));
    }

    private void dmaVramWriteByte(byte data) {
        int destAddress = this.getDestAddress() ^ 1;
        this.printInfo("IN PROGRESS - WRITE");
        this.memoryInterface.writeVideoRamByte(MdVdpProvider.VdpRamType.VRAM, destAddress, data);
        this.postDmaRegisters();
    }

    private void postDmaRegisters() {
        this.decreaseDmaLength();
        this.increaseSourceAddress(1);
        this.increaseDestAddress();
    }

    private void dmaCopySingleByte() {
        if (this.pendingReadEntry.vdpRamMode == null) {
            int sourceAddress = this.getSourceAddress() ^ 1;
            byte data = this.memoryInterface.readVideoRamByte(MdVdpProvider.VdpRamType.VRAM, sourceAddress);
            this.pendingReadEntry.vdpRamMode = MdVdpProvider.VramMode.vramWrite;
            this.pendingReadEntry.data = data;
            this.printInfo("IN PROGRESS - READ");
        } else {
            this.dmaVramWriteByte((byte)this.pendingReadEntry.data);
            this.pendingReadEntry.vdpRamMode = null;
            this.pendingReadEntry.data = 0;
        }
    }

    private int decreaseDmaLength() {
        int dmaLen = this.getDmaLength();
        dmaLen = dmaLen - 1 & 0xFFFF;
        this.vdpProvider.updateRegisterData(MdVdpProvider.VdpRegisterName.DMA_LENGTH_LOW, dmaLen & 0xFF);
        this.vdpProvider.updateRegisterData(MdVdpProvider.VdpRegisterName.DMA_LENGTH_HIGH, dmaLen >> 8);
        return dmaLen;
    }

    private void increaseDestAddress() {
        int destAddress = this.getDestAddress() + this.getDestAddressIncrement() & 0xFFFF;
        this.vdpProvider.setAddressRegister(destAddress);
    }

    private void increaseSourceAddress(int inc) {
        int sourceAddress = this.getSourceAddressLow() + inc & 0xFFFF;
        this.setSourceAddress(sourceAddress);
    }

    private void setSourceAddress(int sourceAddress) {
        int reg22 = sourceAddress >> 8 & 0xFF;
        int reg21 = sourceAddress & 0xFF;
        this.vdpProvider.updateRegisterData(MdVdpProvider.VdpRegisterName.DMA_SOURCE_LOW, reg21);
        this.vdpProvider.updateRegisterData(MdVdpProvider.VdpRegisterName.DMA_SOURCE_MID, reg22);
    }

    private int getDestAddressIncrement() {
        return this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.AUTO_INCREMENT);
    }

    private void dma68kToVram() {
        int sourceAddress = this.getSourceAddress() << 1;
        int destAddress = this.getDestAddress();
        int dataWord = this.busProvider.read(sourceAddress, Size.WORD);
        this.vdpProvider.fifoPush(destAddress, dataWord);
        this.printInfo("IN PROGRESS: ", sourceAddress, dataWord);
        this.postDmaRegisters();
    }

    private VdpDmaHandler.DmaMode getDmaMode(int reg17, MdVdpProvider.VramMode vramMode) {
        int dmaBits = reg17 >> 6;
        VdpDmaHandler.DmaMode mode = null;
        switch (dmaBits) {
            case 3: {
                mode = VdpDmaHandler.DmaMode.VRAM_COPY;
                break;
            }
            case 2: {
                if (vramMode != MdVdpProvider.VramMode.vramWrite) break;
                mode = VdpDmaHandler.DmaMode.VRAM_FILL;
                break;
            }
            case 0: 
            case 1: {
                if (vramMode == null || !vramMode.isWriteMode()) break;
                mode = VdpDmaHandler.DmaMode.MEM_TO_VRAM;
            }
        }
        if (mode == null) {
            LOG.error("Unexpected setup: {}, vramDestination: {}", (Object)dmaBits, (Object)vramMode);
        }
        return mode;
    }
}

