/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.md;

import java.util.stream.IntStream;
import omegadrive.util.Fifo;
import omegadrive.vdp.model.MdVdpProvider;

public class VdpFifo
extends Fifo.FixedSizeFifo<VdpFifoEntry> {
    public static final int VDP_FIFO_SIZE = 4;

    public VdpFifo() {
        super(4);
        this.fifo = new VdpFifoEntry[4];
        IntStream.range(0, 4).forEach(i -> {
            ((VdpFifoEntry[])this.fifo)[i] = new VdpFifoEntry();
        });
    }

    public void push(MdVdpProvider.VramMode vdpRamMode, int addressReg, int data) {
        if (this.isFull()) {
            LOG.info("FIFO full");
            return;
        }
        VdpFifoEntry entry = ((VdpFifoEntry[])this.fifo)[this.pushPointer];
        entry.data = data;
        entry.addressRegister = addressReg;
        entry.vdpRamMode = vdpRamMode;
        entry.firstByteWritten = false;
        this.push(entry);
    }

    public static class VdpFifoEntry {
        public MdVdpProvider.VdpPortType portType;
        public MdVdpProvider.VramMode vdpRamMode;
        public int addressRegister;
        public int data;
        public boolean firstByteWritten;

        public String toString() {
            return "VdpFifoEntry{portType=" + String.valueOf((Object)this.portType) + ", vdpRamMode=" + String.valueOf((Object)this.vdpRamMode) + ", addressRegister=" + this.addressRegister + ", data=" + this.data + ", firstByteWritten=" + this.firstByteWritten + "}";
        }
    }
}

