/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.md;

import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.BiConsumer;
import omegadrive.util.FastBitSet;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import omegadrive.util.VideoMode;
import omegadrive.vdp.VdpRenderDump;
import omegadrive.vdp.md.VdpColorMapper;
import omegadrive.vdp.md.VdpScrollHandler;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.InterlaceMode;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.RenderPriority;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.model.VdpMisc;
import omegadrive.vdp.model.VdpRenderHandler;
import org.slf4j.Logger;

public class VdpRenderHandlerImpl
implements VdpRenderHandler,
BaseVdpAdapterEventSupport.VdpEventListener {
    private static final Logger LOG = LogHelper.getLogger(VdpRenderHandlerImpl.class.getSimpleName());
    private final MdVdpProvider vdpProvider;
    private final VdpMemoryInterface memoryInterface;
    private final VdpScrollHandler scrollHandler;
    private final VdpRenderDump renderDump;
    private int spritesFrame = 0;
    private boolean shadowHighlightMode;
    private VideoMode videoMode;
    private VideoMode newVideoMode;
    private final VdpColorMapper colorMapper;
    private boolean lcb;
    private static final BiConsumer<VdpRenderHandler.SpriteDataHolder, VdpRenderHandler.SpriteDataHolder> updatePhase1DataFn = (src, dest) -> {
        dest.verticalPos = src.verticalPos;
        dest.linkData = src.linkData;
        dest.verticalCellSize = src.verticalCellSize;
        dest.horizontalCellSize = src.horizontalCellSize;
        dest.spriteNumber = src.spriteNumber;
    };
    private VdpRenderHandler.SpriteDataHolder[] spriteDataHoldersCurrent = new VdpRenderHandler.SpriteDataHolder[20];
    private final int[] planeA = new int[320];
    private final int[] planeB = new int[320];
    private final int[] planeBack = new int[320];
    private final int[] sprites = new int[320];
    private int[] linearScreen = new int[0];
    private final VdpRenderHandler.SpriteDataHolder spriteDataHolder = new VdpRenderHandler.SpriteDataHolder();
    private int spriteTableLocation = 0;
    private int spritePixelLineCount;
    private final VdpScrollHandler.ScrollContext scrollContextA;
    private final VdpScrollHandler.ScrollContext scrollContextB;
    private final VdpRenderHandler.WindowPlaneContext windowPlaneContext;
    private InterlaceMode interlaceMode = InterlaceMode.NONE;
    private final ByteBuffer vram;
    private final ByteBuffer cram;
    private final int[] javaPalette;
    private int activeLines = 0;
    private VdpRenderHandler.SpriteDataHolder[] spriteDataHoldersNext = new VdpRenderHandler.SpriteDataHolder[20];
    private final VdpRenderHandler.PixelData[] linePixelData = new VdpRenderHandler.PixelData[320];
    private int odd;

    public static VdpRenderHandler createInstance(MdVdpProvider vdpProvider, VdpMemoryInterface memoryInterface) {
        return new VdpRenderHandlerImpl(vdpProvider, memoryInterface);
    }

    public static VdpRenderHandler.TileDataHolder getTileData(int nameTable, InterlaceMode interlaceMode, VdpRenderHandler.TileDataHolder holder) {
        holder.tileIndex = (nameTable & 0x7FF) << interlaceMode.tileShift();
        holder.horFlip = (nameTable & 0x800) > 0;
        holder.vertFlip = (nameTable & 0x1000) > 0;
        holder.paletteLineIndex = (nameTable >> 13 & 3) << 5;
        holder.priority = (nameTable & 0x8000) > 0;
        holder.horFlipAmount = holder.horFlip ? 7 : 0;
        holder.vertFlipAmount = holder.vertFlip ? interlaceMode.getVerticalCellPixelSize() - 1 : 0;
        return holder;
    }

    private VdpRenderHandler.TileDataHolder getTileData(int nameTable, VdpRenderHandler.TileDataHolder holder) {
        return VdpRenderHandlerImpl.getTileData(nameTable, this.interlaceMode, holder);
    }

    private void initVideoMode() {
        if (this.newVideoMode != this.videoMode) {
            Dimension d = this.newVideoMode.getDimension();
            this.linearScreen = new int[d.width * d.height];
            this.videoMode = this.newVideoMode;
            this.activeLines = d.height;
        }
    }

    public VdpRenderHandlerImpl(MdVdpProvider vdpProvider, VdpMemoryInterface memoryInterface) {
        int i;
        this.vdpProvider = vdpProvider;
        this.memoryInterface = memoryInterface;
        this.colorMapper = VdpColorMapper.getInstance();
        this.renderDump = new VdpRenderDump();
        this.scrollHandler = VdpScrollHandler.createInstance(memoryInterface);
        this.vram = memoryInterface.getVram();
        this.cram = memoryInterface.getCram();
        this.javaPalette = memoryInterface.getJavaColorPalette();
        this.scrollContextA = VdpScrollHandler.ScrollContext.createInstance(VdpMisc.RenderType.PLANE_A, this.planeA);
        this.scrollContextB = VdpScrollHandler.ScrollContext.createInstance(VdpMisc.RenderType.PLANE_B, this.planeB);
        this.windowPlaneContext = new VdpRenderHandler.WindowPlaneContext();
        vdpProvider.addVdpEventListener(this);
        for (i = 0; i < 20; ++i) {
            this.spriteDataHoldersCurrent[i] = new VdpRenderHandler.SpriteDataHolder();
            this.spriteDataHoldersNext[i] = new VdpRenderHandler.SpriteDataHolder();
        }
        for (i = 0; i < 320; ++i) {
            this.linePixelData[i] = new VdpRenderHandler.PixelData();
        }
        this.clearDataLine();
        this.clearDataFrame();
    }

    @Override
    public void renderLine(int line) {
        if (line >= this.activeLines) {
            return;
        }
        this.initLineData(line);
        this.renderBack();
        this.phase1(line + 1);
        boolean disp = this.vdpProvider.isDisplayEnabled();
        if (!disp) {
            this.composeImageLinearLine(line);
            return;
        }
        this.shadowHighlightMode = this.vdpProvider.isShadowHighlight();
        this.renderSprites(line);
        this.renderWindow(line);
        this.renderPlaneA(line);
        this.renderPlaneB(line);
        this.composeImageLinearLine(line);
    }

    public static VdpRenderHandler.SpriteDataHolder getSpriteData(ByteBuffer vram, int vramOffset, InterlaceMode interlaceMode, VdpRenderHandler.SpriteDataHolder holder) {
        int byte4 = vram.get(vramOffset + 4) & 0xFF;
        int byte5 = vram.get(vramOffset + 5) & 0xFF;
        int byte6 = vram.get(vramOffset + 6) & 0xFF;
        int byte7 = vram.get(vramOffset + 7) & 0xFF;
        holder.tileIndex = ((byte4 & 7) << 8 | byte5) << interlaceMode.tileShift() & interlaceMode.getTileIndexMask();
        holder.paletteLineIndex = (byte4 >> 5 & 3) << 5;
        holder.priority = Util.bitSetTest(byte4, 7);
        holder.vertFlip = Util.bitSetTest(byte4, 4);
        holder.horFlip = Util.bitSetTest(byte4, 3);
        holder.horizontalPos = (byte6 & 1) << 8 | byte7;
        holder.horFlipAmount = holder.horFlip ? (holder.horizontalCellSize << 3) - 1 : 0;
        holder.vertFlipAmount = holder.vertFlip ? (holder.verticalCellSize << 3) - 1 : 0;
        return holder;
    }

    @Override
    public void initLineData(int line) {
        if (line == 0) {
            this.initVideoMode();
            this.clearDataFrame();
            this.phase1(0);
        }
        this.scrollContextB.hScrollTableLocation = this.scrollContextA.hScrollTableLocation = VdpRenderHandler.getHScrollDataLocation(this.vdpProvider);
        this.spriteTableLocation = VdpRenderHandler.getSpriteTableLocation(this.vdpProvider, this.videoMode.isH40());
        this.clearDataLine();
    }

    private void clearDataLine() {
        Arrays.fill(this.sprites, 0);
        Arrays.fill(this.planeA, 0);
        Arrays.fill(this.planeB, 0);
        for (int i = 0; i < this.linePixelData.length; ++i) {
            this.linePixelData[i].reset(this.shadowHighlightMode);
        }
        VdpRenderHandler.SpriteDataHolder[] temp = this.spriteDataHoldersCurrent;
        this.spriteDataHoldersCurrent = this.spriteDataHoldersNext;
        for (int i = 0; i < this.spriteDataHoldersCurrent.length; ++i) {
            temp[i].spriteNumber = -1;
        }
        this.spriteDataHoldersNext = temp;
    }

    private void clearDataFrame() {
        for (int i = 0; i < this.spriteDataHoldersCurrent.length; ++i) {
            this.spriteDataHoldersCurrent[i].spriteNumber = -1;
            this.spriteDataHoldersNext[i].spriteNumber = -1;
        }
        this.spritesFrame = 0;
    }

    private void phase1(int line) {
        boolean isH40 = this.videoMode.isH40();
        int maxSpritesPerFrame = VdpRenderHandler.maxSpritesPerFrame(isH40);
        int maxSpritesPerLine = VdpRenderHandler.maxSpritesPerLine(isH40);
        int count = 0;
        if (this.spritesFrame >= maxSpritesPerFrame) {
            return;
        }
        VdpRenderHandler.SpriteDataHolder holder = this.spriteDataHolder;
        int next = 0;
        boolean stop = false;
        for (int index = 0; index < maxSpritesPerFrame && !stop; ++index) {
            int current = next;
            holder = this.getPhase1SpriteData(current, holder);
            next = holder.linkData;
            int verSizePixels = holder.verticalCellSize + 1 << 3;
            int realY = holder.verticalPos - 128;
            boolean isSpriteOnLine = line >= realY && line < realY + verSizePixels;
            boolean bl = stop = next == 0 || next >= maxSpritesPerFrame;
            if (!isSpriteOnLine) continue;
            updatePhase1DataFn.accept(holder, this.spriteDataHoldersNext[count]);
            this.spritesFrame += line == realY ? 1 : 0;
            stop |= ++count >= maxSpritesPerLine || this.spritesFrame >= maxSpritesPerFrame;
        }
    }

    private void renderSprite(VdpRenderHandler.SpriteDataHolder holder, int tileBytePointerBase, int horOffset, int spritePixelLineLimit) {
        RenderPriority priority = holder.priority ? RenderPriority.SPRITE_PRIO : RenderPriority.SPRITE_NO_PRIO;
        int tileBytePos = 0;
        while (tileBytePos < 4 && this.spritePixelLineCount < spritePixelLineLimit) {
            this.spritePixelLineCount += 2;
            int tileShift = tileBytePos ^ holder.horFlipAmount & 3;
            int tileBytePointer = tileBytePointerBase + tileShift;
            this.storeSpriteData(priority, tileBytePointer, horOffset, holder, 0);
            this.storeSpriteData(priority, tileBytePointer, horOffset + 1, holder, 1);
            ++tileBytePos;
            horOffset += 2;
        }
    }

    private void storeSpriteData(RenderPriority priority, int tileBytePointer, int horOffset, VdpRenderHandler.SpriteDataHolder holder, int pixelInTile) {
        int cramIndexColor;
        if (horOffset < 0 || horOffset >= 320 || this.linePixelData[horOffset].pixelPriority.getRenderType() == VdpMisc.RenderType.SPRITE) {
            return;
        }
        int pixelIndex = this.getPixelIndexColor(tileBytePointer, pixelInTile, holder.horFlipAmount);
        this.sprites[horOffset] = cramIndexColor = holder.paletteLineIndex + (pixelIndex << 1);
        this.updatePixelData(horOffset, priority, this.sprites[horOffset]);
    }

    private static void getPlaneCells(VdpRenderHandler.WindowPlaneContext wpc, int cellWidth) {
        if (wpc.startHCell == wpc.endHCell) {
            wpc.startHCellPlane = 0;
            wpc.endHCellPlane = cellWidth;
        } else if (wpc.startHCell == 0) {
            wpc.startHCellPlane = wpc.endHCell;
            wpc.endHCellPlane = cellWidth;
        } else if (wpc.endHCell == cellWidth) {
            wpc.startHCellPlane = 0;
            wpc.endHCellPlane = wpc.startHCell;
        } else {
            LOG.error("Unexpected windowPlane setup: {}, {}", (Object)wpc.startHCell, (Object)wpc.endHCell);
            wpc.startHCellPlane = 0;
            wpc.endHCellPlane = cellWidth;
        }
    }

    private int getPixelFromLayerSh(int col) {
        VdpMisc.ShadowHighlightType shadowHighlight = this.processShadowHighlight(col);
        VdpRenderHandler.PixelData pxData = this.linePixelData[col];
        int cramIndex = this.planeBack[col];
        int blanking = 1;
        for (int i = RenderPriority.enums.length - 1; i > 0; --i) {
            RenderPriority rp = RenderPriority.enums[i];
            int rt = rp.getRenderType().ordinal();
            if (pxData.priorityMap.get(rt) != rp.getPriorityType().ordinal() > 0 || (pxData.cramIndexMap[rt] & 0x1F) == 0) continue;
            cramIndex = pxData.cramIndexMap[rt];
            blanking = 0;
            break;
        }
        int color = this.colorMapper.getColor(Util.readBufferWord(this.cram, cramIndex), shadowHighlight) & 0xFFFFFFFE;
        return color | blanking;
    }

    private int getPixelFromLayer(RenderPriority rp, int col) {
        switch (rp.getRenderType()) {
            case PLANE_A: 
            case WINDOW_PLANE: {
                return this.javaPalette[this.planeA[col] >> 1] & 0xFFFFFFFE;
            }
            case PLANE_B: {
                return this.javaPalette[this.planeB[col] >> 1] & 0xFFFFFFFE;
            }
            case SPRITE: {
                return this.javaPalette[this.sprites[col] >> 1] & 0xFFFFFFFE;
            }
            case BACK_PLANE: {
                return this.javaPalette[this.planeBack[col] >> 1] | 1;
            }
        }
        return -1;
    }

    private VdpMisc.ShadowHighlightType processShadowHighlight(int col) {
        boolean anyLayerHighPrio;
        int spriteRt = VdpMisc.RenderType.SPRITE.ordinal();
        VdpRenderHandler.PixelData pxData = this.linePixelData[col];
        int spriteCramIndex = pxData.cramIndexMap[spriteRt];
        boolean spriteTransparent = (spriteCramIndex & 0x1F) == 0;
        VdpMisc.ShadowHighlightType shadowHighlight = VdpMisc.ShadowHighlightType.NORMAL;
        if (!spriteTransparent) {
            switch (spriteCramIndex) {
                case 124: {
                    shadowHighlight = shadowHighlight.brighter();
                    pxData.cramIndexMap[spriteRt] = 0;
                    break;
                }
                case 126: {
                    shadowHighlight = shadowHighlight.darker();
                    pxData.cramIndexMap[spriteRt] = 0;
                }
            }
        }
        boolean spritePalette14 = !spriteTransparent && spriteCramIndex % 28 == 0;
        FastBitSet pmap = pxData.priorityMap;
        boolean bl = anyLayerHighPrio = !pmap.isEmpty() && (pmap.get(VdpMisc.RenderType.PLANE_A.ordinal()) || pmap.get(VdpMisc.RenderType.PLANE_B.ordinal()) || !spriteTransparent && pmap.get(spriteRt));
        if (!anyLayerHighPrio && !spritePalette14) {
            shadowHighlight = shadowHighlight.darker();
        }
        return shadowHighlight;
    }

    private void renderBack() {
        int backEntry;
        int reg7 = this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.BACKGROUND_COLOR);
        int backLine = reg7 >> 4 & 3;
        int cramColorIndex = (backLine << 5) + ((backEntry = reg7 & 0xF) << 1);
        if (this.planeBack[0] != cramColorIndex) {
            Arrays.fill(this.planeBack, cramColorIndex);
        }
    }

    private void renderSprites(int line) {
        boolean stop;
        int spritePixelLineLimit = VdpRenderHandler.maxSpritesPixelPerLine(this.videoMode.isH40());
        int maxSpritesPerLine = VdpRenderHandler.maxSpritesPerLine(this.videoMode.isH40());
        this.spritePixelLineCount = 0;
        boolean nonZeroSpriteOnLine = false;
        int ind = 0;
        VdpRenderHandler.SpriteDataHolder holder = this.spriteDataHoldersCurrent[0];
        boolean bl = stop = holder.spriteNumber < 0;
        while (!stop) {
            holder = this.spriteDataHoldersCurrent[ind];
            holder = this.getSpriteData(holder);
            int verSizePixels = holder.verticalCellSize + 1 << 3;
            int realY = holder.verticalPos - 128;
            int realX = holder.horizontalPos - 128;
            int spriteLine = (line - realY) % verSizePixels;
            int pointVert = holder.vertFlip ? verSizePixels - 1 - spriteLine : spriteLine;
            boolean bl2 = stop = nonZeroSpriteOnLine && holder.horizontalPos == 0 || this.spritePixelLineCount >= spritePixelLineLimit;
            if (stop) {
                return;
            }
            int horOffset = realX;
            int spriteVerticalCell = pointVert >> 3;
            int vertLining = (spriteVerticalCell << this.interlaceMode.tileShift()) + ((pointVert & 7) << 2 + this.interlaceMode.interlaceAdjust());
            vertLining += this.odd << 2;
            for (int cellX = 0; cellX <= holder.horizontalCellSize && this.spritePixelLineCount < spritePixelLineLimit; ++cellX) {
                int spriteCellX = holder.horFlip ? holder.horizontalCellSize - cellX : cellX;
                int horLining = vertLining + spriteCellX * (holder.verticalCellSize + 1 << this.interlaceMode.tileShift());
                this.renderSprite(holder, holder.tileIndex + horLining, horOffset, spritePixelLineLimit);
                horOffset += 8;
            }
            stop = ++ind >= maxSpritesPerLine || this.spriteDataHoldersCurrent[ind].spriteNumber < 0;
            nonZeroSpriteOnLine |= holder.horizontalPos != 0;
        }
    }

    private void renderPlaneA(int line) {
        this.renderScrollPlane(line, VdpRenderHandler.getPlaneANameTableLocation(this.vdpProvider), this.scrollContextA, this.windowPlaneContext);
    }

    protected void composeImageLinearLine(int line) {
        int col;
        int width = this.videoMode.getDimension().width;
        int k = width * line;
        if (!this.shadowHighlightMode) {
            for (col = 0; col < width; ++col) {
                this.linearScreen[k++] = this.getPixelFromLayer(this.linePixelData[col].pixelPriority, col);
            }
        } else {
            for (col = 0; col < width; ++col) {
                this.linearScreen[k++] = this.getPixelFromLayerSh(col);
            }
        }
        if (this.lcb) {
            k = width * line;
            for (col = 0; col < 8; ++col) {
                this.linearScreen[k++] = this.getPixelFromLayer(RenderPriority.BACK_PLANE, col);
            }
        }
    }

    protected void renderScrollPlane(int line, int nameTableLocation, VdpScrollHandler.ScrollContext sc, VdpRenderHandler.WindowPlaneContext wpc) {
        int limitHorTiles = VdpRenderHandler.getHorizontalTiles(this.videoMode.isH40());
        int regB = this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.MODE_3);
        int reg10 = this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.PLANE_SIZE);
        sc.hScrollType = VdpScrollHandler.HSCROLL.getHScrollType(regB & 3);
        sc.vScrollType = VdpScrollHandler.VSCROLL.getVScrollType(regB >> 2 & 1);
        sc.interlaceMode = this.interlaceMode;
        sc.planeWidth = VdpRenderHandler.getHorizontalPlaneSize(reg10);
        sc.planeHeight = VdpRenderHandler.getVerticalPlaneSize(reg10);
        VdpRenderHandlerImpl.getPlaneCells(wpc, limitHorTiles);
        int startTwoCells = wpc.startHCellPlane >> 1;
        int endTwoCells = wpc.endHCellPlane >> 1;
        this.renderPlaneInternal(line, nameTableLocation, startTwoCells, endTwoCells, sc);
    }

    private void renderPlaneInternal(int line, int nameTableLocation, int startTwoCells, int endTwoCells, VdpScrollHandler.ScrollContext sc) {
        int vScrollSizeMask = (sc.planeHeight << 3) - 1;
        int hScrollPixelOffset = this.scrollHandler.getHorizontalScroll(line, sc);
        int[] plane = sc.plane;
        VdpRenderHandler.TileDataHolder tileDataHolder = this.spriteDataHolder;
        RenderPriority rp = null;
        for (int twoCell = startTwoCells; twoCell < endTwoCells; ++twoCell) {
            int startPixel;
            int rowCellShift = 0;
            int latestTileLocatorVram = -1;
            int vScrollLineOffset = this.scrollHandler.getVerticalScroll(twoCell, sc);
            int planeLine = vScrollLineOffset + line & vScrollSizeMask;
            int planeCellVOffset = (planeLine >> 3) * sc.planeWidth;
            int rowCellBase = planeLine & 7;
            for (int pixel = startPixel = twoCell << 4; pixel < startPixel + 16; ++pixel) {
                int planeCellHOffset = (pixel + hScrollPixelOffset >> 3) % sc.planeWidth;
                int tileLocatorVram = nameTableLocation + (planeCellHOffset + planeCellVOffset << 1);
                int xPosCell = pixel + hScrollPixelOffset & 7;
                if (tileLocatorVram != latestTileLocatorVram) {
                    int tileNameTable = Util.readBufferWord(this.vram, tileLocatorVram);
                    tileDataHolder = this.getTileData(tileNameTable, tileDataHolder);
                    latestTileLocatorVram = tileLocatorVram;
                    rp = tileDataHolder.priority ? sc.highPrio : sc.lowPrio;
                    int rowCell = rowCellBase ^ tileDataHolder.vertFlipAmount & 7;
                    rowCellShift = rowCell << 2 + this.interlaceMode.interlaceAdjust();
                    rowCellShift += this.odd << 2;
                }
                int colCell = xPosCell ^ tileDataHolder.horFlipAmount & 7;
                int tileBytePointer = tileDataHolder.tileIndex + (colCell >> 1) + rowCellShift;
                int onePixelData = this.getPixelIndexColor(tileBytePointer, xPosCell, tileDataHolder.horFlipAmount);
                plane[pixel] = tileDataHolder.paletteLineIndex + (onePixelData << 1);
                this.updatePixelData(pixel, rp, plane[pixel]);
            }
        }
    }

    private void drawWindowPlane(int line, int hCellStart, int hCellEnd, boolean isH40) {
        int lineVCell = line >> 3;
        int nameTableLocation = VdpRenderHandler.getWindowPlaneNameTableLocation(this.vdpProvider, isH40);
        int planeTileShift = 32 << 2 - (isH40 ? 0 : 1);
        int tileLocatorVram = nameTableLocation + planeTileShift * lineVCell + (hCellStart << 1);
        int rowInTile = line & 7;
        VdpRenderHandler.TileDataHolder tileDataHolder = this.spriteDataHolder;
        int hCell = hCellStart;
        while (hCell < hCellEnd) {
            int tileNameTable = Util.readBufferWord(this.vram, tileLocatorVram);
            tileDataHolder = this.getTileData(tileNameTable, tileDataHolder);
            int pixelVPosTile = tileDataHolder.vertFlip ? 7 - rowInTile : rowInTile;
            RenderPriority rp = tileDataHolder.priority ? RenderPriority.PLANE_A_PRIO : RenderPriority.PLANE_A_NO_PRIO;
            for (int k = 0; k < 4; ++k) {
                int pixelHPosTile = k ^ tileDataHolder.horFlipAmount & 3;
                int pos = (hCell << 3) + (k << 1);
                int tileBytePointer = tileDataHolder.tileIndex + pixelHPosTile + (pixelVPosTile << 2);
                int pixelIndexColor1 = this.getPixelIndexColor(tileBytePointer, 0, tileDataHolder.horFlipAmount);
                int pixelIndexColor2 = this.getPixelIndexColor(tileBytePointer, 1, tileDataHolder.horFlipAmount);
                int val1 = tileDataHolder.paletteLineIndex + (pixelIndexColor1 << 1);
                int val2 = tileDataHolder.paletteLineIndex + (pixelIndexColor2 << 1);
                this.planeA[pos] = val1;
                this.planeA[pos + 1] = val2;
                this.updatePixelData(pos, rp, val1);
                this.updatePixelData(pos + 1, rp, val2);
            }
            ++hCell;
            tileLocatorVram += 2;
        }
    }

    private int getPixelIndexColor(int tileBytePointer, int pixelInTile, int horFlipAmount) {
        int twoPixelsData = this.vram.get(tileBytePointer & 0xFFFF) & 0xFF;
        boolean isFirstPixel = (pixelInTile & 1) == (~horFlipAmount & 1);
        return isFirstPixel ? twoPixelsData & 0xF : (twoPixelsData & 0xF0) >> 4;
    }

    private void updatePixelData(int pixel, RenderPriority rp, int cramIndex) {
        int rto = rp.getRenderType().ordinal();
        VdpRenderHandler.PixelData pixelData = this.linePixelData[pixel];
        pixelData.priorityMap.set(rto, rp.getPriorityType().ordinal() > 0);
        pixelData.cramIndexMap[rto] = cramIndex;
        if ((cramIndex & 0x1F) != 0 && rp.ordinal() > pixelData.pixelPriority.ordinal()) {
            pixelData.pixelPriority = rp;
        }
    }

    private void renderWindow(int line) {
        boolean drawWindow;
        this.windowPlaneContext.reset();
        int reg11 = this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.WINDOW_PLANE_HOR_POS);
        int reg12 = this.vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.WINDOW_PLANE_VERT_POS);
        boolean isH40 = this.videoMode.isH40();
        int hCellTotal = VdpRenderHandler.getHorizontalTiles(isH40);
        boolean down = (reg12 & 0x80) == 128;
        boolean right = (reg11 & 0x80) == 128;
        int hCell = (reg11 & 0x1F) << 1;
        int vCell = reg12 & 0x1F;
        int lineCell = line >> 3;
        boolean legalDown = down && lineCell >= vCell;
        boolean legalUp = !down && lineCell < vCell;
        boolean legalVertical = legalDown || legalUp;
        int hStartCell = right ? Math.min(hCell, hCellTotal) : 0;
        int hEndCell = right ? hCellTotal : Math.min(hCell, hCellTotal);
        hStartCell = legalVertical ? 0 : hStartCell;
        hEndCell = legalVertical ? hCellTotal : hEndCell;
        boolean legalHorizontal = hStartCell < hEndCell;
        boolean bl = drawWindow = legalVertical || legalHorizontal;
        if (drawWindow) {
            this.drawWindowPlane(line, hStartCell, hEndCell, isH40);
            this.windowPlaneContext.startHCell = hStartCell;
            this.windowPlaneContext.endHCell = hEndCell;
        }
    }

    @Override
    public void onVdpEvent(BaseVdpAdapterEventSupport.VdpEvent event, Object value) {
        switch (event) {
            case VIDEO_MODE: {
                this.setVideoMode((VideoMode)((Object)value));
                break;
            }
            case LEFT_COL_BLANK: {
                this.lcb = (Boolean)value;
                break;
            }
            case INTERLACE_FIELD_CHANGE: {
                this.odd = INTERLACE_SHOW_ONE_FIELD ? this.odd : Integer.parseInt(value.toString());
                break;
            }
            case INTERLACE_MODE_CHANGE: {
                this.interlaceMode = (InterlaceMode)((Object)value);
                break;
            }
        }
    }

    private VdpRenderHandler.SpriteDataHolder getPhase1SpriteData(int spriteIdx, VdpRenderHandler.SpriteDataHolder holder) {
        if (spriteIdx + 3 >= 640) {
            LOG.error("Invalid sprite address: {}", (Object)spriteIdx);
            return holder;
        }
        int satAddress = spriteIdx << 3;
        int[] satCache = this.memoryInterface.getSatCache();
        int byte0 = satCache[satAddress];
        int byte1 = satCache[satAddress + 1];
        int byte2 = satCache[satAddress + 2];
        int byte3 = satCache[satAddress + 3];
        holder.linkData = byte3 & 0x7F;
        holder.verticalPos = (byte0 & 1) << 8 | byte1;
        if (this.interlaceMode == InterlaceMode.MODE_2) {
            holder.verticalPos = (byte0 & 3) << 7 | byte1 >> 1;
        }
        holder.verticalCellSize = byte2 & 3;
        holder.horizontalCellSize = byte2 >> 2 & 3;
        holder.spriteNumber = spriteIdx;
        return holder;
    }

    private void renderPlaneB(int line) {
        this.renderScrollPlane(line, VdpRenderHandler.getPlaneBNameTableLocation(this.vdpProvider), this.scrollContextB, NO_CONTEXT);
    }

    private VdpRenderHandler.SpriteDataHolder getSpriteData(VdpRenderHandler.SpriteDataHolder holder) {
        int vramOffset = this.spriteTableLocation + (holder.spriteNumber << 3);
        return VdpRenderHandlerImpl.getSpriteData(this.vram, vramOffset, this.interlaceMode, holder);
    }

    private void setVideoMode(VideoMode videoMode) {
        this.newVideoMode = videoMode;
        if (this.videoMode == null) {
            this.initVideoMode();
        }
    }

    @Override
    public int[] getPlaneData(VdpMisc.RenderType type) {
        int[] res = null;
        switch (type) {
            case BACK_PLANE: {
                res = this.planeBack;
                break;
            }
            case PLANE_A: 
            case WINDOW_PLANE: {
                res = this.planeA;
                break;
            }
            case PLANE_B: {
                res = this.planeB;
                break;
            }
            case SPRITE: {
                res = this.sprites;
                break;
            }
            case FULL: {
                res = this.linearScreen;
            }
        }
        return res;
    }

    @Override
    public int[] getScreenDataLinear() {
        return this.linearScreen;
    }

    @Override
    public void dumpScreenData() {
        Arrays.stream(VdpMisc.RenderType.values()).forEach(r -> this.renderDump.saveRenderToFile(this.getPlaneData((VdpMisc.RenderType)((Object)r)), this.videoMode, (VdpMisc.RenderType)((Object)r)));
    }
}

