/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.model;

import omegadrive.Device;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.VideoMode;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.VdpMemoryInterface;
import org.slf4j.Logger;

public interface BaseVdpProvider
extends Device,
BaseVdpAdapterEventSupport {
    public static final Logger LOG = LogHelper.getLogger(BaseVdpProvider.class.getSimpleName());
    public static final int MCLK_DIVIDER_FAST_VDP = 4;
    public static final int MCLK_DIVIDER_SLOW_VDP = 5;
    public static final int V18_CELL = 144;
    public static final int V24_CELL = 192;
    public static final int V28_CELL = 224;
    public static final int V30_CELL = 240;
    public static final int V32_CELL = 256;
    public static final int H40 = 320;
    public static final int H32 = 256;
    public static final int H20 = 160;
    public static final int H32_TILES = 32;
    public static final int H40_TILES = 40;
    public static final int PAL_SCANLINES = 313;
    public static final int NTSC_SCANLINES = 262;
    public static final int H32_PIXELS = 342;
    public static final int H40_PIXELS = 420;
    public static final int H32_JUMP = 295;
    public static final int H40_JUMP = 364;
    public static final int H32_HBLANK_SET = 294;
    public static final int H40_HBLANK_SET = 358;
    public static final int H32_HBLANK_CLEAR = 10;
    public static final int H40_HBLANK_CLEAR = 11;
    public static final int H32_ACTIVE_DISPLAY_START = 24;
    public static final int H40_ACTIVE_DISPLAY_START = 26;
    public static final int H32_ACTIVE_DISPLAY_END = 280;
    public static final int H40_ACTIVE_DISPLAY_END = 345;
    public static final int V24_VBLANK_SET = 192;
    public static final int V28_VBLANK_SET = 224;
    public static final int V30_VBLANK_SET = 240;
    public static final int H32_VCOUNTER_INC_ON = 266;
    public static final int H40_VCOUNTER_INC_ON = 330;
    public static final int V24_PAL_JUMP = 242;
    public static final int V24_NTSC_JUMP = 218;
    public static final int V28_PAL_JUMP = 258;
    public static final int V28_NTSC_JUMP = 234;
    public static final int V30_PAL_JUMP = 266;
    public static final int V30_NTSC_JUMP = 242;
    public static final int H32_SLOTS = 171;
    public static final int H40_SLOTS = 210;
    public static final int H40_SLOW_CLOCK = 482;

    @Override
    public void init();

    public int runSlot();

    public int getRegisterData(int var1);

    public void updateRegisterData(int var1, int var2);

    public VideoMode getVideoMode();

    public int[] getScreenDataLinear();

    public void setRegion(RegionDetector.Region var1);

    default public VdpMemoryInterface getVdpMemory() {
        throw new RuntimeException("VdpMemory not available!");
    }

    default public void reload() {
    }

    default public void dumpScreenData() {
        throw new UnsupportedOperationException("Not supported");
    }

    default public String getVdpStateString() {
        return "vdpState: unsupported";
    }

    default public void resetVideoMode(boolean force) {
        throw new UnsupportedOperationException("Not supported");
    }
}

