/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.model;

import omegadrive.vdp.model.VdpMisc;

public enum RenderPriority {
    BACK_PLANE(VdpMisc.RenderType.BACK_PLANE, VdpMisc.PriorityType.NO, 0),
    PLANE_B_NO_PRIO(VdpMisc.RenderType.PLANE_B, VdpMisc.PriorityType.NO, 1),
    PLANE_A_NO_PRIO(VdpMisc.RenderType.PLANE_A, VdpMisc.PriorityType.NO, 2),
    WINDOW_PLANE_NO_PRIO(VdpMisc.RenderType.WINDOW_PLANE, VdpMisc.PriorityType.NO, 3),
    SPRITE_NO_PRIO(VdpMisc.RenderType.SPRITE, VdpMisc.PriorityType.NO, 4),
    PLANE_B_PRIO(VdpMisc.RenderType.PLANE_B, VdpMisc.PriorityType.YES, 5),
    PLANE_A_PRIO(VdpMisc.RenderType.PLANE_A, VdpMisc.PriorityType.YES, 6),
    WINDOW_PLANE_PRIO(VdpMisc.RenderType.WINDOW_PLANE, VdpMisc.PriorityType.YES, 7),
    SPRITE_PRIO(VdpMisc.RenderType.SPRITE, VdpMisc.PriorityType.YES, 8);

    final VdpMisc.RenderType renderType;
    final VdpMisc.PriorityType priorityType;
    final int priorityOrder;
    public static final RenderPriority[] enums;

    private RenderPriority(VdpMisc.RenderType renderType, VdpMisc.PriorityType priorityType, int priorityOrder) {
        this.renderType = renderType;
        this.priorityType = priorityType;
        this.priorityOrder = priorityOrder;
    }

    public VdpMisc.RenderType getRenderType() {
        return this.renderType;
    }

    public VdpMisc.PriorityType getPriorityType() {
        return this.priorityType;
    }

    public int getPriorityOrder() {
        return this.priorityOrder;
    }

    public static RenderPriority getRenderPriority(VdpMisc.RenderType renderType, boolean isPriority) {
        VdpMisc.PriorityType pt = isPriority ? VdpMisc.PriorityType.YES : VdpMisc.PriorityType.NO;
        for (RenderPriority r : enums) {
            if (r.priorityType != pt || r.renderType != renderType) continue;
            return r;
        }
        return null;
    }

    static {
        enums = (RenderPriority[])RenderPriority.class.getEnumConstants();
    }
}

