/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.model;

import java.nio.ByteBuffer;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.vdp.model.MdVdpProvider;
import org.slf4j.Logger;

public interface VdpMemoryInterface {
    public static final Logger LOG = LogHelper.getLogger(VdpMemoryInterface.class.getSimpleName());

    public void writeVideoRamWord(MdVdpProvider.VdpRamType var1, int var2, int var3);

    public void writeVideoRamByte(MdVdpProvider.VdpRamType var1, int var2, byte var3);

    public byte readVideoRamByte(MdVdpProvider.VdpRamType var1, int var2);

    public int readVideoRamWord(MdVdpProvider.VdpRamType var1, int var2);

    public int[] getJavaColorPalette();

    public ByteBuffer getVram();

    default public ByteBuffer getCram() {
        throw new RuntimeException("Cram not available");
    }

    default public ByteBuffer getVsram() {
        throw new RuntimeException("Vsram not available");
    }

    default public int[] getSatCache() {
        return new int[0];
    }

    default public void setSatBaseAddress(int address) {
    }

    default public void writeVideoRamWord(MdVdpProvider.VramMode mode, int data, int address) {
        if (mode == null) {
            LOG.warn("writeDataPort when vramMode is not set, address {} , size {}", (Object)address, (Object)Size.WORD);
            return;
        }
        this.writeVideoRamWord(mode.getRamType(), data, address);
    }

    default public int readVideoRamWord(MdVdpProvider.VramMode mode, int address) {
        if (mode == null) {
            LOG.warn("readDataPort when vramMode is not set, address {} , size {}", (Object)address, (Object)Size.WORD);
            return 0;
        }
        return this.readVideoRamWord(mode.getRamType(), address);
    }
}

