/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.model;

import java.util.Arrays;
import java.util.Objects;
import omegadrive.util.FastBitSet;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.RenderPriority;
import omegadrive.vdp.model.VdpMisc;

public interface VdpRenderHandler {
    public static final boolean INTERLACE_SHOW_ONE_FIELD = Boolean.parseBoolean(System.getProperty("helios.interlace.one.field", "true"));
    public static final int COLS = 320;
    public static final int HOR_SCROLL_SHIFT = 10;
    public static final int WINDOW_TABLE_SHIFT = 10;
    public static final int SPRITE_TABLE_SHIFT = 9;
    public static final int PLANE_A_SHIFT = 10;
    public static final int PLANE_B_SHIFT = 13;
    public static final int PALETTE_INDEX_SHIFT = 5;
    public static final int TILE_HOR_FLIP_MASK = 2048;
    public static final int TILE_VERT_FLIP_MASK = 4096;
    public static final int TILE_PRIORITY_MASK = 32768;
    public static final int TILE_INDEX_MASK = 2047;
    public static final int CELL_WIDTH = 8;
    public static final int CELL_WIDTH_MASK = 7;
    public static final int BYTES_PER_TILE = 4;
    public static final int CRAM_TRANSP_PIXEL_MASK = 31;
    public static final WindowPlaneContext NO_CONTEXT = new WindowPlaneContext();

    public void dumpScreenData();

    public void renderLine(int var1);

    public void initLineData(int var1);

    public int[] getScreenDataLinear();

    default public int[] getPlaneData(VdpMisc.RenderType type) {
        throw new RuntimeException("not implemented");
    }

    public static int getHorizontalTiles(boolean isH40) {
        return isH40 ? 40 : 32;
    }

    public static int getVerticalPlaneSize(int reg10) {
        int horScrollSize = reg10 & 3;
        int vertScrollSize = reg10 >> 4 & 3;
        switch (vertScrollSize) {
            case 0: {
                return horScrollSize == 2 ? 1 : 32;
            }
            case 1: 
            case 2: {
                return horScrollSize == 2 ? 1 : (horScrollSize == 3 ? 32 : 64);
            }
            case 3: {
                return horScrollSize == 2 ? 1 : (horScrollSize == 3 ? 32 : (horScrollSize == 1 ? 64 : 128));
            }
        }
        return 0;
    }

    public static int maxSpritesPerFrame(boolean isH40) {
        return isH40 ? 80 : 64;
    }

    public static int maxSpritesPerLine(boolean isH40) {
        return isH40 ? 20 : 16;
    }

    public static int maxSpritesPixelPerLine(boolean isH40) {
        return isH40 ? 320 : 256;
    }

    public static int getHScrollDataLocation(MdVdpProvider vdp) {
        return (vdp.getRegisterData(MdVdpProvider.VdpRegisterName.HORIZONTAL_SCROLL_DATA_LOC) & 0x3F) << 10;
    }

    public static int getWindowPlaneNameTableLocation(MdVdpProvider vdp, boolean isH40) {
        int reg3 = vdp.getRegisterData(MdVdpProvider.VdpRegisterName.WINDOW_NAMETABLE);
        int nameTableLocation = isH40 ? reg3 & 0x3C : reg3 & 0x3E;
        return nameTableLocation << 10;
    }

    public static int getPlaneBNameTableLocation(MdVdpProvider vdpProvider) {
        return (vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.PLANE_B_NAMETABLE) & 7) << 13;
    }

    public static int getPlaneANameTableLocation(MdVdpProvider vdpProvider) {
        return (vdpProvider.getRegisterData(MdVdpProvider.VdpRegisterName.PLANE_A_NAMETABLE) & 0x38) << 10;
    }

    public static int getSpriteTableLocation(MdVdpProvider vdp, boolean isH40) {
        return (vdp.getRegisterData(MdVdpProvider.VdpRegisterName.SPRITE_TABLE_LOC) & (isH40 ? 126 : 127)) << 9;
    }

    public static int getHorizontalPlaneSize(int reg10) {
        switch (reg10 & 3) {
            case 0: 
            case 2: {
                return 32;
            }
            case 1: {
                return 64;
            }
            case 3: {
                return 128;
            }
        }
        return 0;
    }

    public static class WindowPlaneContext {
        public int startHCell;
        public int endHCell;
        public int startHCellPlane;
        public int endHCellPlane;

        public void reset() {
            this.endHCellPlane = 0;
            this.startHCellPlane = 0;
            this.startHCell = 0;
            this.endHCell = 0;
        }
    }

    public static class PixelData {
        public final FastBitSet priorityMap = new FastBitSet(8);
        public final int[] cramIndexMap = new int[VdpMisc.RenderType.values().length];
        public RenderPriority pixelPriority = RenderPriority.BACK_PLANE;

        public void reset(boolean sh) {
            if (sh) {
                this.priorityMap.empty();
                Arrays.fill(this.cramIndexMap, 0);
            }
            this.pixelPriority = RenderPriority.BACK_PLANE;
        }
    }

    public static class SpriteDataHolder
    extends TileDataHolder {
        public int verticalPos;
        public int horizontalPos;
        public int horizontalCellSize;
        public int verticalCellSize;
        public int linkData;
        public int spriteNumber;

        @Override
        public String toString() {
            return "SpriteDataHolder{verticalPos=" + this.verticalPos + ", horizontalPos=" + this.horizontalPos + ", horizontalCellSize=" + this.horizontalCellSize + ", verticalCellSize=" + this.verticalCellSize + ", linkData=" + this.linkData + ", " + super.toString() + "}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SpriteDataHolder that = (SpriteDataHolder)o;
            return this.verticalPos == that.verticalPos && this.horizontalPos == that.horizontalPos && this.horizontalCellSize == that.horizontalCellSize && this.verticalCellSize == that.verticalCellSize && this.linkData == that.linkData;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.verticalPos, this.horizontalPos, this.horizontalCellSize, this.verticalCellSize, this.linkData);
        }
    }

    public static class TileDataHolder {
        public int tileIndex;
        public boolean horFlip;
        public boolean vertFlip;
        public int paletteLineIndex;
        public boolean priority;
        public int horFlipAmount;
        public int vertFlipAmount;

        public String toString() {
            return "TileDataHolder{tileIndex=" + this.tileIndex + ", horFlip=" + this.horFlip + ", vertFlip=" + this.vertFlip + ", paletteLineIndex=" + this.paletteLineIndex + ", priority=" + this.priority + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TileDataHolder that = (TileDataHolder)o;
            return this.tileIndex == that.tileIndex && this.horFlip == that.horFlip && this.vertFlip == that.vertFlip && this.paletteLineIndex == that.paletteLineIndex && this.priority == that.priority;
        }

        public int hashCode() {
            return Objects.hash(this.tileIndex, this.horFlip, this.vertFlip, this.paletteLineIndex, this.priority);
        }
    }
}

