/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.vdp.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.swing.JPanel;
import omegadrive.util.ImageUtil;
import omegadrive.vdp.md.VdpRenderHandlerImpl;
import omegadrive.vdp.model.InterlaceMode;
import omegadrive.vdp.model.MdVdpProvider;
import omegadrive.vdp.model.VdpMemoryInterface;
import omegadrive.vdp.model.VdpRenderHandler;
import omegadrive.vdp.util.UpdatableViewer;

public class TileViewer
implements UpdatableViewer {
    private static final int MAX_TILES_PER_LINE = 64;
    private static final int PANEL_TEXT_HEIGHT = 20;
    private static final int PANEL_HEIGHT = 220;
    private static final int PLANE_IMG_HEIGHT = 128;
    private static final int PLANE_IMG_WIDTH = 512;
    private static final int PANEL_WIDTH = 512;
    private final VdpMemoryInterface memoryInterface;
    private final MdVdpProvider vdp;
    private int[] javaPalette;
    private JPanel panel;
    private BufferedImage imageA;
    private BufferedImage imageB;
    private BufferedImage imageS;
    private BufferedImage imageW;
    private int[] pixelsA;
    private int[] pixelsB;
    private int[] pixelsS;
    private int[] pixelsW;

    private TileViewer(MdVdpProvider vdp, VdpMemoryInterface memoryInterface, VdpRenderHandler renderHandler) {
        this.vdp = vdp;
        VdpRenderHandlerImpl renderHandler1 = (VdpRenderHandlerImpl)renderHandler;
        this.memoryInterface = memoryInterface;
        this.javaPalette = memoryInterface.getJavaColorPalette();
        this.panel = new JPanel();
        this.initPanel();
    }

    public static TileViewer createInstance(MdVdpProvider vdp, VdpMemoryInterface memoryInterface, VdpRenderHandler renderHandler) {
        return new TileViewer(vdp, memoryInterface, renderHandler);
    }

    private static int[] getPixels(BufferedImage img) {
        return ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
    }

    private void initPanel() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.imageA = ImageUtil.createImage(gd, new Dimension(512, 128));
        this.imageB = ImageUtil.createImage(gd, new Dimension(512, 128));
        this.imageW = ImageUtil.createImage(gd, new Dimension(512, 128));
        this.imageS = ImageUtil.createImage(gd, new Dimension(512, 128));
        this.pixelsA = TileViewer.getPixels(this.imageA);
        this.pixelsB = TileViewer.getPixels(this.imageB);
        this.pixelsS = TileViewer.getPixels(this.imageS);
        this.pixelsW = TileViewer.getPixels(this.imageW);
        final int planeATextVPos = 10;
        final int planeATilesVPos = planeATextVPos + 10;
        final int planeBTextVPos = planeATextVPos;
        final int planeBTilesVPos = planeATilesVPos;
        final int spriteTextVPos = planeBTilesVPos + this.imageB.getHeight() + 13;
        final int spriteTilesVPos = spriteTextVPos + 10;
        final int planeWTextVPos = spriteTextVPos;
        final int planeWTilesVPos = spriteTilesVPos;
        final int rightHalfPos = 522;
        this.panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setColor(Color.white);
                    g2.drawString("MD Plane A Tiles", 70, planeATextVPos);
                    g2.drawRect(0, planeATilesVPos, TileViewer.this.imageA.getWidth() + 1, TileViewer.this.imageA.getHeight() + 1);
                    g2.drawImage((Image)TileViewer.this.imageA, 1, planeATilesVPos + 1, this);
                    g2.drawString("MD Plane B Tiles", rightHalfPos + 70, planeBTextVPos);
                    g2.drawRect(rightHalfPos, planeBTilesVPos, TileViewer.this.imageB.getWidth() + 1, TileViewer.this.imageB.getHeight() + 1);
                    g2.drawImage((Image)TileViewer.this.imageB, rightHalfPos + 1, planeBTilesVPos + 1, this);
                    g2.drawString("MD Sprite Tiles", 70, spriteTextVPos);
                    g2.drawImage((Image)TileViewer.this.imageS, 1, spriteTilesVPos + 1, this);
                    g2.drawRect(0, spriteTilesVPos, TileViewer.this.imageS.getWidth() + 1, TileViewer.this.imageS.getHeight() + 1);
                    g2.drawString("MD Window Tiles", rightHalfPos + 70, planeWTextVPos);
                    g2.drawImage((Image)TileViewer.this.imageW, rightHalfPos + 1, planeWTilesVPos + 1, this);
                    g2.drawRect(rightHalfPos, planeWTilesVPos, TileViewer.this.imageW.getWidth() + 1, TileViewer.this.imageW.getHeight() + 1);
                }
            }
        };
        this.panel.setBackground(Color.BLACK);
        this.panel.setForeground(Color.WHITE);
        this.panel.setSize(new Dimension(512, 220));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void update() {
        int hCellSize = VdpRenderHandler.getHorizontalPlaneSize(this.vdp.getRegisterData(MdVdpProvider.VdpRegisterName.PLANE_SIZE));
        int vCellSize = VdpRenderHandler.getVerticalPlaneSize(this.vdp.getRegisterData(MdVdpProvider.VdpRegisterName.PLANE_SIZE));
        int planeSize = hCellSize * vCellSize;
        boolean isH40 = this.vdp.getVideoMode().isH40();
        int wPlaneSize = (isH40 ? 40 : 32) * 32;
        int planeALoc = VdpRenderHandler.getPlaneANameTableLocation(this.vdp);
        int planeBLoc = VdpRenderHandler.getPlaneBNameTableLocation(this.vdp);
        int planeWLoc = VdpRenderHandler.getWindowPlaneNameTableLocation(this.vdp, isH40);
        int satLoc = VdpRenderHandler.getSpriteTableLocation(this.vdp, isH40);
        this.javaPalette = this.memoryInterface.getJavaColorPalette();
        int planeADataEnd = this.getClosestUpperLimit(planeALoc, planeALoc + (planeSize << 1), new int[]{planeALoc + (planeSize << 1), planeBLoc, satLoc, planeWLoc, 65535});
        int planeBDataEnd = this.getClosestUpperLimit(planeBLoc, planeBLoc + (planeSize << 1), new int[]{planeBLoc + (planeSize << 1), planeALoc, satLoc, planeWLoc, 65535});
        int planeWDataEnd = this.getClosestUpperLimit(planeBLoc, planeWLoc + (wPlaneSize << 1), new int[]{planeWLoc + (wPlaneSize << 1), planeALoc, satLoc, planeBLoc, 65535});
        this.showPlaneTiles(this.pixelsA, planeALoc, planeADataEnd);
        this.showPlaneTiles(this.pixelsB, planeBLoc, planeBDataEnd);
        this.showPlaneTiles(this.pixelsW, planeWLoc, planeWDataEnd);
        this.showSpriteTiles(this.pixelsS, satLoc);
        this.panel.repaint();
    }

    private int getClosestUpperLimit(int value, int defaultVal, int[] values) {
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= value) continue;
            return values[i];
        }
        return defaultVal;
    }

    private void showPlaneTiles(int[] pixels, int nameTableLocation, int nameTableEnd) {
        byte[] vram = this.vdp.getVdpMemory().getVram().array();
        int tileLinearShift = 0;
        int shownTiles = 0;
        Arrays.fill(pixels, 0);
        VdpRenderHandler.TileDataHolder tileDataHolder = new VdpRenderHandler.TileDataHolder();
        try {
            for (int i = nameTableLocation; i < nameTableEnd && i < vram.length; i += 2) {
                int vramPointer = vram[i] << 8 | vram[i + 1];
                boolean nonBlank = this.renderInternal(tileDataHolder = VdpRenderHandlerImpl.getTileData(vramPointer, InterlaceMode.NONE, tileDataHolder), pixels, vram, tileLinearShift);
                if (!nonBlank) continue;
                tileLinearShift += 8;
                if (++shownTiles % 64 != 0) continue;
                tileLinearShift = shownTiles / 8 * 512;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showSpriteTiles(int[] pixels, int satLoc) {
        ByteBuffer vram = this.vdp.getVdpMemory().getVram();
        int tileLinearShift = 0;
        int shownTiles = 0;
        int satEnd = Math.min(satLoc + 640, vram.capacity() - 8);
        Arrays.fill(pixels, 0);
        VdpRenderHandler.SpriteDataHolder spriteDataHolder = new VdpRenderHandler.SpriteDataHolder();
        try {
            for (int vramOffset = satLoc; vramOffset < satEnd; vramOffset += 8) {
                boolean nonBlank = this.renderInternal(spriteDataHolder = VdpRenderHandlerImpl.getSpriteData(vram, vramOffset, InterlaceMode.NONE, spriteDataHolder), pixels, vram.array(), tileLinearShift);
                if (!nonBlank) continue;
                tileLinearShift += 8;
                if (++shownTiles % 64 != 0) continue;
                tileLinearShift = shownTiles / 8 * 512;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean renderInternal(VdpRenderHandler.TileDataHolder tileDataHolder, int[] pixels, byte[] vram, int tileLinearShift) {
        int tileRowShift = 0;
        boolean nonBlank = false;
        for (int j = 0; j < 8; ++j) {
            for (int k = 0; k < 4; ++k) {
                byte rowData = vram[tileDataHolder.tileIndex + (j << 2) + k];
                int px1 = rowData & 0xF;
                int px2 = (rowData & 0xF0) >> 4;
                int javaColorIndex1 = tileDataHolder.paletteLineIndex + (px1 << 1) >> 1;
                int javaColorIndex2 = tileDataHolder.paletteLineIndex + (px2 << 1) >> 1;
                int px = tileLinearShift + tileRowShift + (k << 1);
                if (px > 65535) continue;
                pixels[px] = this.javaPalette[javaColorIndex1];
                pixels[px + 1] = this.javaPalette[javaColorIndex1];
                nonBlank |= javaColorIndex1 > 0 || javaColorIndex2 > 0;
            }
            tileRowShift += 512;
        }
        return nonBlank;
    }
}

