/*
 * Decompiled with CFR 0.152.
 */
package s32x.bus;

import java.nio.ByteBuffer;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.DmaFifo68k;
import s32x.S32XMMREG;
import s32x.Sh2MMREG;
import s32x.bus.Sh2Bus;
import s32x.dict.S32xMemAccessDelay;
import s32x.event.PollSysEventManager;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.Sh2Helper;
import s32x.sh2.cache.Sh2Cache;
import s32x.sh2.prefetch.Sh2Prefetch;
import s32x.sh2.prefetch.Sh2PrefetchSimple;
import s32x.sh2.prefetch.Sh2Prefetcher;
import s32x.util.BiosHolder;
import s32x.util.debug.MemAccessStats;
import s32x.util.debug.SdramSyncTester;

public final class Sh2BusImpl
implements Sh2Bus {
    private static final Logger LOG = LogHelper.getLogger(Sh2BusImpl.class.getSimpleName());
    private static final String ILLEGAL_ACCESS_STR = "{} sh2 {} access to {} when {}={}, addr: {} {}";
    private static final boolean SDRAM_SYNC_TESTER = false;
    public BiosHolder.BiosData[] bios = new BiosHolder.BiosData[2];
    public ByteBuffer sdram;
    public ByteBuffer rom;
    public final Sh2Cache[] cache = new Sh2Cache[2];
    private final Sh2Prefetcher prefetch;
    private final MemAccessStats memAccessStats = MemAccessStats.NO_STATS;
    public int romSize;
    public int romMask;
    private final Sh2MMREG[] sh2MMREGS = new Sh2MMREG[2];
    private final S32XMMREG s32XMMREG;
    private final Sh2Bus.MdRomAccess mdBus;
    private final Sh2Bus.MemoryDataCtx memoryDataCtx = new Sh2Bus.MemoryDataCtx();
    private final Sh2Helper.Sh2Config config;
    private final SdramSyncTester sdramSyncTester;

    public Sh2BusImpl(S32XMMREG s32XMMREG, ByteBuffer rom, BiosHolder biosHolder, Sh2Bus.MdRomAccess mdBus, Sh2Prefetch.Sh2DrcContext ... drcCtx) {
        this.s32XMMREG = s32XMMREG;
        this.mdBus = mdBus;
        this.memoryDataCtx.rom = this.rom = rom;
        this.bios[BufferUtil.CpuDeviceAccess.MASTER.ordinal()] = biosHolder.getBiosData(BufferUtil.CpuDeviceAccess.MASTER);
        this.bios[BufferUtil.CpuDeviceAccess.SLAVE.ordinal()] = biosHolder.getBiosData(BufferUtil.CpuDeviceAccess.SLAVE);
        this.memoryDataCtx.bios = this.bios;
        this.memoryDataCtx.sdram = this.sdram = ByteBuffer.allocate(262144);
        Sh2Helper.Sh2Config sh2Config = Sh2Helper.Sh2Config.get();
        this.cache[BufferUtil.CpuDeviceAccess.MASTER.ordinal()] = Sh2Cache.createCacheInstance(BufferUtil.CpuDeviceAccess.MASTER, this);
        this.cache[BufferUtil.CpuDeviceAccess.SLAVE.ordinal()] = Sh2Cache.createCacheInstance(BufferUtil.CpuDeviceAccess.SLAVE, this);
        this.sh2MMREGS[BufferUtil.CpuDeviceAccess.MASTER.ordinal()] = new Sh2MMREG(BufferUtil.CpuDeviceAccess.MASTER, this.cache[BufferUtil.CpuDeviceAccess.MASTER.ordinal()]);
        this.sh2MMREGS[BufferUtil.CpuDeviceAccess.SLAVE.ordinal()] = new Sh2MMREG(BufferUtil.CpuDeviceAccess.SLAVE, this.cache[BufferUtil.CpuDeviceAccess.SLAVE.ordinal()]);
        this.memoryDataCtx.romSize = this.romSize = rom.capacity();
        this.memoryDataCtx.romMask = this.romMask = Util.getRomMask(this.romSize);
        this.prefetch = sh2Config.drcEn ? new Sh2Prefetch(this, this.cache, drcCtx) : new Sh2PrefetchSimple(this, this.cache);
        this.config = Sh2Helper.Sh2Config.get();
        this.sdramSyncTester = SdramSyncTester.NO_OP;
        Gs32xStateHandler.addDevice(this);
        LOG.info("Rom size: {}, mask: {}", (Object)Util.th(this.romSize), (Object)Util.th(this.romMask));
    }

    @Override
    public int read(int address, Size size) {
        BufferUtil.CpuDeviceAccess cpuAccess = MdRuntimeData.getAccessTypeExt();
        assert (Util.assertCheckBusOp(address, size));
        int res = 0;
        if (SH2_MEM_ACCESS_STATS) {
            this.memAccessStats.addMemHit(true, address, size);
        }
        switch (address >>> 29 & 0xFF) {
            case 0: 
            case 2: 
            case 3: 
            case 6: {
                return this.cache[cpuAccess.ordinal()].cacheMemoryRead(address, size);
            }
            case 1: {
                if (address >= 0x22000000 && address < 0x22400000) {
                    assert (!DmaFifo68k.rv || Sh2BusImpl.logWarnIllegalAccess(cpuAccess, "read", "ROM", "rv", DmaFifo68k.rv, address, size));
                    res = this.mdBus.readRom(address & 0xFFFFFF, size);
                    S32xMemAccessDelay.addReadCpuDelay(0);
                    break;
                }
                if (address >= 0x20004000 && address < 0x20004400) {
                    if (BufferUtil.ENFORCE_FM_BIT_ON_READS && this.s32XMMREG.fm == 0 && address >= 536887552) {
                        Sh2BusImpl.logWarnIllegalAccess(cpuAccess, "read", "VDP regs", "FM", this.s32XMMREG.fm, address, size);
                        return size.getMask();
                    }
                    res = this.s32XMMREG.read(address, size);
                    break;
                }
                if (address >= 0x26000000 && address < 637796352) {
                    res = BufferUtil.readBuffer(this.sdram, address & 0x3FFFF, size);
                    S32xMemAccessDelay.addReadCpuDelay(6);
                    break;
                }
                if (address >= 0x24000000 && address < 604372992) {
                    if (BufferUtil.ENFORCE_FM_BIT_ON_READS && this.s32XMMREG.fm == 0) {
                        Sh2BusImpl.logWarnIllegalAccess(cpuAccess, "read", "FB/OVER", "FM", this.s32XMMREG.fm, address, size);
                        return size.getMask();
                    }
                    res = this.s32XMMREG.read(address & 0xFFF3FFFF, size);
                    S32xMemAccessDelay.addReadCpuDelay(1);
                    break;
                }
                if (address >= 0x20000000 && address < 0x20004000) {
                    res = this.bios[cpuAccess.ordinal()].readBuffer(address, size);
                    S32xMemAccessDelay.addReadCpuDelay(5);
                    break;
                }
                LogHelper.logWarnOnce(LOG, "{} invalid read from addr: {}, {}", new Object[]{cpuAccess, Util.th(address), size});
                break;
            }
            case 7: {
                if ((address & 0xE0004000) == -536854528) {
                    res = this.sh2MMREGS[cpuAccess.ordinal()].read(address & 0xFFFF, size);
                    break;
                }
                if (address >= Short.MIN_VALUE && address < -16384) {
                    res = this.sh2MMREGS[cpuAccess.ordinal()].readDramMode(address & 0xFFFF, size);
                    break;
                }
                LogHelper.logWarnOnce(LOG, "{} invalid read from addr: {}, {}", new Object[]{cpuAccess, Util.th(address), size});
                break;
            }
            default: {
                res = size.getMask();
                LogHelper.logWarnOnce(LOG, "{} invalid read from addr: {}, {}", new Object[]{cpuAccess, Util.th(address), size});
                throw new RuntimeException();
            }
        }
        return res & size.getMask();
    }

    @Override
    public void write(int address, int val, Size size) {
        BufferUtil.CpuDeviceAccess cpuAccess = MdRuntimeData.getAccessTypeExt();
        assert (Util.assertCheckBusOp(address, size));
        val &= size.getMask();
        if (SH2_MEM_ACCESS_STATS) {
            this.memAccessStats.addMemHit(false, address, size);
        }
        boolean hasMemoryChanged = false;
        switch (address >>> 29 & 0xFF) {
            case 0: 
            case 2: 
            case 3: 
            case 6: {
                hasMemoryChanged = this.cache[cpuAccess.ordinal()].cacheMemoryWrite(address, val, size);
                break;
            }
            case 1: {
                if (address >= 0x24000000 && address < 604372992) {
                    if (this.s32XMMREG.fm == 0) {
                        Sh2BusImpl.logWarnIllegalAccess(cpuAccess, "write", "FB/OVER", "FM", this.s32XMMREG.fm, address, size);
                        return;
                    }
                    this.s32XMMREG.write(address & 0xFFF3FFFF, val, size);
                    break;
                }
                if (address >= 0x26000000 && address < 637796352) {
                    hasMemoryChanged = BufferUtil.writeBufferRaw(this.sdram, address & 0x3FFFF, val, size);
                    S32xMemAccessDelay.addWriteCpuDelay(6);
                    break;
                }
                if (address >= 0x20004000 && address < 536887552) {
                    this.s32XMMREG.write(address, val, size);
                    break;
                }
                if (address >= 536887552 && address < 0x20004400) {
                    if (this.s32XMMREG.fm == 0) {
                        Sh2BusImpl.logWarnIllegalAccess(cpuAccess, "write", " VDP regs", "FM", this.s32XMMREG.fm, address, size);
                        return;
                    }
                    this.s32XMMREG.write(address, val, size);
                    break;
                }
                LogHelper.logWarnOnce(LOG, "{} invalid write to addr: {}, {} {}", new Object[]{cpuAccess, Util.th(address), Util.th(val), size});
                break;
            }
            case 7: {
                if ((address & 0xE0004000) == -536854528) {
                    this.sh2MMREGS[cpuAccess.ordinal()].write(address & 0xFFFF, val, size);
                    break;
                }
                if (address >= Short.MIN_VALUE && address < -16384) {
                    this.sh2MMREGS[cpuAccess.ordinal()].writeDramMode(address & 0xFFFF, val, size);
                    break;
                }
                LogHelper.logWarnOnce(LOG, "{} invalid write to addr: {}, {} {}", new Object[]{cpuAccess, Util.th(address), Util.th(val), size});
                break;
            }
            default: {
                LogHelper.logWarnOnce(LOG, "{} invalid write to addr: {}, {} {}", new Object[]{cpuAccess, Util.th(address), Util.th(val), size});
            }
        }
        if (hasMemoryChanged) {
            this.prefetch.dataWrite(cpuAccess, address, val, size);
        }
        if (this.config.pollDetectEn) {
            Sh2Prefetch.checkPoller(cpuAccess, PollSysEventManager.SysEvent.SDRAM, address, val, size);
        }
    }

    @Override
    public void invalidateCachePrefetch(Sh2Cache.CacheInvalidateContext ctx) {
        this.prefetch.invalidateCachePrefetch(ctx);
    }

    @Override
    public void fetch(Sh2Helper.FetchResult fetchResult, BufferUtil.CpuDeviceAccess cpu) {
        this.prefetch.fetch(fetchResult, cpu);
    }

    @Override
    public int fetchDelaySlot(int pc, Sh2Helper.FetchResult ft, BufferUtil.CpuDeviceAccess cpu) {
        return this.prefetch.fetchDelaySlot(pc, ft, cpu);
    }

    @Override
    public Sh2MMREG getSh2MMREGS(BufferUtil.CpuDeviceAccess cpu) {
        return this.sh2MMREGS[cpu.ordinal()];
    }

    @Override
    public Sh2Bus.MemoryDataCtx getMemoryDataCtx() {
        return this.memoryDataCtx;
    }

    @Override
    public void newFrame() {
        this.prefetch.newFrame();
    }

    @Override
    public void resetSh2() {
        this.sh2MMREGS[BufferUtil.CpuDeviceAccess.MASTER.ordinal()].reset();
        this.sh2MMREGS[BufferUtil.CpuDeviceAccess.SLAVE.ordinal()].reset();
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        Sh2Bus.super.saveContext(buffer);
        buffer.put(this.sdram.rewind());
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        Sh2Bus.super.loadContext(buffer);
        this.sdram.rewind().put(buffer);
    }

    private static boolean logWarnIllegalAccess(BufferUtil.CpuDeviceAccess cpu, String rw, String memType, String accessType, Object val, int address, Size size) {
        LogHelper.logWarnOnceWhenEn(LOG, ILLEGAL_ACCESS_STR, new Object[]{cpu, rw, memType, accessType, val, Util.th(address), size});
        return true;
    }
}

