/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.StringJoiner;
import omegadrive.Device;
import omegadrive.util.BufferUtil;
import omegadrive.util.Util;
import s32x.savestate.Gs32xStateHandler;
import s32x.sh2.Sh2Helper;
import s32x.sh2.device.Sh2DeviceHelper;
import s32x.sh2.drc.Sh2Block;

public class Sh2Context
implements Device,
Serializable {
    private static final long serialVersionUID = -5401399583243385001L;
    static final int NUM_REG = 16;
    public static int burstCycles = 1;
    public final int[] registers = new int[16];
    public int GBR;
    public int VBR;
    public int SR;
    public int MACH;
    public int MACL;
    public int PR;
    public int PC;
    public int opcode;
    public int delayPC;
    public int cycles;
    public int cycles_ran;
    public transient BufferUtil.CpuDeviceAccess cpuAccess;
    public boolean delaySlot;
    public final boolean debug;
    public transient Sh2Helper.FetchResult fetchResult;
    public transient Sh2DeviceHelper.Sh2DeviceContext devices;
    public final String sh2ShortCode;

    public Sh2Context(BufferUtil.CpuDeviceAccess cpuAccess) {
        this(cpuAccess, false);
    }

    public Sh2Context(BufferUtil.CpuDeviceAccess cpuAccess, boolean debug) {
        this.cpuAccess = cpuAccess;
        this.sh2ShortCode = cpuAccess.cpuShortCode;
        this.fetchResult = new Sh2Helper.FetchResult();
        this.fetchResult.block = Sh2Block.INVALID_BLOCK;
        this.debug = debug;
        Gs32xStateHandler.addDevice(this);
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        Device.super.saveContext(buffer);
        buffer.put(Util.serializeObject(this));
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        Device.super.loadContext(buffer);
        Serializable s = Util.deserializeObject(buffer);
        assert (s instanceof Sh2Context);
        this.loadContext((Sh2Context)s);
    }

    public void loadContext(Sh2Context ctx) {
        assert (ctx.sh2ShortCode.equals(this.sh2ShortCode));
        this.cpuAccess = BufferUtil.CpuDeviceAccess.fromCpuCode(ctx.sh2ShortCode);
        System.arraycopy(ctx.registers, 0, this.registers, 0, this.registers.length);
        this.PC = ctx.PC;
        this.opcode = ctx.opcode;
        this.delaySlot = ctx.delaySlot;
        this.delayPC = ctx.delayPC;
        this.GBR = ctx.GBR;
        this.VBR = ctx.VBR;
        this.SR = ctx.SR;
        this.MACH = ctx.MACH;
        this.MACL = ctx.MACL;
        this.PR = ctx.PR;
        this.cycles = ctx.cycles;
        this.cycles_ran = ctx.cycles_ran;
        this.fetchResult.block = Sh2Block.INVALID_BLOCK;
        this.fetchResult.pc = 0;
        this.fetchResult.opcode = 0;
    }

    public String toString() {
        return new StringJoiner(", ", Sh2Context.class.getSimpleName() + "[", "]").add("registers=" + Arrays.toString(this.registers)).add("GBR=" + this.GBR).add("VBR=" + this.VBR).add("SR=" + this.SR).add("MACH=" + this.MACH).add("MACL=" + this.MACL).add("PR=" + this.PR).add("PC=" + this.PC).add("opcode=" + this.opcode).add("delayPC=" + this.delayPC).add("cycles=" + this.cycles).add("cycles_ran=" + this.cycles_ran).add("cpuAccess=" + String.valueOf((Object)this.cpuAccess)).add("sh2TypeCode='" + this.sh2ShortCode + "'").add("delaySlot=" + this.delaySlot).add("debug=" + this.debug).add("fetchResult=" + String.valueOf(this.fetchResult)).toString();
    }
}

