/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import omegadrive.util.Util;
import s32x.bus.Sh2Bus;
import s32x.sh2.Sh2Impl;
import s32x.sh2.prefetch.Sh2Prefetcher;

public class Sh2Instructions {
    public static final int NUM_OPCODES = 65536;
    public static Sh2InstructionWrapper[] instOpcodeMap;
    public static Sh2BaseInstruction[] sh2OpcodeMap;
    public static Sh2BaseInstruction[] intDisabledOpcodes;
    public static Sh2BaseInstruction[] illegalSlotOpcodes;

    public static Sh2InstructionWrapper[] createOpcodeMap(Sh2Impl sh2) {
        instOpcodeMap = new Sh2InstructionWrapper[65536];
        sh2OpcodeMap = new Sh2BaseInstruction[65536];
        for (int i = 0; i < instOpcodeMap.length; ++i) {
            Sh2Instructions.sh2OpcodeMap[i] = Sh2Instructions.getInstruction(i);
            Sh2Instructions.instOpcodeMap[i] = Sh2Instructions.getInstruction(sh2, i);
        }
        return instOpcodeMap;
    }

    private static String methodName() {
        StackWalker walker = StackWalker.getInstance();
        Optional methodName = walker.walk(frames -> frames.skip(2L).findFirst().map(StackWalker.StackFrame::getMethodName));
        return methodName.orElse("ERROR");
    }

    public static Sh2Prefetcher.Sh2BlockUnit[] generateInst(int[] opcodes) {
        return (Sh2Prefetcher.Sh2BlockUnit[])Arrays.stream(opcodes).mapToObj(op -> new Sh2Prefetcher.Sh2BlockUnit(instOpcodeMap[op])).toArray(Sh2Prefetcher.Sh2BlockUnit[]::new);
    }

    private static final Sh2BaseInstruction getInstruction(int opcode) {
        switch (opcode >>> 12 & 0xF) {
            case 0: {
                switch (opcode >>> 0 & 0xF) {
                    case 2: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.STCSR;
                            }
                            case 1: {
                                return Sh2BaseInstruction.STCGBR;
                            }
                            case 2: {
                                return Sh2BaseInstruction.STCVBR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 3: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.BSRF;
                            }
                            case 2: {
                                return Sh2BaseInstruction.BRAF;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 4: {
                        return Sh2BaseInstruction.MOVBS0;
                    }
                    case 5: {
                        return Sh2BaseInstruction.MOVWS0;
                    }
                    case 6: {
                        return Sh2BaseInstruction.MOVLS0;
                    }
                    case 7: {
                        return Sh2BaseInstruction.MULL;
                    }
                    case 8: {
                        switch (opcode >>> 4 & 0xFFF) {
                            case 0: {
                                return Sh2BaseInstruction.CLRT;
                            }
                            case 1: {
                                return Sh2BaseInstruction.SETT;
                            }
                            case 2: {
                                return Sh2BaseInstruction.CLRMAC;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 9: {
                        switch (opcode >>> 4 & 0xFFF) {
                            case 0: {
                                return Sh2BaseInstruction.NOP;
                            }
                            case 1: {
                                return Sh2BaseInstruction.DIV0U;
                            }
                            case 2: {
                                return Sh2BaseInstruction.MOVT;
                            }
                        }
                        switch (opcode >>> 4 & 0xF) {
                            case 2: {
                                return Sh2BaseInstruction.MOVT;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 10: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.STSMACH;
                            }
                            case 1: {
                                return Sh2BaseInstruction.STSMACL;
                            }
                            case 2: {
                                return Sh2BaseInstruction.STSPR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 11: {
                        switch (opcode >>> 4 & 0xFFF) {
                            case 0: {
                                return Sh2BaseInstruction.RTS;
                            }
                            case 1: {
                                return Sh2BaseInstruction.SLEEP;
                            }
                            case 2: {
                                return Sh2BaseInstruction.RTE;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 12: {
                        return Sh2BaseInstruction.MOVBL0;
                    }
                    case 13: {
                        return Sh2BaseInstruction.MOVWL0;
                    }
                    case 14: {
                        return Sh2BaseInstruction.MOVLL0;
                    }
                    case 15: {
                        return Sh2BaseInstruction.MACL;
                    }
                }
                return Sh2BaseInstruction.ILLEGAL;
            }
            case 1: {
                return Sh2BaseInstruction.MOVLS4;
            }
            case 2: {
                switch (opcode >>> 0 & 0xF) {
                    case 0: {
                        return Sh2BaseInstruction.MOVBS;
                    }
                    case 1: {
                        return Sh2BaseInstruction.MOVWS;
                    }
                    case 2: {
                        return Sh2BaseInstruction.MOVLS;
                    }
                    case 4: {
                        return Sh2BaseInstruction.MOVBM;
                    }
                    case 5: {
                        return Sh2BaseInstruction.MOVWM;
                    }
                    case 6: {
                        return Sh2BaseInstruction.MOVLM;
                    }
                    case 7: {
                        return Sh2BaseInstruction.DIV0S;
                    }
                    case 8: {
                        return Sh2BaseInstruction.TST;
                    }
                    case 9: {
                        return Sh2BaseInstruction.AND;
                    }
                    case 10: {
                        return Sh2BaseInstruction.XOR;
                    }
                    case 11: {
                        return Sh2BaseInstruction.OR;
                    }
                    case 12: {
                        return Sh2BaseInstruction.CMPSTR;
                    }
                    case 13: {
                        return Sh2BaseInstruction.XTRCT;
                    }
                    case 14: {
                        return Sh2BaseInstruction.MULSU;
                    }
                    case 15: {
                        return Sh2BaseInstruction.MULSW;
                    }
                }
                return Sh2BaseInstruction.ILLEGAL;
            }
            case 3: {
                switch (opcode >>> 0 & 0xF) {
                    case 0: {
                        return Sh2BaseInstruction.CMPEQ;
                    }
                    case 2: {
                        return Sh2BaseInstruction.CMPHS;
                    }
                    case 3: {
                        return Sh2BaseInstruction.CMPGE;
                    }
                    case 4: {
                        return Sh2BaseInstruction.DIV1;
                    }
                    case 5: {
                        return Sh2BaseInstruction.DMULU;
                    }
                    case 6: {
                        return Sh2BaseInstruction.CMPHI;
                    }
                    case 7: {
                        return Sh2BaseInstruction.CMPGT;
                    }
                    case 8: {
                        return Sh2BaseInstruction.SUB;
                    }
                    case 10: {
                        return Sh2BaseInstruction.SUBC;
                    }
                    case 11: {
                        return Sh2BaseInstruction.SUBV;
                    }
                    case 12: {
                        return Sh2BaseInstruction.ADD;
                    }
                    case 13: {
                        return Sh2BaseInstruction.DMULS;
                    }
                    case 14: {
                        return Sh2BaseInstruction.ADDC;
                    }
                    case 15: {
                        return Sh2BaseInstruction.ADDV;
                    }
                }
                return Sh2BaseInstruction.ILLEGAL;
            }
            case 4: {
                switch (opcode >>> 0 & 0xF) {
                    case 0: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.SHLL;
                            }
                            case 1: {
                                return Sh2BaseInstruction.DT;
                            }
                            case 2: {
                                return Sh2BaseInstruction.SHAL;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 1: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.SHLR;
                            }
                            case 1: {
                                return Sh2BaseInstruction.CMPPZ;
                            }
                            case 2: {
                                return Sh2BaseInstruction.SHAR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 2: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.STSMMACH;
                            }
                            case 1: {
                                return Sh2BaseInstruction.STSMMACL;
                            }
                            case 2: {
                                return Sh2BaseInstruction.STSMPR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 3: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.STCMSR;
                            }
                            case 1: {
                                return Sh2BaseInstruction.STCMGBR;
                            }
                            case 2: {
                                return Sh2BaseInstruction.STCMVBR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 4: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.ROTL;
                            }
                            case 2: {
                                return Sh2BaseInstruction.ROTCL;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 5: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.ROTR;
                            }
                            case 1: {
                                return Sh2BaseInstruction.CMPPL;
                            }
                            case 2: {
                                return Sh2BaseInstruction.ROTCR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 6: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.LDSMMACH;
                            }
                            case 1: {
                                return Sh2BaseInstruction.LDSMMACL;
                            }
                            case 2: {
                                return Sh2BaseInstruction.LDSMPR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 7: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.LDCMSR;
                            }
                            case 1: {
                                return Sh2BaseInstruction.LDCMGBR;
                            }
                            case 2: {
                                return Sh2BaseInstruction.LDCMVBR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 8: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.SHLL2;
                            }
                            case 1: {
                                return Sh2BaseInstruction.SHLL8;
                            }
                            case 2: {
                                return Sh2BaseInstruction.SHLL16;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 9: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.SHLR2;
                            }
                            case 1: {
                                return Sh2BaseInstruction.SHLR8;
                            }
                            case 2: {
                                return Sh2BaseInstruction.SHLR16;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 10: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.LDSMACH;
                            }
                            case 1: {
                                return Sh2BaseInstruction.LDSMACL;
                            }
                            case 2: {
                                return Sh2BaseInstruction.LDSPR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 11: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.JSR;
                            }
                            case 1: {
                                return Sh2BaseInstruction.TAS;
                            }
                            case 2: {
                                return Sh2BaseInstruction.JMP;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 14: {
                        switch (opcode >>> 4 & 0xF) {
                            case 0: {
                                return Sh2BaseInstruction.LDCSR;
                            }
                            case 1: {
                                return Sh2BaseInstruction.LDCGBR;
                            }
                            case 2: {
                                return Sh2BaseInstruction.LDCVBR;
                            }
                        }
                        return Sh2BaseInstruction.ILLEGAL;
                    }
                    case 15: {
                        return Sh2BaseInstruction.MACW;
                    }
                }
                return Sh2BaseInstruction.ILLEGAL;
            }
            case 5: {
                return Sh2BaseInstruction.MOVLL4;
            }
            case 6: {
                switch (opcode >>> 0 & 0xF) {
                    case 0: {
                        return Sh2BaseInstruction.MOVBL;
                    }
                    case 1: {
                        return Sh2BaseInstruction.MOVWL;
                    }
                    case 2: {
                        return Sh2BaseInstruction.MOVLL;
                    }
                    case 3: {
                        return Sh2BaseInstruction.MOV;
                    }
                    case 4: {
                        return Sh2BaseInstruction.MOVBP;
                    }
                    case 5: {
                        return Sh2BaseInstruction.MOVWP;
                    }
                    case 6: {
                        return Sh2BaseInstruction.MOVLP;
                    }
                    case 7: {
                        return Sh2BaseInstruction.NOT;
                    }
                    case 8: {
                        return Sh2BaseInstruction.SWAPB;
                    }
                    case 9: {
                        return Sh2BaseInstruction.SWAPW;
                    }
                    case 10: {
                        return Sh2BaseInstruction.NEGC;
                    }
                    case 11: {
                        return Sh2BaseInstruction.NEG;
                    }
                    case 12: {
                        return Sh2BaseInstruction.EXTUB;
                    }
                    case 13: {
                        return Sh2BaseInstruction.EXTUW;
                    }
                    case 14: {
                        return Sh2BaseInstruction.EXTSB;
                    }
                    case 15: {
                        return Sh2BaseInstruction.EXTSW;
                    }
                }
            }
            case 7: {
                return Sh2BaseInstruction.ADDI;
            }
            case 8: {
                switch (opcode >>> 8 & 0xF) {
                    case 0: {
                        return Sh2BaseInstruction.MOVBS4;
                    }
                    case 1: {
                        return Sh2BaseInstruction.MOVWS4;
                    }
                    case 4: {
                        return Sh2BaseInstruction.MOVBL4;
                    }
                    case 5: {
                        return Sh2BaseInstruction.MOVWL4;
                    }
                    case 8: {
                        return Sh2BaseInstruction.CMPIM;
                    }
                    case 9: {
                        return Sh2BaseInstruction.BT;
                    }
                    case 11: {
                        return Sh2BaseInstruction.BF;
                    }
                    case 13: {
                        return Sh2BaseInstruction.BTS;
                    }
                    case 15: {
                        return Sh2BaseInstruction.BFS;
                    }
                }
                return Sh2BaseInstruction.ILLEGAL;
            }
            case 9: {
                return Sh2BaseInstruction.MOVWI;
            }
            case 10: {
                return Sh2BaseInstruction.BRA;
            }
            case 11: {
                return Sh2BaseInstruction.BSR;
            }
            case 12: {
                switch (opcode >>> 8 & 0xF) {
                    case 0: {
                        return Sh2BaseInstruction.MOVBSG;
                    }
                    case 1: {
                        return Sh2BaseInstruction.MOVWSG;
                    }
                    case 2: {
                        return Sh2BaseInstruction.MOVLSG;
                    }
                    case 3: {
                        return Sh2BaseInstruction.TRAPA;
                    }
                    case 4: {
                        return Sh2BaseInstruction.MOVBLG;
                    }
                    case 5: {
                        return Sh2BaseInstruction.MOVWLG;
                    }
                    case 6: {
                        return Sh2BaseInstruction.MOVLLG;
                    }
                    case 7: {
                        return Sh2BaseInstruction.MOVA;
                    }
                    case 8: {
                        return Sh2BaseInstruction.TSTI;
                    }
                    case 9: {
                        return Sh2BaseInstruction.ANDI;
                    }
                    case 10: {
                        return Sh2BaseInstruction.XORI;
                    }
                    case 11: {
                        return Sh2BaseInstruction.ORI;
                    }
                    case 12: {
                        return Sh2BaseInstruction.TSTM;
                    }
                    case 13: {
                        return Sh2BaseInstruction.ANDM;
                    }
                    case 14: {
                        return Sh2BaseInstruction.XORM;
                    }
                    case 15: {
                        return Sh2BaseInstruction.ORM;
                    }
                }
            }
            case 13: {
                return Sh2BaseInstruction.MOVLI;
            }
            case 14: {
                return Sh2BaseInstruction.MOVI;
            }
        }
        return Sh2BaseInstruction.ILLEGAL;
    }

    public static final Sh2InstructionWrapper getInstruction(Sh2Impl sh2, int opcode) {
        Sh2BaseInstruction sh2Inst = Sh2Instructions.getInstruction(opcode);
        return new Sh2InstructionWrapper(opcode, sh2Inst, switch (sh2Inst) {
            case Sh2BaseInstruction.ADD -> () -> sh2.ADD(opcode);
            case Sh2BaseInstruction.ADDC -> () -> sh2.ADDC(opcode);
            case Sh2BaseInstruction.ADDI -> () -> sh2.ADDI(opcode);
            case Sh2BaseInstruction.ADDV -> () -> sh2.ADDV(opcode);
            case Sh2BaseInstruction.AND -> () -> sh2.AND(opcode);
            case Sh2BaseInstruction.ANDI -> () -> sh2.ANDI(opcode);
            case Sh2BaseInstruction.ANDM -> () -> sh2.ANDM(opcode);
            case Sh2BaseInstruction.BF -> () -> sh2.BF(opcode);
            case Sh2BaseInstruction.BFS -> () -> sh2.BFS(opcode);
            case Sh2BaseInstruction.BRA -> () -> sh2.BRA(opcode);
            case Sh2BaseInstruction.BRAF -> () -> sh2.BRAF(opcode);
            case Sh2BaseInstruction.BSR -> () -> sh2.BSR(opcode);
            case Sh2BaseInstruction.BSRF -> () -> sh2.BSRF(opcode);
            case Sh2BaseInstruction.BT -> () -> sh2.BT(opcode);
            case Sh2BaseInstruction.BTS -> () -> sh2.BTS(opcode);
            case Sh2BaseInstruction.CLRMAC -> () -> sh2.CLRMAC(opcode);
            case Sh2BaseInstruction.CLRT -> () -> sh2.CLRT(opcode);
            case Sh2BaseInstruction.CMPEQ -> () -> sh2.CMPEQ(opcode);
            case Sh2BaseInstruction.CMPGE -> () -> sh2.CMPGE(opcode);
            case Sh2BaseInstruction.CMPGT -> () -> sh2.CMPGT(opcode);
            case Sh2BaseInstruction.CMPHI -> () -> sh2.CMPHI(opcode);
            case Sh2BaseInstruction.CMPHS -> () -> sh2.CMPHS(opcode);
            case Sh2BaseInstruction.CMPIM -> () -> sh2.CMPIM(opcode);
            case Sh2BaseInstruction.CMPPL -> () -> sh2.CMPPL(opcode);
            case Sh2BaseInstruction.CMPPZ -> () -> sh2.CMPPZ(opcode);
            case Sh2BaseInstruction.CMPSTR -> () -> sh2.CMPSTR(opcode);
            case Sh2BaseInstruction.DIV0S -> () -> sh2.DIV0S(opcode);
            case Sh2BaseInstruction.DIV0U -> () -> sh2.DIV0U(opcode);
            case Sh2BaseInstruction.DIV1 -> () -> sh2.DIV1(opcode);
            case Sh2BaseInstruction.DMULS -> () -> sh2.DMULS(opcode);
            case Sh2BaseInstruction.DMULU -> () -> sh2.DMULU(opcode);
            case Sh2BaseInstruction.DT -> () -> sh2.DT(opcode);
            case Sh2BaseInstruction.EXTSB -> () -> sh2.EXTSB(opcode);
            case Sh2BaseInstruction.EXTSW -> () -> sh2.EXTSW(opcode);
            case Sh2BaseInstruction.EXTUB -> () -> sh2.EXTUB(opcode);
            case Sh2BaseInstruction.EXTUW -> () -> sh2.EXTUW(opcode);
            case Sh2BaseInstruction.ILLEGAL -> () -> sh2.ILLEGAL(opcode);
            case Sh2BaseInstruction.JMP -> () -> sh2.JMP(opcode);
            case Sh2BaseInstruction.JSR -> () -> sh2.JSR(opcode);
            case Sh2BaseInstruction.LDCGBR -> () -> sh2.LDCGBR(opcode);
            case Sh2BaseInstruction.LDCMGBR -> () -> sh2.LDCMGBR(opcode);
            case Sh2BaseInstruction.LDCMSR -> () -> sh2.LDCMSR(opcode);
            case Sh2BaseInstruction.LDCMVBR -> () -> sh2.LDCMVBR(opcode);
            case Sh2BaseInstruction.LDCSR -> () -> sh2.LDCSR(opcode);
            case Sh2BaseInstruction.LDCVBR -> () -> sh2.LDCVBR(opcode);
            case Sh2BaseInstruction.LDSMACH -> () -> sh2.LDSMACH(opcode);
            case Sh2BaseInstruction.LDSMACL -> () -> sh2.LDSMACL(opcode);
            case Sh2BaseInstruction.LDSMMACH -> () -> sh2.LDSMMACH(opcode);
            case Sh2BaseInstruction.LDSMMACL -> () -> sh2.LDSMMACL(opcode);
            case Sh2BaseInstruction.LDSMPR -> () -> sh2.LDSMPR(opcode);
            case Sh2BaseInstruction.LDSPR -> () -> sh2.LDSPR(opcode);
            case Sh2BaseInstruction.MACL -> () -> sh2.MACL(opcode);
            case Sh2BaseInstruction.MACW -> () -> sh2.MACW(opcode);
            case Sh2BaseInstruction.MOV -> () -> sh2.MOV(opcode);
            case Sh2BaseInstruction.MOVA -> () -> sh2.MOVA(opcode);
            case Sh2BaseInstruction.MOVBL -> () -> sh2.MOVBL(opcode);
            case Sh2BaseInstruction.MOVBL0 -> () -> sh2.MOVBL0(opcode);
            case Sh2BaseInstruction.MOVBL4 -> () -> sh2.MOVBL4(opcode);
            case Sh2BaseInstruction.MOVBLG -> () -> sh2.MOVBLG(opcode);
            case Sh2BaseInstruction.MOVBM -> () -> sh2.MOVBM(opcode);
            case Sh2BaseInstruction.MOVBP -> () -> sh2.MOVBP(opcode);
            case Sh2BaseInstruction.MOVBS -> () -> sh2.MOVBS(opcode);
            case Sh2BaseInstruction.MOVBS0 -> () -> sh2.MOVBS0(opcode);
            case Sh2BaseInstruction.MOVBS4 -> () -> sh2.MOVBS4(opcode);
            case Sh2BaseInstruction.MOVBSG -> () -> sh2.MOVBSG(opcode);
            case Sh2BaseInstruction.MOVI -> () -> sh2.MOVI(opcode);
            case Sh2BaseInstruction.MOVLI -> () -> sh2.MOVLI(opcode);
            case Sh2BaseInstruction.MOVLL -> () -> sh2.MOVLL(opcode);
            case Sh2BaseInstruction.MOVLL0 -> () -> sh2.MOVLL0(opcode);
            case Sh2BaseInstruction.MOVLL4 -> () -> sh2.MOVLL4(opcode);
            case Sh2BaseInstruction.MOVLLG -> () -> sh2.MOVLLG(opcode);
            case Sh2BaseInstruction.MOVLM -> () -> sh2.MOVLM(opcode);
            case Sh2BaseInstruction.MOVLP -> () -> sh2.MOVLP(opcode);
            case Sh2BaseInstruction.MOVLS -> () -> sh2.MOVLS(opcode);
            case Sh2BaseInstruction.MOVLS0 -> () -> sh2.MOVLS0(opcode);
            case Sh2BaseInstruction.MOVLS4 -> () -> sh2.MOVLS4(opcode);
            case Sh2BaseInstruction.MOVLSG -> () -> sh2.MOVLSG(opcode);
            case Sh2BaseInstruction.MOVT -> () -> sh2.MOVT(opcode);
            case Sh2BaseInstruction.MOVWI -> () -> sh2.MOVWI(opcode);
            case Sh2BaseInstruction.MOVWL -> () -> sh2.MOVWL(opcode);
            case Sh2BaseInstruction.MOVWL0 -> () -> sh2.MOVWL0(opcode);
            case Sh2BaseInstruction.MOVWL4 -> () -> sh2.MOVWL4(opcode);
            case Sh2BaseInstruction.MOVWLG -> () -> sh2.MOVWLG(opcode);
            case Sh2BaseInstruction.MOVWM -> () -> sh2.MOVWM(opcode);
            case Sh2BaseInstruction.MOVWP -> () -> sh2.MOVWP(opcode);
            case Sh2BaseInstruction.MOVWS -> () -> sh2.MOVWS(opcode);
            case Sh2BaseInstruction.MOVWS0 -> () -> sh2.MOVWS0(opcode);
            case Sh2BaseInstruction.MOVWS4 -> () -> sh2.MOVWS4(opcode);
            case Sh2BaseInstruction.MOVWSG -> () -> sh2.MOVWSG(opcode);
            case Sh2BaseInstruction.MULL -> () -> sh2.MULL(opcode);
            case Sh2BaseInstruction.MULSU -> () -> sh2.MULSU(opcode);
            case Sh2BaseInstruction.MULSW -> () -> sh2.MULSW(opcode);
            case Sh2BaseInstruction.NEG -> () -> sh2.NEG(opcode);
            case Sh2BaseInstruction.NEGC -> () -> sh2.NEGC(opcode);
            case Sh2BaseInstruction.NOP -> () -> sh2.NOP(opcode);
            case Sh2BaseInstruction.NOT -> () -> sh2.NOT(opcode);
            case Sh2BaseInstruction.OR -> () -> sh2.OR(opcode);
            case Sh2BaseInstruction.ORI -> () -> sh2.ORI(opcode);
            case Sh2BaseInstruction.ORM -> () -> sh2.ORM(opcode);
            case Sh2BaseInstruction.ROTCL -> () -> sh2.ROTCL(opcode);
            case Sh2BaseInstruction.ROTCR -> () -> sh2.ROTCR(opcode);
            case Sh2BaseInstruction.ROTL -> () -> sh2.ROTL(opcode);
            case Sh2BaseInstruction.ROTR -> () -> sh2.ROTR(opcode);
            case Sh2BaseInstruction.RTE -> () -> sh2.RTE(opcode);
            case Sh2BaseInstruction.RTS -> () -> sh2.RTS(opcode);
            case Sh2BaseInstruction.SETT -> () -> sh2.SETT(opcode);
            case Sh2BaseInstruction.SHAL -> () -> sh2.SHAL(opcode);
            case Sh2BaseInstruction.SHAR -> () -> sh2.SHAR(opcode);
            case Sh2BaseInstruction.SHLL -> () -> sh2.SHLL(opcode);
            case Sh2BaseInstruction.SHLL16 -> () -> sh2.SHLL16(opcode);
            case Sh2BaseInstruction.SHLL2 -> () -> sh2.SHLL2(opcode);
            case Sh2BaseInstruction.SHLL8 -> () -> sh2.SHLL8(opcode);
            case Sh2BaseInstruction.SHLR -> () -> sh2.SHLR(opcode);
            case Sh2BaseInstruction.SHLR16 -> () -> sh2.SHLR16(opcode);
            case Sh2BaseInstruction.SHLR2 -> () -> sh2.SHLR2(opcode);
            case Sh2BaseInstruction.SHLR8 -> () -> sh2.SHLR8(opcode);
            case Sh2BaseInstruction.SLEEP -> () -> sh2.SLEEP(opcode);
            case Sh2BaseInstruction.STCGBR -> () -> sh2.STCGBR(opcode);
            case Sh2BaseInstruction.STCMGBR -> () -> sh2.STCMGBR(opcode);
            case Sh2BaseInstruction.STCMSR -> () -> sh2.STCMSR(opcode);
            case Sh2BaseInstruction.STCMVBR -> () -> sh2.STCMVBR(opcode);
            case Sh2BaseInstruction.STCSR -> () -> sh2.STCSR(opcode);
            case Sh2BaseInstruction.STCVBR -> () -> sh2.STCVBR(opcode);
            case Sh2BaseInstruction.STSMACH -> () -> sh2.STSMACH(opcode);
            case Sh2BaseInstruction.STSMACL -> () -> sh2.STSMACL(opcode);
            case Sh2BaseInstruction.STSMMACH -> () -> sh2.STSMMACH(opcode);
            case Sh2BaseInstruction.STSMMACL -> () -> sh2.STSMMACL(opcode);
            case Sh2BaseInstruction.STSMPR -> () -> sh2.STSMPR(opcode);
            case Sh2BaseInstruction.STSPR -> () -> sh2.STSPR(opcode);
            case Sh2BaseInstruction.SUB -> () -> sh2.SUB(opcode);
            case Sh2BaseInstruction.SUBC -> () -> sh2.SUBC(opcode);
            case Sh2BaseInstruction.SUBV -> () -> sh2.SUBV(opcode);
            case Sh2BaseInstruction.SWAPB -> () -> sh2.SWAPB(opcode);
            case Sh2BaseInstruction.SWAPW -> () -> sh2.SWAPW(opcode);
            case Sh2BaseInstruction.TAS -> () -> sh2.TAS(opcode);
            case Sh2BaseInstruction.TRAPA -> () -> sh2.TRAPA(opcode);
            case Sh2BaseInstruction.TST -> () -> sh2.TST(opcode);
            case Sh2BaseInstruction.TSTI -> () -> sh2.TSTI(opcode);
            case Sh2BaseInstruction.TSTM -> () -> sh2.TSTM(opcode);
            case Sh2BaseInstruction.XOR -> () -> sh2.XOR(opcode);
            case Sh2BaseInstruction.XORI -> () -> sh2.XORI(opcode);
            case Sh2BaseInstruction.XORM -> () -> sh2.XORM(opcode);
            case Sh2BaseInstruction.XTRCT -> () -> sh2.XTRCT(opcode);
            default -> () -> sh2.ILLEGAL(opcode);
        });
    }

    static {
        intDisabledOpcodes = new Sh2BaseInstruction[]{Sh2BaseInstruction.LDCGBR, Sh2BaseInstruction.LDSPR, Sh2BaseInstruction.LDCMGBR, Sh2BaseInstruction.LDCMSR, Sh2BaseInstruction.LDCMVBR, Sh2BaseInstruction.LDCSR, Sh2BaseInstruction.LDCVBR, Sh2BaseInstruction.LDSMACH, Sh2BaseInstruction.LDSMACL, Sh2BaseInstruction.LDSMMACH, Sh2BaseInstruction.LDSMMACH, Sh2BaseInstruction.LDSMPR, Sh2BaseInstruction.STCSR, Sh2BaseInstruction.STCGBR, Sh2BaseInstruction.STCVBR, Sh2BaseInstruction.STCMSR, Sh2BaseInstruction.STCMGBR, Sh2BaseInstruction.STCMVBR, Sh2BaseInstruction.STSMACH, Sh2BaseInstruction.STSMACL, Sh2BaseInstruction.STSPR, Sh2BaseInstruction.STSMMACH, Sh2BaseInstruction.STSMMACL, Sh2BaseInstruction.STSMPR};
        illegalSlotOpcodes = new Sh2BaseInstruction[]{Sh2BaseInstruction.JMP, Sh2BaseInstruction.JSR, Sh2BaseInstruction.BRA, Sh2BaseInstruction.BSR, Sh2BaseInstruction.RTS, Sh2BaseInstruction.RTE, Sh2BaseInstruction.BT, Sh2BaseInstruction.BF, Sh2BaseInstruction.TRAPA, Sh2BaseInstruction.BFS, Sh2BaseInstruction.BTS, Sh2BaseInstruction.BSRF, Sh2BaseInstruction.BRAF};
        Arrays.sort((Object[])intDisabledOpcodes);
        Arrays.sort((Object[])illegalSlotOpcodes);
    }

    public static class Sh2InstructionWrapper {
        public final Runnable runnable;
        public final Sh2BaseInstruction inst;
        public final int opcode;

        public Sh2InstructionWrapper(int opcode, Sh2BaseInstruction inst, Runnable r) {
            assert (inst == sh2OpcodeMap[opcode]) : Util.th(opcode) + "-" + String.valueOf((Object)inst) + "-" + String.valueOf((Object)sh2OpcodeMap[opcode]);
            this.opcode = opcode;
            this.inst = inst;
            this.runnable = r;
        }

        public String toString() {
            return new StringJoiner(", ", Sh2InstructionWrapper.class.getSimpleName() + "[", "]").add("inst=" + String.valueOf((Object)this.inst)).add("opcode=" + this.opcode).toString();
        }
    }

    public static enum Sh2BaseInstruction {
        ADD(0, 1),
        ADDC(0, 1),
        ADDI(0, 1),
        ADDV(0, 1),
        AND(0, 1),
        ANDI(0, 1),
        ANDM(0, 3),
        BF(9, 1, 3),
        BFS(11, 1, 2),
        BRA(11, 2, 2),
        BRAF(11, 2, 2),
        BSR(11, 2, 2),
        BSRF(11, 2, 2),
        BT(9, 1, 3),
        BTS(11, 1, 2),
        CLRMAC(0, 1),
        CLRT(0, 1),
        CMPEQ(0, 1),
        CMPGE(0, 1),
        CMPGT(0, 1),
        CMPHI(0, 1),
        CMPHS(0, 1),
        CMPIM(0, 1),
        CMPPL(0, 1),
        CMPPZ(0, 1),
        CMPSTR(0, 1),
        DIV0S(0, 1),
        DIV0U(0, 1),
        DIV1(0, 1),
        DMULS(0, 2),
        DMULU(0, 2),
        DT(0, 1),
        EXTSB(0, 1),
        EXTSW(0, 1),
        EXTUB(0, 1),
        EXTUW(0, 1),
        ILLEGAL(4, 5),
        JMP(11, 2, 2),
        JSR(11, 2, 2),
        LDCGBR(0, 1),
        LDCMGBR(0, 3),
        LDCMSR(0, 3),
        LDCMVBR(0, 3),
        LDCSR(0, 1),
        LDCVBR(0, 1),
        LDSMACH(0, 2),
        LDSMACL(0, 2),
        LDSMMACH(0, 1),
        LDSMMACL(0, 1),
        LDSMPR(0, 1),
        LDSPR(0, 1),
        MACL(0, 2),
        MACW(0, 2),
        MOV(0, 1),
        MOVA(0, 1),
        MOVBL(0, 1),
        MOVBL0(0, 1),
        MOVBL4(0, 1),
        MOVBLG(0, 1),
        MOVBM(0, 1),
        MOVBP(0, 1),
        MOVBS(0, 1),
        MOVBS0(0, 1),
        MOVBS4(0, 1),
        MOVBSG(0, 1),
        MOVI(0, 1),
        MOVLI(0, 1),
        MOVLL(0, 1),
        MOVLL0(0, 1),
        MOVLL4(0, 1),
        MOVLLG(0, 1),
        MOVLM(0, 1),
        MOVLP(0, 1),
        MOVLS(0, 1),
        MOVLS0(0, 1),
        MOVLS4(0, 1),
        MOVLSG(0, 1),
        MOVT(0, 1),
        MOVWI(0, 1),
        MOVWL(0, 1),
        MOVWL0(0, 1),
        MOVWL4(0, 1),
        MOVWLG(0, 1),
        MOVWM(0, 1),
        MOVWP(0, 1),
        MOVWS(0, 1),
        MOVWS0(0, 1),
        MOVWS4(0, 1),
        MOVWSG(0, 1),
        MULL(0, 2),
        MULSU(0, 2),
        MULSW(0, 2),
        NEG(0, 1),
        NEGC(0, 1),
        NOP(0, 1),
        NOT(0, 1),
        OR(0, 1),
        ORI(0, 1),
        ORM(0, 3),
        ROTCL(0, 1),
        ROTCR(0, 1),
        ROTL(0, 1),
        ROTR(0, 1),
        RTE(11, 4, 4),
        RTS(11, 2, 2),
        SETT(0, 1),
        SHAL(0, 1),
        SHAR(0, 1),
        SHLL(0, 1),
        SHLL16(0, 1),
        SHLL2(0, 1),
        SHLL8(0, 1),
        SHLR(0, 1),
        SHLR16(0, 1),
        SHLR2(0, 1),
        SHLR8(0, 1),
        SLEEP(0, 4),
        STCGBR(0, 2),
        STCMGBR(0, 2),
        STCMSR(0, 2),
        STCMVBR(0, 2),
        STCSR(0, 2),
        STCVBR(0, 2),
        STSMACH(0, 1),
        STSMACL(0, 1),
        STSMMACH(0, 1),
        STSMMACL(0, 1),
        STSMPR(0, 1),
        STSPR(0, 2),
        SUB(0, 1),
        SUBC(0, 1),
        SUBV(0, 1),
        SWAPB(0, 1),
        SWAPW(0, 1),
        TAS(0, 1),
        TRAPA(8, 8),
        TST(0, 1),
        TSTI(0, 1),
        TSTM(0, 3),
        XOR(0, 1),
        XORI(0, 1),
        XORM(0, 3),
        XTRCT(0, 1);

        public static final int FLAG_BRANCH = 0;
        public static final int FLAG_BRANCH_DELAY_SLOT = 1;
        public static final int FLAG_ILLEGAL = 2;
        public static final int FLAG_ILLEGAL_SLOT = 3;
        public static final int FLAG_BRANCH_MASK = 1;
        public static final int FLAG_BRANCH_DELAY_SLOT_MASK = 2;
        public static final int FLAG_ILLEGAL_MASK = 4;
        public static final int FLAG_ILLEGAL_SLOT_MASK = 8;
        public final int cycles;
        public final int cyclesBranch;
        public final int flags;

        private Sh2BaseInstruction(int flags, int cycles) {
            this(flags, cycles, 0);
        }

        private Sh2BaseInstruction(int flags, int cycles, int cyclesBranch) {
            this.flags = flags;
            this.cycles = cycles;
            this.cyclesBranch = cyclesBranch;
        }

        public boolean isBranch() {
            return (this.flags & 1) > 0;
        }

        public boolean isBranchDelaySlot() {
            return (this.flags & 2) > 0;
        }

        public boolean isIllegal() {
            return (this.flags & 4) > 0;
        }

        public boolean isIllegalSlot() {
            return (this.flags & 8) > 0;
        }

        public static void main(String[] args) {
            Predicate<String> isBranchPred = n -> n.startsWith("B") || n.startsWith("J") || n.startsWith("RT") || n.startsWith("BRA");
            Predicate<String> isBranchDelaySlotPred = n -> n.startsWith("J") || n.startsWith("BRA") || n.startsWith("BSR") || n.startsWith("RT") || n.startsWith("BTS") || n.startsWith("BFS");
            Predicate<String> illegalDelaySlotPred = n -> n.startsWith("J") || n.startsWith("BRA") || n.startsWith("BSR") || n.startsWith("RT") || n.startsWith("BT") || n.startsWith("BF") || n.startsWith("TRAPA");
            EnumMap<Sh2BaseInstruction, CallSite> instSet = new EnumMap<Sh2BaseInstruction, CallSite>(Sh2BaseInstruction.class);
            EnumMap<Sh2BaseInstruction, CallSite> explain = new EnumMap<Sh2BaseInstruction, CallSite>(Sh2BaseInstruction.class);
            for (Sh2BaseInstruction i : Sh2BaseInstruction.values()) {
                boolean isBranch = isBranchPred.test(i.name());
                int cycles = i.cycles;
                String s = (isBranch ? "isBranch," : "") + (isBranchDelaySlotPred.test(i.name()) ? "isBranchDelaySlot," : "") + (i == ILLEGAL ? "illegal," : "") + (illegalDelaySlotPred.test(i.name()) ? "illegalDelaySlot" : "");
                explain.put(i, (CallSite)((Object)s));
                int flags = (isBranch ? 1 : 0) << 0 | (isBranchDelaySlotPred.test(i.name()) ? 1 : 0) << 1 | (i == ILLEGAL ? 1 : 0) << 2 | (illegalDelaySlotPred.test(i.name()) ? 1 : 0) << 3;
                String val = String.valueOf((Object)i) + "(" + flags + "," + cycles + (String)(isBranch ? "," + i.cyclesBranch : "") + "), " + (String)(s.length() > 0 ? "//" + s : "");
                instSet.put(i, (CallSite)((Object)val));
            }
            String header = "inst,isBranch,isBranchDelaySlot,isIllegal,cycles,cyclesBranchTaken";
            String res = String.join((CharSequence)"\n", explain.values());
            System.out.println(header + "\n" + res);
            header = "inst,flags,cycles,cyclesBranchTaken, explain";
            res = String.join((CharSequence)"\n", instSet.values());
            System.out.println(header + "\n" + res);
        }
    }

    static class OpcodeCreateCtx {
        int opcode;
        Sh2Bus memory;

        OpcodeCreateCtx() {
        }
    }
}

