/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;
import s32x.dict.Sh2Dict;
import s32x.sh2.device.IntControl;

public class FreeRunningTimer
implements BufferUtil.Sh2Device {
    private static final Logger LOG = LogHelper.getLogger(FreeRunningTimer.class.getSimpleName());
    public static final boolean SH2_ENABLE_FRT = Boolean.parseBoolean(System.getProperty("helios.32x.sh2.frt", "false"));
    public static final boolean SH2_ENABLE_FRT_OCR = Boolean.parseBoolean(System.getProperty("helios.32x.sh2.frt.ocr", "false"));
    public static final int FTCSR_CCLRA_BIT = 0;
    public static final int FTCSR_OVF_BIT = 1;
    public static final int FTCSR_OCFB_BIT = 2;
    public static final int FTCSR_OCFA_BIT = 3;
    public static final int FTCSR_CCLRA_MASK = 1;
    public static final int FTCSR_OVF_MASK = 2;
    public static final int FTCSR_OCFB_MASK = 4;
    public static final int FTCSR_OCFA_MASK = 8;
    public static final int TOCR_OCRS_BIT = 4;
    public static final int TOCR_OCRS_MASK = 16;
    public static final int TIER_OVIE_BIT = 1;
    public static final int TIER_OCIBE_BIT = 2;
    public static final int TIER_OCIAE_BIT = 3;
    public static final int TIER_OVIE_MASK = 2;
    public static final int TIER_OCIAE_MASK = 8;
    public static final int TIER_OCIBE_MASK = 4;
    public static final int TOCR_DEFAULT = 224;
    public static final int OCRAB_DEFAULT = 65535;
    private static final int[] clockDivs = new int[]{8, 32, 128, 1};
    private static final boolean verbose = false;
    private final ByteBuffer regs;
    private final BufferUtil.CpuDeviceAccess cpu;
    private final IntControl intControl;
    private int ocra;
    private int ocrb;
    private boolean isOcra;
    private boolean ovfEnabled = false;
    private int count = 0;
    private int clockDivider = 0;
    private int sh2TicksToNextFrtClock;

    public FreeRunningTimer(BufferUtil.CpuDeviceAccess cpu, IntControl intC, ByteBuffer regs) {
        this.cpu = cpu;
        this.regs = regs;
        this.intControl = intC;
        this.reset();
        LOG.info("{} FRT enabled: {}", (Object)cpu, (Object)SH2_ENABLE_FRT);
    }

    @Override
    public int read(Sh2Dict.RegSpecSh2 regSpec, int address, Size size) {
        assert (address == regSpec.addr) : Util.th(address) + ", " + Util.th(regSpec.addr);
        switch (regSpec) {
            case FRT_OCRAB_H: {
                int ref = this.isOcra ? this.ocra : this.ocrb;
                return size == Size.WORD ? ref : ref >> 8;
            }
            case FRT_OCRAB_L: {
                assert (size == Size.BYTE);
                int refl = this.isOcra ? this.ocra : this.ocrb;
                return refl & 0xFF;
            }
        }
        return BufferUtil.readBuffer(this.regs, address, size);
    }

    @Override
    public void write(Sh2Dict.RegSpecSh2 regSpec, int pos, int value, Size size) {
        assert (pos == regSpec.addr) : Util.th(pos) + ", " + Util.th(regSpec.addr);
        BufferUtil.writeBufferRaw(this.regs, pos, value, size);
        switch (regSpec) {
            case FRT_TOCR: {
                assert (size == Size.BYTE);
                this.isOcra = (value & 0x10) == 0;
                BufferUtil.writeBufferRaw(this.regs, pos, value | 0xE0, size);
                break;
            }
            case FRT_OCRAB_H: 
            case FRT_OCRAB_L: {
                int val = BufferUtil.readBuffer(this.regs, Sh2Dict.RegSpecSh2.FRT_OCRAB_H.addr, Size.WORD);
                if (this.isOcra) {
                    this.ocra = val;
                    break;
                }
                this.ocrb = val;
                break;
            }
            case FRT_FRCH: 
            case FRT_FRCL: {
                this.count = BufferUtil.readBuffer(this.regs, Sh2Dict.RegSpecSh2.FRT_FRCH.addr, Size.WORD);
                break;
            }
            case FRT_TCR: {
                assert (size == Size.BYTE);
                this.sh2TicksToNextFrtClock = this.clockDivider = clockDivs[value & 3];
                break;
            }
            case FRT_TIER: {
                assert (size == Size.BYTE);
                this.ovfEnabled = (value & 2) > 0;
                BufferUtil.writeBufferRaw(this.regs, pos, value & 0x8E | 1, size);
            }
        }
    }

    @Override
    public void step(int cycles) {
        while (cycles-- > 0) {
            this.stepOne();
        }
    }

    private void stepOne() {
        if (--this.sh2TicksToNextFrtClock == 0) {
            this.sh2TicksToNextFrtClock = this.clockDivider;
            int cnt = this.increaseCount();
            if (cnt == 0) {
                BufferUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.FRT_FTCSR.addr, 1, 1, Size.BYTE);
                if (this.ovfEnabled) {
                    this.intControl.setOnChipDeviceIntPending(IntControl.Sh2Interrupt.FRTOV);
                }
            }
            if (SH2_ENABLE_FRT_OCR) {
                int ocrb;
                int ocra = this.read(Sh2Dict.RegSpecSh2.FRT_OCRAB_H, Size.WORD);
                if (cnt == ocra) {
                    boolean cclra;
                    boolean ociae;
                    BufferUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.FRT_FTCSR.addr, 3, 1, Size.BYTE);
                    boolean bl = ociae = (this.read(Sh2Dict.RegSpecSh2.FRT_TIER, Size.BYTE) & 8) > 0;
                    if (ociae) {
                        this.intControl.setOnChipDeviceIntPending(IntControl.Sh2Interrupt.FRTO);
                    }
                    boolean bl2 = cclra = (this.read(Sh2Dict.RegSpecSh2.FRT_FTCSR, Size.BYTE) & 1) > 0;
                    if (cclra) {
                        this.write(Sh2Dict.RegSpecSh2.FRT_FRCH, 0, Size.WORD);
                    }
                }
                if (cnt == (ocrb = this.read(Sh2Dict.RegSpecSh2.FRT_OCRAB_H, Size.WORD))) {
                    boolean ocibe;
                    BufferUtil.setBit(this.regs, Sh2Dict.RegSpecSh2.FRT_FTCSR.addr, 2, 1, Size.BYTE);
                    boolean bl = ocibe = (this.read(Sh2Dict.RegSpecSh2.FRT_TIER, Size.BYTE) & 4) > 0;
                    if (ocibe) {
                        this.intControl.setOnChipDeviceIntPending(IntControl.Sh2Interrupt.FRTO);
                    }
                }
            }
        }
    }

    private int increaseCount() {
        this.count = this.count + 1 & 0xFFFF;
        this.write(Sh2Dict.RegSpecSh2.FRT_FRCH, this.count, Size.WORD);
        return this.count;
    }

    @Override
    public void reset() {
        this.write(Sh2Dict.RegSpecSh2.FRT_TIER, 1, Size.BYTE);
        this.write(Sh2Dict.RegSpecSh2.FRT_FTCSR, 0, Size.BYTE);
        this.write(Sh2Dict.RegSpecSh2.FRT_FRCH, 0, Size.WORD);
        this.write(Sh2Dict.RegSpecSh2.FRT_OCRAB_H, 65535, Size.WORD);
        this.write(Sh2Dict.RegSpecSh2.FRT_TCR, 0, Size.BYTE);
        this.write(Sh2Dict.RegSpecSh2.FRT_TOCR, 224, Size.BYTE);
        this.write(Sh2Dict.RegSpecSh2.FRT_ICR_H, 0, Size.WORD);
        this.ocrb = 65535;
        this.ocra = 65535;
    }
}

