/*
 * Decompiled with CFR 0.152.
 */
package s32x.sh2.device;

import java.nio.ByteBuffer;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;
import s32x.sh2.device.Sh2DeviceHelper;

public interface IntControl
extends BufferUtil.Sh2Device {
    public static final Logger LOG = LogHelper.getLogger(IntControl.class.getSimpleName());
    public static final Sh2Interrupt[] intVals = new Sh2Interrupt[]{Sh2Interrupt.NONE_0, Sh2Interrupt.NONE_0, Sh2Interrupt.NONE_0, Sh2Interrupt.NONE_0, Sh2Interrupt.NONE_0, Sh2Interrupt.NONE_0, Sh2Interrupt.PWM_06, Sh2Interrupt.NONE_0, Sh2Interrupt.CMD_08, Sh2Interrupt.NONE_0, Sh2Interrupt.HINT_10, Sh2Interrupt.NONE_0, Sh2Interrupt.VINT_12, Sh2Interrupt.NONE_0, Sh2Interrupt.VRES_14, Sh2Interrupt.NONE_0, Sh2Interrupt.NONE_0};
    public static final InterruptContext LEV_0 = new InterruptContext();

    public void setOnChipDeviceIntPending(Sh2Interrupt var1);

    public void setIntPending(Sh2Interrupt var1, boolean var2);

    public int readSh2IntMaskReg(int var1, Size var2);

    public void reloadSh2IntMask();

    public ByteBuffer getSh2_int_mask_regs();

    public void setIntsMasked(int var1);

    public void clearExternalInterrupt(Sh2Interrupt var1);

    public void clearCurrentInterrupt();

    public int getVectorNumber();

    public InterruptContext getInterruptContext();

    default public int getInterruptLevel() {
        return this.getInterruptContext().level;
    }

    public static class InterruptContext {
        public Sh2Interrupt source;
        public int level = 0;
        public int intState = 0;

        public String toString() {
            return "IntCtx{source=" + String.valueOf((Object)this.source) + ", level=" + this.level + ", intState=" + this.intState + "}";
        }

        public void clearLevel() {
            if (this.source.external == 0) {
                this.level = 0;
            }
        }
    }

    public static enum Sh2Interrupt {
        NONE_0(0, 0),
        NMI_16(16, 0),
        NONE_15(15, 0),
        NONE_4(4, 0),
        VRES_14(14),
        VINT_12(12),
        HINT_10(10),
        CMD_08(8),
        PWM_06(6),
        DIVU(Sh2DeviceHelper.Sh2DeviceType.DIV),
        DMAC0(Sh2DeviceHelper.Sh2DeviceType.DMA, OnChipSubType.DMA_C0),
        DMAC1(Sh2DeviceHelper.Sh2DeviceType.DMA, OnChipSubType.DMA_C1),
        WDTS(Sh2DeviceHelper.Sh2DeviceType.WDT),
        REF(Sh2DeviceHelper.Sh2DeviceType.BSC),
        SCIE(Sh2DeviceHelper.Sh2DeviceType.SCI, OnChipSubType.ERI),
        SCIR(Sh2DeviceHelper.Sh2DeviceType.SCI, OnChipSubType.RXI),
        SCIT(Sh2DeviceHelper.Sh2DeviceType.SCI, OnChipSubType.TXI),
        SCITE(Sh2DeviceHelper.Sh2DeviceType.SCI, OnChipSubType.TEI),
        FRTI(Sh2DeviceHelper.Sh2DeviceType.FRT, OnChipSubType.ICI),
        FRTO(Sh2DeviceHelper.Sh2DeviceType.FRT, OnChipSubType.OCI),
        FRTOV(Sh2DeviceHelper.Sh2DeviceType.FRT, OnChipSubType.OVI);

        public final Sh2DeviceHelper.Sh2DeviceType deviceType;
        public final OnChipSubType subType;
        public final int external;
        public final int level;
        public final int supported;
        public static final Sh2Interrupt[] vals;

        private Sh2Interrupt(int level) {
            this(Sh2DeviceHelper.Sh2DeviceType.NONE, OnChipSubType.S_NONE, 1, level, 1);
        }

        private Sh2Interrupt(int level, int supported) {
            this(Sh2DeviceHelper.Sh2DeviceType.NONE, OnChipSubType.S_NONE, 1, level, supported);
        }

        private Sh2Interrupt(Sh2DeviceHelper.Sh2DeviceType deviceType) {
            this(deviceType, OnChipSubType.S_NONE, 0, 0, 1);
        }

        private Sh2Interrupt(Sh2DeviceHelper.Sh2DeviceType t, OnChipSubType s) {
            this(t, s, 0, 0, 1);
        }

        private Sh2Interrupt(Sh2DeviceHelper.Sh2DeviceType t, OnChipSubType s, int external, int level, int supported) {
            this.deviceType = t;
            this.subType = s;
            this.external = external;
            this.level = level;
            this.supported = supported;
        }

        static {
            vals = Sh2Interrupt.values();
        }
    }

    public static enum OnChipSubType {
        S_NONE,
        DMA_C0,
        DMA_C1,
        ERI,
        RXI,
        TXI,
        TEI,
        ICI,
        OCI,
        OVI;

    }
}

