/*
 * Decompiled with CFR 0.152.
 */
package s32x.util.blipbuffer;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import s32x.util.blipbuffer.BlipBufferHelper;
import s32x.util.blipbuffer.BlipBufferIntf;

public final class BlipBuffer
implements BlipBufferIntf {
    static final boolean muchFaster = true;
    static final int timeBits = 16;
    static final int phaseBits = 8;
    final int phaseCount = 256;
    static final int halfWidth = 8;
    final int stepWidth = 16;
    int factor;
    int offset;
    int[][] kernel;
    AtomicInteger accum;
    int[] buf;
    int sampleRate;
    int clockRate_;
    int volume;
    final int[] baseKernel = new int[]{10, -61, 284, -615, 1359, -1753, 5911, 22498, 14, -71, 295, -616, 1314, -1615, 5259, 22472, 17, -80, 304, -611, 1260, -1468, 4626, 22402, 21, -88, 309, -603, 1200, -1313, 4015, 22285, 23, -94, 313, -589, 1134, -1151, 3426, 22122, 26, -100, 313, -572, 1063, -986, 2861, 21915, 28, -104, 312, -550, 986, -818, 2322, 21663, 30, -108, 308, -525, 906, -648, 1810, 21369, 31, -110, 302, -497, 823, -478, 1326, 21034, 33, -112, 295, -466, 737, -309, 871, 20657, 34, -112, 285, -433, 649, -143, 446, 20242, 34, -111, 274, -397, 561, 19, 51, 19790, 34, -110, 261, -359, 472, 176, -313, 19302, 35, -108, 247, -320, 383, 327, -646, 18781, 34, -105, 232, -280, 296, 472, -948, 18230, 34, -101, 216, -240, 210, 608, -1219, 17651, 33, -97, 199, -199, 126, 736, -1459, 17045, 32, -92, 182, -158, 45, 855, -1668, 16413, 31, -86, 164, -117, -33, 964, -1847, 15761, 30, -80, 145, -77, -107, 1063, -1996, 15091, 28, -74, 127, -38, -177, 1151, -2117, 14405, 26, -67, 108, 0, -243, 1228, -2211, 13706, 24, -60, 90, 37, -304, 1294, -2277, 12996, 22, -53, 72, 72, -360, 1349, -2318, 12278, 20, -46, 54, 105, -410, 1392, -2334, 11556, 18, -39, 37, 136, -455, 1425, -2327, 10831, 15, -31, 21, 164, -495, 1446, -2298, 10107, 13, -24, 5, 191, -529, 1456, -2249, 9385, 10, -17, -10, 215, -557, 1456, -2182, 8669, 8, -10, -24, 236, -580, 1446, -2096, 7962, 5, -3, -37, 255, -597, 1426, -1996, 7265, 3, 4, -50, 271, -608, 1397, -1881, 6580, 0, 10, -61, 284, -615, 1359, -1753, 5911};

    public BlipBuffer() {
        this.accum = new AtomicInteger(0);
        this.setVolume(1.0);
    }

    @Override
    public void setSampleRate(int rate, int msec) {
        this.sampleRate = rate;
        this.buf = new int[(int)((long)msec * (long)rate / 1000L) + 1024];
    }

    @Override
    public void setClockRate(int rate) {
        this.clockRate_ = rate;
        assert (this.clockRate_ > 0);
        this.factor = (int)((double)((float)this.sampleRate / (float)this.clockRate_ * 65536.0f) + 0.5);
    }

    @Override
    public int clockRate() {
        return this.clockRate_;
    }

    @Override
    public int getBufLen() {
        return this.buf.length;
    }

    @Override
    public void clear() {
        this.offset = 0;
        this.accum.set(0);
        Arrays.fill(this.buf, 0, this.buf.length, 0);
    }

    @Override
    public void setVolume(double v) {
        int shift = 15;
        int round = 16384;
        this.volume = (int)(32768.0 * v + 0.5) & 0xFFFFFFFE;
    }

    private void addDeltaInternal(int time, int delta) {
        int[] buf = this.buf;
        time = time * this.factor + this.offset;
        int phase = time >> 8 & 0xFF;
        int right = ((delta *= this.volume) >> 8) * phase;
        int n = time >>= 16;
        buf[n] = buf[n] + (delta - right);
        int n2 = time + 1;
        buf[n2] = buf[n2] + right;
    }

    @Override
    public int countSamples(int time) {
        int last_sample = time * this.factor + this.offset >> 16;
        int first_sample = this.offset >> 16;
        return last_sample - first_sample;
    }

    @Override
    public void addDelta(int time, int deltaL, int deltaR) {
        assert (deltaL == deltaR);
        this.addDeltaInternal(time, deltaL);
    }

    @Override
    public void endFrame(int time) {
        this.offset += time * this.factor;
        assert (this.samplesAvail() < this.buf.length);
    }

    @Override
    public int samplesAvail() {
        return this.offset >> 16;
    }

    @Override
    public int readSamples16bitStereo(byte[] out, int pos, int countMono) {
        return BlipBufferHelper.readSamples16bitStereo(this, out, pos, countMono);
    }

    void removeSilence(int count) {
        this.offset -= count << 16;
        assert (this.samplesAvail() >= 0);
    }

    void removeSamples(int count) {
        int remain = this.samplesAvail() - count + 16;
        System.arraycopy(this.buf, count, this.buf, 0, remain);
        Arrays.fill(this.buf, remain, remain + count, 0);
        this.removeSilence(count);
    }
}

