/*
 * Decompiled with CFR 0.152.
 */
package s32x.util.blipbuffer;

import omegadrive.util.ArrayEndianUtil;
import s32x.util.blipbuffer.BlipBuffer;

public class BlipBufferHelper {
    public static int readSamples16bitStereo(BlipBuffer blipBuffer, byte[] out, int pos, int countMono) {
        int availMonoSamples = blipBuffer.samplesAvail();
        if (countMono > availMonoSamples) {
            countMono = availMonoSamples;
        }
        if (countMono > 0) {
            int[] deltaBuf = blipBuffer.buf;
            int accum = blipBuffer.accum.get();
            int i = 0;
            do {
                int s;
                if ((short)(s = (accum += deltaBuf[i] - (accum >> 9)) >> 15) != s) {
                    s = BlipBufferHelper.clampToShort(s);
                }
                ArrayEndianUtil.setSigned16LE((short)s, out, pos);
                ArrayEndianUtil.setSigned16LE((short)s, out, pos + 2);
                pos += 4;
            } while (++i < countMono);
            blipBuffer.accum.set(accum);
            blipBuffer.removeSamples(countMono);
        }
        return countMono;
    }

    public static int readSamples16bitMono(BlipBuffer blipBuffer, int[] out, int pos, int countMono) {
        int availMonoSamples = blipBuffer.samplesAvail();
        if (countMono > availMonoSamples) {
            countMono = availMonoSamples;
        }
        assert (pos == 0);
        assert (out.length >= countMono);
        if (countMono > 0) {
            int[] buf = blipBuffer.buf;
            int accum = blipBuffer.accum.get();
            int i = 0;
            do {
                int sample;
                if ((short)(sample = (accum += buf[i] - (accum >> 9)) >> 15) != sample) {
                    sample = BlipBufferHelper.clampToShort(sample);
                }
                out[pos++] = sample;
            } while (++i < countMono);
            blipBuffer.accum.set(accum);
            blipBuffer.removeSamples(countMono);
        }
        return countMono;
    }

    public static int readSamples8bit(BlipBuffer blipBuffer, byte[] out, int pos, int count) {
        int avail = blipBuffer.samplesAvail();
        if (count > avail) {
            count = avail;
        }
        if (count > 0) {
            int[] buf = blipBuffer.buf;
            int accum = blipBuffer.accum.get();
            pos <<= 1;
            int i = 0;
            do {
                int s;
                if ((byte)(s = (accum += buf[i] - (accum >> 9)) >> 15) != s) {
                    s = BlipBufferHelper.clampToByte(s);
                }
                out[pos++] = (byte)s;
            } while (++i < count);
            blipBuffer.accum.set(accum);
            blipBuffer.removeSamples(count);
        }
        return count;
    }

    public int readSamples(BlipBuffer blipBuffer, byte[] out, int pos, int count) {
        int avail = blipBuffer.samplesAvail();
        if (count > avail) {
            count = avail;
        }
        if (count > 0) {
            int[] buf = blipBuffer.buf;
            int accum = blipBuffer.accum.get();
            pos <<= 1;
            int i = 0;
            do {
                int s;
                if ((short)(s = (accum += buf[i] - (accum >> 9)) >> 15) != s) {
                    s = BlipBufferHelper.clampToShort(s);
                }
                out[pos] = (byte)(s >> 8);
                out[pos + 1] = (byte)s;
                pos += 2;
            } while (++i < count);
            blipBuffer.accum.set(accum);
            blipBuffer.removeSamples(count);
        }
        return count;
    }

    public static int clampToShort(int value) {
        if (value > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        if (value < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return value;
    }

    public static int clampToByte(int value) {
        if (value > 127) {
            return 127;
        }
        if (value < -128) {
            return -128;
        }
        return value;
    }
}

