/*
 * Decompiled with CFR 0.152.
 */
package s32x.util.debug;

import java.nio.ByteBuffer;
import java.util.Arrays;
import omegadrive.system.SystemProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class SdramSyncTester {
    private static final Logger LOG = LogHelper.getLogger(SdramSyncTester.class.getSimpleName());
    private static final int MAST_READ = 1;
    private static final int MAST_WRITE = 2;
    private static final int SLAVE_READ = 4;
    private static final int SLAVE_WRITE = 8;
    private static final String[] names = new String[]{"EMPTY", "MAST_READ", "MAST_WRITE", "EMPTY", "SLAVE_READ", "EMPTY", "EMPTY", "EMPTY", "SLAVE_WRITE"};
    public static final SdramSyncTester NO_OP = new SdramSyncTester(null);
    private final SdramSync[] sdramAccess;
    private Runnable valToWrite;
    private int clockDiffMin = 100;
    private final ByteBuffer sdram;

    public SdramSyncTester(ByteBuffer sdram) {
        this.sdramAccess = new SdramSync[sdram == null ? 0 : 262144];
        for (int i = 0; i < this.sdramAccess.length; ++i) {
            this.sdramAccess[i] = new SdramSync();
        }
        this.sdram = sdram;
    }

    public void readSyncCheck(BufferUtil.CpuDeviceAccess cpuAccess, int address, Size size) {
        if (this.valToWrite != null && cpuAccess == BufferUtil.CpuDeviceAccess.MASTER) {
            LOG.info("Writing after reading: {} {}", (Object)Util.th(address), (Object)size);
            this.valToWrite.run();
            this.valToWrite = null;
        }
        SystemProvider.SystemClock clock = SystemProvider.NO_CLOCK;
        int readType = cpuAccess == BufferUtil.CpuDeviceAccess.MASTER ? 1 : 4;
        this.sdramAccess[address & 0x3FFFF].accessMask |= readType;
        this.sdramAccess[address & 0x3FFFF].cycleAccess[readType] = clock.getCycleCounter();
    }

    public void writeSyncCheck(BufferUtil.CpuDeviceAccess cpuAccess, int address, int val, Size size) {
        boolean check;
        SystemProvider.SystemClock clock = SystemProvider.NO_CLOCK;
        boolean bl = check = cpuAccess == BufferUtil.CpuDeviceAccess.SLAVE && (address & 0x3FFFF) == 19488 && clock.getCycleCounter() == 111787;
        if (check) {
            int v = val;
            this.valToWrite = () -> BufferUtil.writeBufferRaw(this.sdram, address & 0x3FFFF, v, size);
        } else {
            BufferUtil.writeBufferRaw(this.sdram, address & 0x3FFFF, val, size);
        }
        int writeType = cpuAccess == BufferUtil.CpuDeviceAccess.MASTER ? 2 : 8;
        this.sdramAccess[address & 0x3FFFF].accessMask |= writeType;
        this.sdramAccess[address & 0x3FFFF].cycleAccess[writeType] = clock.getCycleCounter();
    }

    public void newFrameSync() {
        for (int i = 0; i < this.sdramAccess.length; ++i) {
            boolean ok;
            if (this.sdramAccess[i].accessMask <= 2) continue;
            SdramSync entry = this.sdramAccess[i];
            int val = entry.accessMask;
            int check = val & 9 | val & 6;
            boolean bl = ok = val != 3 && val != 12 && val != 5 && val != 10;
            if (check > 0 && ok) {
                Object s = "";
                int localMin = Integer.MAX_VALUE;
                int localMax = Integer.MIN_VALUE;
                int cnt = 0;
                for (int j = 0; j < entry.cycleAccess.length; ++j) {
                    if (entry.cycleAccess[j] <= 0) continue;
                    ++cnt;
                    s = (String)s + names[j] + ": " + entry.cycleAccess[j] + ",";
                    localMax = Math.max(entry.cycleAccess[j], localMax);
                    localMin = Math.min(entry.cycleAccess[j], localMin);
                }
                int diff = Math.abs(localMax - localMin);
                if (cnt > 1 && diff < this.clockDiffMin) {
                    this.clockDiffMin = Math.max(100, diff);
                    LOG.info("Sync on: {}, {}, clockDiff: {}\n{}", new Object[]{Util.th(i), Util.th(val), diff, s});
                }
            }
            this.sdramAccess[i].accessMask = 0;
            Arrays.fill(this.sdramAccess[i].cycleAccess, 0);
        }
    }

    static class SdramSync {
        int accessMask;
        int[] cycleAccess = new int[9];

        SdramSync() {
        }
    }
}

