/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.digitalmediaserver.cuelib.CueSheet;
import org.digitalmediaserver.cuelib.FileData;
import org.digitalmediaserver.cuelib.Index;
import org.digitalmediaserver.cuelib.Position;
import org.digitalmediaserver.cuelib.TrackData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CueSheetToXmlSerializer {
    private DocumentBuilder docBuilder;
    private String namespace = "http://jwbroek/cuelib/2008/cuesheet/1";

    public CueSheetToXmlSerializer() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        this.docBuilder = docBuilderFactory.newDocumentBuilder();
    }

    public void serializeCueSheet(CueSheet cueSheet, Writer writer) throws TransformerException {
        this.serializeCueSheet(cueSheet, new StreamResult(writer));
    }

    public void serializeCueSheet(CueSheet cueSheet, OutputStream outputStream) throws TransformerException {
        this.serializeCueSheet(cueSheet, new StreamResult(outputStream));
    }

    public void serializeCueSheet(CueSheet cueSheet, File file) throws TransformerException {
        this.serializeCueSheet(cueSheet, new StreamResult(file));
    }

    public void serializeCueSheet(CueSheet cueSheet, Result result) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer identityTransformer = transformerFactory.newTransformer();
        DOMSource cueSheetSource = new DOMSource(this.serializeCueSheet(cueSheet));
        identityTransformer.transform(cueSheetSource, result);
    }

    public Document serializeCueSheet(CueSheet cueSheet) {
        Document doc = this.docBuilder.newDocument();
        Element cueSheetElement = doc.createElementNS(this.namespace, "cuesheet");
        doc.appendChild(cueSheetElement);
        CueSheetToXmlSerializer.addAttribute(cueSheetElement, "genre", cueSheet.getGenre());
        CueSheetToXmlSerializer.addAttribute(cueSheetElement, "date", cueSheet.getYear());
        CueSheetToXmlSerializer.addAttribute(cueSheetElement, "discid", cueSheet.getDiscId());
        CueSheetToXmlSerializer.addAttribute(cueSheetElement, "comment", cueSheet.getComment());
        CueSheetToXmlSerializer.addAttribute(cueSheetElement, "catalog", cueSheet.getCatalog());
        CueSheetToXmlSerializer.addAttribute(cueSheetElement, "performer", cueSheet.getPerformer());
        CueSheetToXmlSerializer.addAttribute(cueSheetElement, "title", cueSheet.getTitle());
        CueSheetToXmlSerializer.addAttribute(cueSheetElement, "songwriter", cueSheet.getSongwriter());
        CueSheetToXmlSerializer.addAttribute(cueSheetElement, "cdtextfile", cueSheet.getCdTextFile());
        for (FileData fileData : cueSheet.getFileData()) {
            this.serializeFileData(cueSheetElement, fileData);
        }
        return doc;
    }

    protected void serializeFileData(Element parentElement, FileData fileData) {
        Document doc = parentElement.getOwnerDocument();
        Element fileElement = doc.createElementNS(this.namespace, "file");
        parentElement.appendChild(fileElement);
        CueSheetToXmlSerializer.addAttribute(fileElement, "file", fileData.getFile());
        CueSheetToXmlSerializer.addAttribute(fileElement, "type", fileData.getFileType());
        for (TrackData trackData : fileData.getTrackData()) {
            this.serializeTrackData(fileElement, trackData);
        }
    }

    protected void serializeTrackData(Element parentElement, TrackData trackData) {
        Document doc = parentElement.getOwnerDocument();
        Element trackElement = doc.createElementNS(this.namespace, "track");
        parentElement.appendChild(trackElement);
        CueSheetToXmlSerializer.addAttribute(trackElement, "number", trackData.getNumber());
        CueSheetToXmlSerializer.addAttribute(trackElement, "type", trackData.getDataType());
        CueSheetToXmlSerializer.addAttribute(trackElement, "isrc", trackData.getIsrcCode());
        CueSheetToXmlSerializer.addAttribute(trackElement, "performer", trackData.getPerformer());
        CueSheetToXmlSerializer.addAttribute(trackElement, "title", trackData.getTitle());
        CueSheetToXmlSerializer.addAttribute(trackElement, "songwriter", trackData.getSongwriter());
        this.addElement(trackElement, "pregap", trackData.getPregap());
        this.addElement(trackElement, "postgap", trackData.getPostgap());
        if (trackData.getFlags().size() > 0) {
            this.serializeFlags(trackElement, trackData.getFlags());
        }
        for (Index index : trackData.getIndices()) {
            this.serializeIndex(trackElement, index);
        }
    }

    protected void serializeFlags(Element parentElement, Set<String> flags) {
        Document doc = parentElement.getOwnerDocument();
        Element flagsElement = doc.createElementNS(this.namespace, "flags");
        parentElement.appendChild(flagsElement);
        for (String flag : flags) {
            this.addElement(flagsElement, "flag", flag);
        }
    }

    protected void serializeIndex(Element parentElement, Index index) {
        Element indexElement = this.addElement(parentElement, "index", index.getPosition(), true);
        CueSheetToXmlSerializer.addAttribute(indexElement, "number", index.getNumber());
    }

    protected Element addElement(Element parentElement, String elementName, Position position) {
        return this.addElement(parentElement, elementName, position, false);
    }

    protected Element addElement(Element parentElement, String elementName, Position position, boolean forceElement) {
        Element positionElement = null;
        if (position != null || forceElement) {
            positionElement = parentElement.getOwnerDocument().createElementNS(this.namespace, elementName);
            parentElement.appendChild(positionElement);
            if (position != null) {
                positionElement.setAttribute("minutes", "" + position.getMinutes());
                positionElement.setAttribute("seconds", "" + position.getSeconds());
                positionElement.setAttribute("frames", "" + position.getFrames());
            }
        }
        return positionElement;
    }

    protected Element addElement(Element parentElement, String elementName, String value) {
        Element newElement = null;
        if (value != null) {
            newElement = parentElement.getOwnerDocument().createElementNS(this.namespace, elementName);
            newElement.appendChild(parentElement.getOwnerDocument().createTextNode(value));
            parentElement.appendChild(newElement);
        }
        return newElement;
    }

    protected Element addElement(Element parentElement, String elementName, int value) {
        Element newElement = null;
        if (value > -1) {
            newElement = parentElement.getOwnerDocument().createElementNS(this.namespace, elementName);
            newElement.appendChild(parentElement.getOwnerDocument().createTextNode("" + value));
            parentElement.appendChild(newElement);
        }
        return newElement;
    }

    protected static void addAttribute(Element parentElement, String attributeName, String value) {
        if (value != null) {
            parentElement.setAttribute(attributeName, value);
        }
    }

    protected static void addAttribute(Element parentElement, String attributeName, int value) {
        if (value > -1) {
            parentElement.setAttribute(attributeName, "" + value);
        }
    }
}

