/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib;

import java.util.Locale;

public class Position {
    private int minutes = 0;
    private int seconds = 0;
    private int frames = 0;

    public Position() {
    }

    public Position(int minutes, int seconds, int frames) {
        this.minutes = minutes;
        this.seconds = seconds;
        this.frames = frames;
    }

    public Position(long sampleNumber, int sampleRate) {
        int totalSeconds = (int)(sampleNumber / (long)sampleRate);
        this.minutes = totalSeconds / 60;
        this.seconds = totalSeconds % 60;
        this.frames = (int)(sampleNumber % (long)sampleRate * 75L / (long)sampleRate);
    }

    public int getTotalFrames() {
        return this.frames + 75 * (this.seconds + 60 * this.minutes);
    }

    public int getFrames() {
        return this.frames;
    }

    public void setFrames(int frames) {
        this.frames = frames;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%d:%02d.%02d", this.minutes, this.seconds, this.frames);
    }
}

