/*
 * Decompiled with CFR 0.152.
 */
package mcd;

import mcd.asic.Asic;
import mcd.asic.AsicModel;
import mcd.bus.McdSubInterruptHandler;
import mcd.bus.MegaCdMainCpuBus;
import mcd.bus.MegaCdMainCpuBusIntf;
import mcd.bus.MegaCdSubCpuBus;
import mcd.bus.MegaCdSubCpuBusIntf;
import mcd.cdc.Cdc;
import mcd.cdd.Cdd;
import mcd.dict.MegaCdMemoryContext;
import mcd.pcm.McdPcm;
import omegadrive.bus.md.MdBus;
import omegadrive.bus.model.MdMainBusProvider;
import omegadrive.cpu.m68k.MC68000Wrapper;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class McdDeviceHelper {
    private static final Logger LOG = LogHelper.getLogger(McdDeviceHelper.class.getSimpleName());

    private McdDeviceHelper() {
        assert (false);
    }

    public static McdLaunchContext setupDevices() {
        McdLaunchContext ctx = new McdLaunchContext();
        ctx.initContext();
        return ctx;
    }

    public static class McdLaunchContext {
        public MC68000Wrapper subCpu;
        public MdMainBusProvider mdBus;
        public MegaCdSubCpuBusIntf subBus;
        public MegaCdMainCpuBusIntf mainBus;
        public MegaCdMemoryContext memoryContext;
        public McdSubInterruptHandler interruptHandler;
        public McdPcm pcm;
        public Cdd cdd;
        public Cdc cdc;
        public AsicModel.AsicOp asic;

        public void initContext() {
            this.memoryContext = new MegaCdMemoryContext();
            this.pcm = new McdPcm();
            this.mdBus = new MdBus();
            this.subBus = new MegaCdSubCpuBus(this.memoryContext);
            this.mainBus = new MegaCdMainCpuBus(this.memoryContext, this.mdBus);
            this.subCpu = MC68000Wrapper.createInstance(BufferUtil.CpuDeviceAccess.SUB_M68K, this.subBus);
            this.interruptHandler = McdSubInterruptHandler.create(this.memoryContext, this.subCpu);
            this.cdc = Cdc.createInstance(this.memoryContext, this.interruptHandler);
            this.cdd = Cdd.createInstance(this.memoryContext, this.interruptHandler, this.cdc);
            this.asic = new Asic(this.memoryContext, this.interruptHandler);
            this.subBus.attachDevices(this.subCpu, this.pcm, this.cdd, this.asic, this.cdc, this.interruptHandler);
            this.mainBus.setSubDevices(this.subCpu, this.subBus);
            this.subCpu.setStop(true);
        }

        public void stepDevices(int cyles) {
            this.subBus.step(cyles);
        }

        public void reset() {
        }
    }
}

