/*
 * Decompiled with CFR 0.152.
 */
package mcd.asic;

import mcd.asic.AsicModel;
import mcd.bus.McdSubInterruptHandler;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class Asic
implements AsicModel.AsicOp {
    private static final Logger LOG = LogHelper.getLogger(Asic.class.getSimpleName());
    private final boolean verbose = false;
    private AsicModel.StampConfig stampConfig = new AsicModel.StampConfig();
    private MegaCdMemoryContext memoryContext;
    private McdSubInterruptHandler interruptHandler;
    private AsicModel.AsicEvent asicEvent = AsicModel.AsicEvent.AS_STOP;
    int cd_graphics_x;
    int cd_graphics_dst_x;
    int cd_graphics_y;
    int cd_graphics_dst_y;
    int cd_graphics_dx;
    int cd_graphics_dy;
    int[] cd_graphics_pixels = new int[4];
    int cycles;
    private boolean doFetch = true;
    int cycleCost;

    public Asic(MegaCdMemoryContext memoryContext, McdSubInterruptHandler ih) {
        this.memoryContext = memoryContext;
        this.interruptHandler = ih;
    }

    @Override
    public int read(MegaCdDict.RegSpecMcd regSpec, int address, Size size) {
        return BufferUtil.readBuffer(this.memoryContext.getRegBuffer(BufferUtil.CpuDeviceAccess.SUB_M68K, regSpec), address & 0x1FF, size);
    }

    @Override
    public void write(MegaCdDict.RegSpecMcd regSpec, int address, int value, Size size) {
        BufferUtil.writeBufferRaw(this.memoryContext.commonGateRegsBuf, address & 0x1FF, value, size);
        if (regSpec != MegaCdDict.RegSpecMcd.MCD_IMG_STAMP_SIZE && regSpec != MegaCdDict.RegSpecMcd.MCD_IMG_OFFSET) assert (size == Size.WORD) : String.valueOf((Object)regSpec) + "," + String.valueOf((Object)size);
        switch (regSpec) {
            case MCD_IMG_STAMP_SIZE: {
                int val = Util.readBufferWord(this.memoryContext.commonGateRegsBuf, regSpec.addr);
                assert (value >> 15 == 0);
                this.stampConfig.stampRepeat = AsicModel.StampRepeat.vals[val & 1];
                this.stampConfig.stampSize = AsicModel.StampSize.vals[val >> 1 & 1];
                this.stampConfig.stampMapSize = AsicModel.StampMapSize.vals[val >> 2 & 1];
                break;
            }
            case MCD_IMG_STAMP_MAP_ADDR: {
                this.stampConfig.stampStartLocation = value;
                break;
            }
            case MCD_IMG_VCELL: {
                this.stampConfig.vCellSize = (value & 0x1F) + 1;
                break;
            }
            case MCD_IMG_START_ADDR: {
                this.stampConfig.imgDestBufferLocation = value;
                break;
            }
            case MCD_IMG_OFFSET: {
                assert (size != Size.BYTE || (address & 1) == 1);
                this.stampConfig.hPixelOffset = value & 7;
                this.stampConfig.vPixelOffset = value >> 3 & 7;
                this.stampConfig.imgOffset = value & 0x3F;
                break;
            }
            case MCD_IMG_HDOT: {
                this.stampConfig.imgWidthPx = value & 0x1FF;
                break;
            }
            case MCD_IMG_VDOT: {
                this.stampConfig.imgHeightPx = value & 0xFF;
                break;
            }
            case MCD_IMG_TRACE_VECTOR_ADDR: {
                this.stampConfig.imgTraceTableLocation = (value & 0xFFFFFFFE) << 2;
                this.cd_graphics_dst_y = this.stampConfig.vPixelOffset;
                this.asicEvent(AsicModel.AsicEvent.AS_START);
                this.gfxCycleCost();
                break;
            }
            default: {
                LOG.error("Unhandled: {}, {} {}", new Object[]{regSpec, Util.th(value), size});
                assert (false);
                break;
            }
        }
    }

    @Override
    public void setStampPriorityMode(int value) {
        AsicModel.StampPriorityMode spm = AsicModel.StampPriorityMode.vals[value & 3];
        assert (spm != AsicModel.StampPriorityMode.ILLEGAL);
        if (spm != this.stampConfig.priorityMode) {
            this.stampConfig.priorityMode = spm;
        }
    }

    @Override
    public AsicModel.StampPriorityMode getStampPriorityMode() {
        return this.stampConfig.priorityMode;
    }

    private void doRenderLines(int num) {
        int target = Math.max(0, this.stampConfig.imgHeightPx - num);
        int line = this.stampConfig.imgHeightPx;
        do {
            this.doRenderingSlot();
            if (line == this.stampConfig.imgHeightPx) continue;
        } while (target != this.stampConfig.imgHeightPx);
    }

    private void doRenderingSlot() {
        this.cycles = 0;
        int hLimit = this.stampConfig.imgWidthPx + this.stampConfig.hPixelOffset;
        for (int i = 0; i < 4; ++i) {
            if (this.doFetch) {
                int tvb = (BufferUtil.readBuffer(this.memoryContext.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_IMG_TRACE_VECTOR_ADDR.addr, Size.WORD) & Size.WORD.getMask()) << 2;
                this.cd_graphics_x = this.memoryContext.wramHelper.readWordRam(BufferUtil.CpuDeviceAccess.SUB_M68K, tvb, Size.WORD) << 8;
                this.cycles += 12;
                this.cd_graphics_dst_x = this.stampConfig.hPixelOffset;
                this.cd_graphics_y = this.memoryContext.wramHelper.readWordRam(BufferUtil.CpuDeviceAccess.SUB_M68K, tvb + 2, Size.WORD) << 8;
                this.cycles += 8;
                this.cd_graphics_dx = this.memoryContext.wramHelper.readWordRam(BufferUtil.CpuDeviceAccess.SUB_M68K, tvb + 4, Size.WORD);
                if ((this.cd_graphics_dx & 0x8000) > 0) {
                    this.cd_graphics_dx |= 0xFFFF0000;
                }
                this.cycles += 8;
                this.cd_graphics_dy = this.memoryContext.wramHelper.readWordRam(BufferUtil.CpuDeviceAccess.SUB_M68K, tvb + 6, Size.WORD);
                if ((this.cd_graphics_dy & 0x8000) > 0) {
                    this.cd_graphics_dy |= 0xFFFF0000;
                }
                this.cycles += 8;
            }
            this.cd_graphics_pixels[i] = this.get_src_pixel();
            if ((this.cd_graphics_dst_x & 3) == 3 - i || this.cd_graphics_dst_x + i + 1 == hLimit) {
                this.drawPixel();
                break;
            }
            this.cycles += 8;
        }
    }

    private void drawPixel() {
        int to_draw = 4 - (this.cd_graphics_dst_x & 3);
        int x_end = this.stampConfig.imgWidthPx + this.stampConfig.hPixelOffset;
        if (this.cd_graphics_dst_x + to_draw > x_end) {
            to_draw = this.stampConfig.imgWidthPx + this.stampConfig.hPixelOffset - this.cd_graphics_dst_x;
        }
        for (int i = 0; i < to_draw; ++i) {
            int dst_address = this.stampConfig.imgDestBufferLocation << 1;
            dst_address += this.cd_graphics_dst_y << 1;
            dst_address += this.cd_graphics_dst_x >> 2 & 1;
            dst_address += (this.cd_graphics_dst_x >>> 3) * this.stampConfig.vCellSize << 4;
            int pixel_shift = 12 - 4 * (this.cd_graphics_dst_x & 3);
            int pixel = this.cd_graphics_pixels[i] << pixel_shift;
            int src_mask_check = 15 << pixel_shift;
            int src_mask_keep = ~src_mask_check;
            pixel &= src_mask_check;
            int wramVal = this.memoryContext.wramHelper.readWordRam(BufferUtil.CpuDeviceAccess.SUB_M68K, dst_address << 1, Size.WORD);
            wramVal = switch (this.stampConfig.priorityMode) {
                default -> throw new IncompatibleClassChangeError();
                case AsicModel.StampPriorityMode.PM_OFF -> wramVal & src_mask_keep | pixel;
                case AsicModel.StampPriorityMode.UNDERWRITE -> {
                    if (pixel > 0 && (wramVal & src_mask_check) == 0) {
                        wramVal = wramVal & src_mask_keep | pixel;
                    }
                    yield wramVal;
                }
                case AsicModel.StampPriorityMode.OVERWRITE -> {
                    if (pixel > 0) {
                        wramVal = wramVal & src_mask_keep | pixel;
                    }
                    yield wramVal;
                }
                case AsicModel.StampPriorityMode.ILLEGAL -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    yield wramVal;
                }
            };
            this.memoryContext.wramHelper.writeWordRam(BufferUtil.CpuDeviceAccess.SUB_M68K, dst_address << 1, wramVal, Size.WORD);
            ++this.cd_graphics_dst_x;
        }
        this.doFetch = false;
        if (this.cd_graphics_dst_x == x_end) {
            ++this.cd_graphics_dst_y;
            --this.stampConfig.imgHeightPx;
            BufferUtil.writeBufferRaw(this.memoryContext.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_IMG_VDOT.addr, this.stampConfig.imgHeightPx, Size.WORD);
            int tvb = BufferUtil.readBuffer(this.memoryContext.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_IMG_TRACE_VECTOR_ADDR.addr, Size.WORD);
            BufferUtil.writeBufferRaw(this.memoryContext.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_IMG_TRACE_VECTOR_ADDR.addr, tvb + 2, Size.WORD);
            this.doFetch = true;
            if (this.stampConfig.imgHeightPx == 0) {
                this.asicEvent(AsicModel.AsicEvent.AS_STOP);
            }
        }
    }

    public static void printWram(MegaCdMemoryContext mc) {
        StringBuilder sb = new StringBuilder();
        for (int i = 524288; i < 786432; i += 2) {
            sb.append((mc.wramHelper.readWordRam(BufferUtil.CpuDeviceAccess.SUB_M68K, i, Size.WORD) & 0xFFFF) + ",");
            if ((i + 2 >> 1) % 16 != 0) continue;
            sb.append("\n");
        }
        System.out.println(sb);
    }

    private int get_src_pixel() {
        int row_shift;
        int base_mask;
        int max;
        int stamp_num_mask;
        int pixel_mask;
        int stamp_shift;
        int x = this.cd_graphics_x >>> 11;
        int y = this.cd_graphics_y >>> 11;
        this.cd_graphics_x += this.cd_graphics_dx;
        this.cd_graphics_x &= 0xFFFFFF;
        this.cd_graphics_y += this.cd_graphics_dy;
        this.cd_graphics_y &= 0xFFFFFF;
        if (this.stampConfig.stampSize == AsicModel.StampSize._32x32) {
            stamp_shift = 5;
            pixel_mask = 31;
            stamp_num_mask = 2044;
        } else {
            stamp_shift = 4;
            pixel_mask = 15;
            stamp_num_mask = 2047;
        }
        int stamp_x = x >>> stamp_shift;
        int stamp_y = y >>> stamp_shift;
        if (this.stampConfig.stampMapSize == AsicModel.StampMapSize._4096x4096) {
            max = 4096 >> stamp_shift;
            base_mask = 57344 << (5 - stamp_shift << 1);
            row_shift = 12 - stamp_shift;
        } else {
            max = 256 >> stamp_shift;
            base_mask = 65504 << (5 - stamp_shift << 1);
            row_shift = 8 - stamp_shift;
        }
        if (stamp_x >= max || stamp_y >= max) {
            if (this.stampConfig.stampRepeat == AsicModel.StampRepeat.REPEAT_MAP) {
                stamp_x &= max - 1;
                stamp_y &= max - 1;
            } else {
                return 0;
            }
        }
        int address = (this.stampConfig.stampStartLocation & base_mask) << 1;
        int stamp_def = this.memoryContext.wramHelper.readWordRam(BufferUtil.CpuDeviceAccess.SUB_M68K, (address += (stamp_y << row_shift) + stamp_x) << 1, Size.WORD);
        int stamp_num = stamp_def & stamp_num_mask;
        if (stamp_num == 0) {
            return 0;
        }
        int pixel_x = x & pixel_mask;
        int pixel_y = y & pixel_mask;
        if ((stamp_def & 0x8000) > 0) {
            pixel_x = pixel_mask - pixel_x;
        }
        switch (stamp_def >> 13 & 3) {
            case 1: {
                int tmp = pixel_y;
                pixel_y = pixel_x;
                pixel_x = pixel_mask - tmp;
                break;
            }
            case 2: {
                pixel_y = pixel_mask - pixel_y;
                pixel_x = pixel_mask - pixel_x;
                break;
            }
            case 3: {
                int tmp = pixel_y;
                pixel_y = pixel_mask - pixel_x;
                pixel_x = tmp;
            }
        }
        int cell_x = pixel_x >> 3;
        assert (cell_x >= 0);
        int pixel_address = stamp_num << 6;
        int word = this.memoryContext.wramHelper.readWordRam(BufferUtil.CpuDeviceAccess.SUB_M68K, (pixel_address += (pixel_y << 1) + (cell_x << stamp_shift + 1) + (pixel_x >> 2 & 1)) << 1, Size.WORD);
        return switch (pixel_x & 3) {
            case 1 -> word >> 8 & 0xF;
            case 2 -> word >> 4 & 0xF;
            case 3 -> word & 0xF;
            default -> word >> 12 & 0xF;
        };
    }

    public int gfxCycleCost() {
        this.cycleCost = 4 * this.stampConfig.imgHeightPx * (13 + 2 * this.stampConfig.hPixelOffset + 9 * (this.stampConfig.imgWidthPx + this.stampConfig.hPixelOffset - 1));
        return this.cycleCost;
    }

    private void asicEvent(AsicModel.AsicEvent event) {
        if (event == this.asicEvent) {
            assert (Util.readBufferWord(this.memoryContext.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_IMG_STAMP_SIZE.addr) >>> 15 == event.ordinal());
            return;
        }
        BufferUtil.setBit(this.memoryContext.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_IMG_STAMP_SIZE.addr, 15, event.ordinal(), Size.WORD);
        if (this.asicEvent != event && event == AsicModel.AsicEvent.AS_STOP) {
            this.interruptHandler.raiseInterrupt(McdSubInterruptHandler.SubCpuInterrupt.INT_ASIC);
        }
        this.asicEvent = event;
    }

    @Override
    public void step(int cycles) {
        if (this.asicEvent != AsicModel.AsicEvent.AS_START || this.stampConfig.imgHeightPx == 0) {
            return;
        }
        this.doRenderLines(75);
    }
}

