/*
 * Decompiled with CFR 0.152.
 */
package mcd.bus;

import java.util.Arrays;
import mcd.bus.MegaCdMainCpuBus;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import mcd.util.McdRegBitUtil;
import omegadrive.Device;
import omegadrive.cpu.m68k.M68kProvider;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Util;
import org.slf4j.Logger;

public interface McdSubInterruptHandler
extends Device {
    public static final Logger LOG = LogHelper.getLogger(McdSubInterruptHandler.class.getSimpleName());
    public static final boolean verbose = false;
    public static final SubCpuInterrupt[] intVals = SubCpuInterrupt.values();

    @Deprecated
    public void setRegion(RegionDetector.Region var1);

    public void handleInterrupts();

    public void raiseInterrupt(SubCpuInterrupt var1);

    public void lowerInterrupt(SubCpuInterrupt var1);

    public static McdSubInterruptHandler create(MegaCdMemoryContext context, M68kProvider c) {
        return new McdSubInterruptHandlerImpl(context, c);
    }

    public static boolean checkInterruptEnabled(int reg, int m68kLevel) {
        return (reg & 1 << m68kLevel) > 0;
    }

    public static void printEnabledInterrupts(int reg33) {
    }

    public static class McdSubInterruptHandlerImpl
    implements McdSubInterruptHandler {
        private M68kProvider subCpu;
        private MegaCdMemoryContext context;
        private boolean[] pendingInterrupts = new boolean[intVals.length];
        private int pendingMask = 0;
        private RegionDetector.Region region = RegionDetector.Region.USA;

        private McdSubInterruptHandlerImpl(MegaCdMemoryContext c, M68kProvider subCpu) {
            this.subCpu = subCpu;
            this.context = c;
        }

        @Override
        public void raiseInterrupt(SubCpuInterrupt sint) {
            this.setPending(sint, 1);
        }

        @Override
        public void lowerInterrupt(SubCpuInterrupt intp) {
            this.setPending(intp, 0);
        }

        @Override
        public void setRegion(RegionDetector.Region region) {
            if (this.region != region) {
                LOG.info("Interrupt hack for region: {}", (Object)region);
                this.region = region;
            }
        }

        @Override
        public void handleInterrupts() {
            if (this.pendingMask == 0) {
                return;
            }
            int mask = this.getRegMask();
            int ifl2 = MegaCdMainCpuBus.ifl2Trigger;
            for (int i = 1; i < this.pendingInterrupts.length; ++i) {
                if (!this.pendingInterrupts[i]) continue;
                boolean canRaise = (1 << i & mask) > 0;
                if ((canRaise &= i != SubCpuInterrupt.INT_LEVEL2.ordinal() || ifl2 != 0) && this.m68kInterrupt(i)) {
                    this.setPending(intVals[i], 0);
                    if (intVals[i] != SubCpuInterrupt.INT_LEVEL2) break;
                    McdRegBitUtil.setBitDefInternal(this.context, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.BitRegDef.IFL2, 0);
                    break;
                }
                if (i != SubCpuInterrupt.INT_ASIC.ordinal()) continue;
                this.setPending(SubCpuInterrupt.INT_ASIC, 0);
            }
        }

        private void setPending(SubCpuInterrupt sint, int val) {
            assert ((val & 1) == val);
            this.pendingMask = Util.setBit(this.pendingMask, sint.ordinal(), val);
            this.pendingInterrupts[sint.ordinal()] = val > 0;
        }

        private int getRegMask() {
            return Util.readBufferByte(this.context.commonGateRegsBuf, MegaCdDict.RegSpecMcd.MCD_INT_MASK.addr + 1);
        }

        private boolean m68kInterrupt(int num) {
            assert (num > 0);
            boolean raised = this.subCpu.raiseInterrupt(num);
            LogHelper.logWarnOnce(LOG, "MegaCd interrupt hack active!!", new Object[0]);
            return this.region == RegionDetector.Region.EUROPE ? true : raised;
        }

        @Override
        public void reset() {
            this.pendingMask = 0;
            Arrays.fill(this.pendingInterrupts, false);
        }
    }

    public static enum SubCpuInterrupt {
        NONE,
        INT_ASIC,
        INT_LEVEL2,
        INT_TIMER,
        INT_CDD,
        INT_CDC,
        INT_SUBCODE;

    }
}

