/*
 * Decompiled with CFR 0.152.
 */
package mcd.bus;

import mcd.asic.AsicModel;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import mcd.util.McdRegBitUtil;
import mcd.util.McdWramCell;
import omegadrive.util.ArrayEndianUtil;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.MdRuntimeData;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class McdWordRamHelper {
    private static final Logger LOG = LogHelper.getLogger(McdWordRamHelper.class.getSimpleName());
    private MegaCdMemoryContext memoryContext;
    private byte[][] wordRam01;

    public McdWordRamHelper(MegaCdMemoryContext memoryContext, byte[][] wordRam01) {
        this.memoryContext = memoryContext;
        this.wordRam01 = wordRam01;
    }

    public void writeWordRam(BufferUtil.CpuDeviceAccess cpu, int address, int value, Size size) {
        switch (size) {
            case WORD: {
                this.writeWordRamWord(cpu, address, value);
                break;
            }
            case LONG: {
                this.writeWordRamWord(cpu, address, value >> 16);
                this.writeWordRamWord(cpu, address + 2, (short)value);
                break;
            }
            case BYTE: {
                int bank2 = McdWordRamHelper.getBank(this.memoryContext.wramSetup, cpu, address);
                int addr = McdWordRamHelper.getAddress(this.memoryContext.wramSetup, address, bank2) | address & 1;
                Util.writeData(this.wordRam01[bank2], addr, value, Size.BYTE);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public int readWordRam(BufferUtil.CpuDeviceAccess cpu, int address, Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.WORD -> this.readWordRamWord(cpu, address);
            case Size.LONG -> this.readWordRamWord(cpu, address) << 16 | this.readWordRamWord(cpu, address + 2);
            case Size.BYTE -> this.readWordRamWord(cpu, address & 0xFFFFFFFE) >> ((~address & 1) << 3);
        };
    }

    public void writeWordRamWord(BufferUtil.CpuDeviceAccess cpu, int address, int value) {
        if (cpu == this.memoryContext.wramSetup.cpu || this.memoryContext.wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M) {
            this.writeWordRamBank(McdWordRamHelper.getBank(this.memoryContext.wramSetup, cpu, address), address, value);
        } else {
            LogHelper.logWarnOnce(LOG, "{} writing WRAM but setup is: {}", new Object[]{cpu, this.memoryContext.wramSetup});
        }
    }

    public int readWordRamWord(BufferUtil.CpuDeviceAccess cpu, int address) {
        if (cpu == this.memoryContext.wramSetup.cpu || this.memoryContext.wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M) {
            return this.readWordRamBank(McdWordRamHelper.getBank(this.memoryContext.wramSetup, cpu, address), address);
        }
        LogHelper.logWarnOnce(LOG, "{} reading WRAM but setup is: {}", new Object[]{cpu, this.memoryContext.wramSetup});
        return Size.WORD.getMask();
    }

    public void writeWordRamBank(int bank2, int address, int value) {
        Util.writeData(this.wordRam01[bank2], McdWordRamHelper.getAddress(this.memoryContext.wramSetup, address, bank2), value, Size.WORD);
    }

    public int readWordRamBank(int bank2, int address) {
        return Util.readData(this.wordRam01[bank2], McdWordRamHelper.getAddress(this.memoryContext.wramSetup, address, bank2), Size.WORD);
    }

    public static int getBank(MegaCdMemoryContext.WramSetup wramSetup, BufferUtil.CpuDeviceAccess cpu, int address) {
        if (wramSetup.mode == MegaCdMemoryContext.WordRamMode._2M) {
            return (address & 0x3FFFF & 2) >> 1;
        }
        return McdWordRamHelper.getBank1M(wramSetup, cpu);
    }

    public static int getBank1M(MegaCdMemoryContext.WramSetup wramSetup, BufferUtil.CpuDeviceAccess cpu) {
        assert (wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M);
        return wramSetup.cpu == cpu ? 0 : 1;
    }

    public static int getAddress(MegaCdMemoryContext.WramSetup wramSetup, int address, int bank2) {
        address = wramSetup.mode == MegaCdMemoryContext.WordRamMode._2M ? ((address & 0x3FFFF) >> 1) - bank2 : (address &= 0x1FFFF);
        return address;
    }

    public MegaCdMemoryContext.WramSetup update(BufferUtil.CpuDeviceAccess c, int reg2) {
        int wpVal;
        int mode = reg2 & MegaCdDict.SharedBitDef.MODE.getBitMask();
        int dmna = reg2 & MegaCdDict.SharedBitDef.DMNA.getBitMask();
        int ret = reg2 & MegaCdDict.SharedBitDef.RET.getBitMask();
        MegaCdMemoryContext.WramSetup prev = this.memoryContext.wramSetup;
        if (mode > 0) {
            if (c == BufferUtil.CpuDeviceAccess.SUB_M68K) {
                LogHelper.logWarnOnceWhenEn(LOG, "{} Switch bank requested, ret: {}, current setup {}", new Object[]{c, ret, this.memoryContext.wramSetup});
                MegaCdMemoryContext.WramSetup wramSetup = this.memoryContext.wramSetup = ret == 0 ? MegaCdMemoryContext.WramSetup.W_1M_WR0_MAIN : MegaCdMemoryContext.WramSetup.W_1M_WR0_SUB;
                if (ret > 0) {
                    dmna = 0;
                }
                McdRegBitUtil.setSharedBitBothCpu(this.memoryContext, MegaCdDict.SharedBitDef.DMNA, dmna << 1);
                LogHelper.logWarnOnceWhenEn(LOG, "Setting wordRam to {}", new Object[]{this.memoryContext.wramSetup});
            }
            if (c == BufferUtil.CpuDeviceAccess.M68K) {
                boolean swapRequest;
                boolean bl = swapRequest = dmna == 0;
                if (swapRequest) {
                    if ((ret = ~ret & 1) > 0) {
                        dmna = ret;
                    }
                    McdRegBitUtil.setSharedBitBothCpu(this.memoryContext, MegaCdDict.SharedBitDef.DMNA, dmna << 1);
                    McdRegBitUtil.setSharedBitBothCpu(this.memoryContext, MegaCdDict.SharedBitDef.RET, ret);
                    this.memoryContext.wramSetup = ret == 0 ? MegaCdMemoryContext.WramSetup.W_1M_WR0_MAIN : MegaCdMemoryContext.WramSetup.W_1M_WR0_SUB;
                    LogHelper.logWarnOnceWhenEn(LOG, "Setting wordRam to {}", new Object[]{this.memoryContext.wramSetup});
                }
            }
            return this.memoryContext.wramSetup;
        }
        if (mode == 0) {
            if (this.memoryContext.wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M) {
                this.memoryContext.wramSetup = MegaCdMemoryContext.WramSetup.W_2M_MAIN;
            }
            if (c == BufferUtil.CpuDeviceAccess.M68K) {
                this.memoryContext.wramSetup = dmna > 0 ? MegaCdMemoryContext.WramSetup.W_2M_SUB : this.memoryContext.wramSetup;
            } else if (c == BufferUtil.CpuDeviceAccess.SUB_M68K) {
                MegaCdMemoryContext.WramSetup wramSetup = this.memoryContext.wramSetup = ret > 0 ? MegaCdMemoryContext.WramSetup.W_2M_MAIN : this.memoryContext.wramSetup;
            }
        }
        if (prev != this.memoryContext.wramSetup) {
            LogHelper.logInfo(LOG, "{} WRAM setup changed: {} -> {}", new Object[]{c, prev, this.memoryContext.wramSetup});
        }
        if ((wpVal = reg2 >> 8 & 0xFF) != this.memoryContext.writeProtectRam) {
            LOG.info("M PROG-RAM Write protection: {} -> {}", (Object)Util.th(this.memoryContext.writeProtectRam), (Object)Util.th(wpVal));
            this.memoryContext.writeProtectRam = wpVal;
        }
        return this.memoryContext.wramSetup;
    }

    public void writeCellMapped(int addr, int data, Size size) {
        assert (this.memoryContext.wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M);
        switch (size) {
            case BYTE: {
                int val = this.readCellMapped(addr, Size.WORD);
                ArrayEndianUtil.setByteInWordBE(val, data, addr & 1);
                this.writeCell(addr & 0xFFFFFFFE, val);
                break;
            }
            case WORD: {
                this.writeCell(addr, data);
                break;
            }
            case LONG: {
                this.writeCell(addr, data >> 16);
                this.writeCell(addr + 2, data);
            }
        }
    }

    public int readCellMapped(int address, Size size) {
        assert (MdRuntimeData.getAccessTypeExt() == BufferUtil.CpuDeviceAccess.M68K);
        int assignedBank = this.memoryContext.wramSetup.cpu == BufferUtil.CpuDeviceAccess.M68K ? 0 : 1;
        int otherBank = ~assignedBank & 1;
        int word = this.readWordRamBank(otherBank, address & 0xFFFFFFFE);
        if (size == Size.BYTE) {
            LogHelper.logWarnOnce(LOG, "readCellMapped BYTE", new Object[0]);
            return (address & 1) == 0 ? word >> 8 : word;
        }
        if (size == Size.LONG) {
            word = word << 16 | this.readCellMapped(address + 2, Size.WORD);
            LogHelper.logWarnOnce(LOG, "readCellMapped LONG", new Object[0]);
        }
        return word;
    }

    public int readDotMapped(int address, Size size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.BYTE -> this.readDotMappedByte(address);
            case Size.WORD -> this.readDotMappedByte(address) << 8 | this.readDotMappedByte(address + 1);
            case Size.LONG -> this.readDotMappedByte(address) << 24 | this.readDotMappedByte(address + 1) << 16 | this.readDotMappedByte(address + 2) << 8 | this.readDotMappedByte(address + 3) << 0;
        };
    }

    public void writeDotMapped(AsicModel.StampPriorityMode spm, int address, int data, Size size) {
        switch (size) {
            case BYTE: {
                this.writeDotMappedByte(spm, address, data);
                break;
            }
            case WORD: {
                this.writeDotMappedByte(spm, address, data >> 8);
                this.writeDotMappedByte(spm, address + 1, data);
                break;
            }
            case LONG: {
                this.writeDotMappedByte(spm, address, data >> 24);
                this.writeDotMappedByte(spm, address + 1, data >> 16);
                this.writeDotMappedByte(spm, address + 2, data >> 8);
                this.writeDotMappedByte(spm, address + 3, data >> 0);
            }
        }
    }

    private void writeCell(int a, int value) {
        int assignedBank = this.memoryContext.wramSetup.cpu == BufferUtil.CpuDeviceAccess.M68K ? 0 : 1;
        int otherBank = ~assignedBank & 1;
        this.writeWordRamBank(otherBank, McdWramCell.linearCellMap[a & 0x1FFFF], value);
    }

    private int readDotMappedByte(int address) {
        assert (MdRuntimeData.getAccessTypeExt() == BufferUtil.CpuDeviceAccess.SUB_M68K);
        byte[] wramBank = this.wordRam01[this.memoryContext.wramSetup.cpu == BufferUtil.CpuDeviceAccess.SUB_M68K ? 0 : 1];
        int addr = (address & 0x1FFFF) >> 1;
        int shift = (~address & 1) << 2;
        return wramBank[addr] >> shift & 0xF;
    }

    private void writeDotMappedByte(AsicModel.StampPriorityMode stampPriorityMode, int address, int data) {
        boolean doWrite;
        byte[] wramBank = this.wordRam01[this.memoryContext.wramSetup.cpu == BufferUtil.CpuDeviceAccess.SUB_M68K ? 0 : 1];
        int addr = (address & 0x1FFFF) >> 1;
        switch (stampPriorityMode) {
            case PM_OFF: {
                boolean bl = true;
                break;
            }
            case UNDERWRITE: {
                boolean bl;
                if (ArrayEndianUtil.getNibbleInByteBE(wramBank[addr], address & 1) == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case OVERWRITE: {
                boolean bl;
                if (ArrayEndianUtil.getNibbleInByteBE(data, address & 1) > 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                assert (false);
                boolean bl = doWrite = false;
            }
        }
        if (doWrite) {
            wramBank[addr] = (byte)ArrayEndianUtil.setNibbleInByteBE(wramBank[addr], data, address & 1);
        }
    }
}

