/*
 * Decompiled with CFR 0.152.
 */
package mcd.cdc;

import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import mcd.bus.McdSubInterruptHandler;
import mcd.cdc.Cdc;
import mcd.cdc.CdcModel;
import mcd.cdc.CdcTransferHelper;
import mcd.cdd.CdModel;
import mcd.cdd.Cdd;
import mcd.cdd.ExtendedCueSheet;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import mcd.util.McdRegBitUtil;
import omegadrive.sound.msumd.CueFileParser;
import omegadrive.system.SysUtil;
import omegadrive.util.ArrayEndianUtil;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class CdcImpl
implements Cdc {
    private static final Logger LOG = LogHelper.getLogger(CdcImpl.class.getSimpleName());
    protected static final boolean verbose = false;
    private final MegaCdMemoryContext memoryContext;
    private final McdSubInterruptHandler interruptHandler;
    private final CdcModel.CdcContext cdcContext;
    private final CueFileParser.MsfHolder msfHolder = new CueFileParser.MsfHolder();
    private CdModel.ExtendedTrackData track01;
    private ExtendedCueSheet cueSheet;
    private final ByteBuffer ram;
    private final CdcModel.CdcTransfer transfer;
    private final CdcTransferHelper transferHelper;
    private boolean hasMedia;
    static final byte[] expSync = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0};

    public CdcImpl(MegaCdMemoryContext mc, McdSubInterruptHandler ih) {
        this.memoryContext = mc;
        this.interruptHandler = ih;
        this.cdcContext = new CdcModel.CdcContext();
        this.transfer = this.cdcContext.transfer;
        this.ram = ByteBuffer.allocate(16384);
        this.transferHelper = new CdcTransferHelper(this, this.memoryContext, this.ram);
    }

    @Override
    public void write(MegaCdDict.RegSpecMcd regSpec, int address, int value, Size size) {
        ByteBuffer regBuffer = this.memoryContext.getRegBuffer(BufferUtil.CpuDeviceAccess.SUB_M68K, regSpec);
        switch (regSpec) {
            case MCD_CDC_REG_DATA: {
                MegaCdDict.writeReg(this.memoryContext, BufferUtil.CpuDeviceAccess.SUB_M68K, regSpec, address & 0x1FF, value, size);
                this.controllerWrite((byte)value);
                break;
            }
            case MCD_CDC_MODE: {
                int resWord = this.memoryContext.handleRegWrite(BufferUtil.CpuDeviceAccess.SUB_M68K, regSpec, address, value, size);
                this.cdcContext.address = resWord & 0x1F;
                this.transfer.destination = CdcModel.CdcTransferDestination.vals[resWord >> 8 & 7];
                this.transfer.completed = resWord >> 15 & 1;
                this.transfer.ready = resWord >> 14 & 1;
                break;
            }
            case MCD_CDC_DMA_ADDRESS: {
                assert (size == Size.WORD);
                MegaCdDict.writeReg(this.memoryContext, BufferUtil.CpuDeviceAccess.SUB_M68K, regSpec, address & 0x1FF, value, size);
                this.transfer.address = value << 3;
                break;
            }
            case MCD_CDC_HOST: {
                LOG.error("CDC write {} not supported: {} {}", new Object[]{regSpec, Util.th(value), size});
                assert (false);
                break;
            }
            case MCD_STOPWATCH: {
                assert (size == Size.WORD);
                this.cdcContext.stopwatch = 0;
                this.setTimerBuffer();
                break;
            }
            default: {
                LOG.error("CDC unknown register {} write: {} {}", new Object[]{regSpec, Util.th(value), size});
                assert (false);
                break;
            }
        }
    }

    @Override
    public int read(MegaCdDict.RegSpecMcd regSpec, int address, Size size) {
        int res = switch (regSpec) {
            case MegaCdDict.RegSpecMcd.MCD_CDC_MODE -> {
                int res2 = BufferUtil.readBuffer(this.memoryContext.getRegBuffer(BufferUtil.CpuDeviceAccess.SUB_M68K, regSpec), address & 0x1FF, size);
                if (this.transfer.destination.isDma()) {
                    this.transfer.completed = 0;
                    this.transfer.ready = 0;
                    this.updateCdcMode4();
                }
                yield res2;
            }
            case MegaCdDict.RegSpecMcd.MCD_CDC_REG_DATA -> {
                if (!$assertionsDisabled && (address & 1) == 0 && size != Size.WORD) {
                    throw new AssertionError();
                }
                yield this.controllerRead();
            }
            case MegaCdDict.RegSpecMcd.MCD_CDC_HOST -> {
                if (!$assertionsDisabled && size != Size.WORD) {
                    throw new AssertionError();
                }
                yield this.transferHelper.read();
            }
            case MegaCdDict.RegSpecMcd.MCD_CDC_DMA_ADDRESS -> this.transfer.address >>> 3;
            case MegaCdDict.RegSpecMcd.MCD_STOPWATCH -> this.cdcContext.stopwatch;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield size.getMask();
            }
        };
        return res;
    }

    @Override
    public void setMedia(ExtendedCueSheet extCueSheet) {
        this.cueSheet = extCueSheet;
        this.track01 = this.cueSheet.extTracks.get(0);
        this.hasMedia = true;
        assert (this.track01 != null && this.track01 != CdModel.ExtendedTrackData.NO_TRACK);
    }

    private int controllerRead() {
        int data = 0;
        if (this.cdcContext.address > CdcModel.CdcAddressRead.STAT3.ordinal()) {
            this.increaseCdcAddress();
            return 255;
        }
        CdcModel.CdcAddressRead addressRead = CdcModel.cdcAddrReadVals[this.cdcContext.address];
        switch (addressRead) {
            case COMIN: {
                data = 255;
                break;
            }
            case IFSTAT: {
                CdcModel.CdcContext c = this.cdcContext;
                data = ~c.status.active & 1 | (~c.status.active & 1) << 1 | (~c.status.busy & 1) << 2 | (~c.transfer.busy & 1) << 3 | 0x10 | (~c.irq.decoder.pending & 1) << 5 | (~c.irq.transfer.pending & 1) << 6;
                break;
            }
            case DBCL: {
                data = ArrayEndianUtil.getByteInWordBE(this.transfer.length, 1);
                break;
            }
            case DBCH: {
                data = ArrayEndianUtil.getByteInWordBE(this.transfer.length, 0);
                break;
            }
            case HEAD0: {
                if (this.cdcContext.control.head == 0) {
                    data = this.cdcContext.header.minute;
                    break;
                }
                assert (false);
                data = 0;
                break;
            }
            case HEAD1: {
                if (this.cdcContext.control.head == 0) {
                    data = this.cdcContext.header.second;
                    break;
                }
                assert (false);
                data = 0;
                break;
            }
            case HEAD2: {
                if (this.cdcContext.control.head == 0) {
                    data = this.cdcContext.header.frame;
                    break;
                }
                assert (false);
                data = 0;
                break;
            }
            case HEAD3: {
                if (this.cdcContext.control.head == 0) {
                    data = this.cdcContext.header.mode;
                    break;
                }
                assert (false);
                data = 0;
                break;
            }
            case PTL: {
                data = ArrayEndianUtil.getByteInWordBE(this.transfer.pointer, 1);
                break;
            }
            case PTH: {
                data = ArrayEndianUtil.getByteInWordBE(this.transfer.pointer, 0);
                break;
            }
            case WAL: {
                data = ArrayEndianUtil.getByteInWordBE(this.transfer.target, 1);
                break;
            }
            case WAH: {
                data = ArrayEndianUtil.getByteInWordBE(this.transfer.target, 0);
                break;
            }
            case STAT0: {
                data = this.cdcContext.decoder.enable << 7;
                break;
            }
            case STAT1: {
                data = 0;
                break;
            }
            case STAT2: {
                data = this.cdcContext.decoder.mode << 3 | this.cdcContext.decoder.form << 2;
                break;
            }
            case STAT3: {
                data = (~this.cdcContext.decoder.valid & 1) << 7;
                this.cdcContext.decoder.valid = 0;
                this.cdcContext.irq.decoder.pending = 0;
                this.poll();
                break;
            }
            default: {
                LOG.error("CDC READ unknown address: {}", (Object)Util.th(this.cdcContext.address));
            }
        }
        this.increaseCdcAddress();
        return data;
    }

    private void controllerWrite(byte data) {
        if (this.cdcContext.address > CdcModel.CdcAddressWrite.RESET.ordinal()) {
            this.increaseCdcAddress();
            return;
        }
        CdcModel.CdcAddressWrite addressWrite = CdcModel.cdcAddrWriteVals[this.cdcContext.address];
        switch (addressWrite) {
            case SBOUT: {
                LOG.info("ignored write: {}", (Object)addressWrite);
                break;
            }
            case IFCTRL: {
                this.cdcContext.status.enable = Util.getBitFromByte(data, 0);
                this.transfer.enable = Util.getBitFromByte(data, 1);
                this.cdcContext.status.wait = McdRegBitUtil.getInvertedBitFromByte(data, 2);
                this.transfer.wait = McdRegBitUtil.getInvertedBitFromByte(data, 3);
                this.cdcContext.control.commandBreak = McdRegBitUtil.getInvertedBitFromByte(data, 4);
                this.cdcContext.irq.decoder.enable = Util.getBitFromByte(data, 5);
                this.cdcContext.irq.transfer.enable = Util.getBitFromByte(data, 6);
                this.poll();
                if (this.transfer.enable != 0) break;
                this.transferHelper.stop();
                break;
            }
            case DBCL: {
                this.transfer.length = ArrayEndianUtil.setByteInWordBE(this.transfer.length, data, 1);
                break;
            }
            case DBCH: {
                this.transfer.length = ArrayEndianUtil.setByteInWordBE(this.transfer.length, data & 0xF, 0);
                break;
            }
            case DACL: {
                this.transfer.source = ArrayEndianUtil.setByteInWordBE(this.transfer.source, data, 1);
                break;
            }
            case DACH: {
                this.transfer.source = ArrayEndianUtil.setByteInWordBE(this.transfer.source, data, 0);
                break;
            }
            case DTRG: {
                this.transferHelper.start();
                break;
            }
            case DTACK: {
                this.cdcContext.irq.transfer.pending = 0;
                this.transfer.length = ArrayEndianUtil.setByteInWordBE(this.transfer.length, 0, 0);
                break;
            }
            case WAL: {
                this.transfer.target = ArrayEndianUtil.setByteInWordBE(this.transfer.target, data, 1);
                break;
            }
            case WAH: {
                this.transfer.target = ArrayEndianUtil.setByteInWordBE(this.transfer.target, data, 0);
                break;
            }
            case CTRL0: {
                this.cdcContext.control.writeRequest = Util.getBitFromByte(data, 2);
                this.cdcContext.control.autoCorrection = Util.getBitFromByte(data, 4);
                this.cdcContext.control.errorCorrection = Util.getBitFromByte(data, 5);
                this.cdcContext.decoder.enable = Util.getBitFromByte(data, 7);
                this.cdcContext.decoder.mode = this.cdcContext.control.mode;
                this.cdcContext.decoder.form = this.cdcContext.control.form & this.cdcContext.control.autoCorrection;
                break;
            }
            case CTRL1: {
                this.cdcContext.control.head = Util.getBitFromByte(data, 0);
                this.cdcContext.control.form = Util.getBitFromByte(data, 2);
                this.cdcContext.control.mode = Util.getBitFromByte(data, 3);
                this.cdcContext.control.syncInterrupt = Util.getBitFromByte(data, 7);
                this.cdcContext.decoder.mode = this.cdcContext.control.mode;
                this.cdcContext.decoder.form = this.cdcContext.control.form & this.cdcContext.control.autoCorrection;
                break;
            }
            case PTL: {
                this.transfer.pointer = ArrayEndianUtil.setByteInWordBE(this.transfer.pointer, data, 1);
                break;
            }
            case PTH: {
                this.transfer.pointer = ArrayEndianUtil.setByteInWordBE(this.transfer.pointer, data, 0);
                break;
            }
            case CTRL2: {
                break;
            }
            case RESET: {
                CdcModel.CdcContext c = this.cdcContext;
                c.status.reset();
                c.transfer.reset();
                this.transferHelper.stop();
                c.irq.reset();
                c.control.reset();
                c.decoder.reset();
                c.header.reset();
                this.poll();
                break;
            }
            default: {
                LOG.error("CDC WRITE unknown address: {}, data {}", (Object)Util.th(this.cdcContext.address), (Object)Util.th(data));
                assert (false);
                break;
            }
        }
        this.increaseCdcAddress();
    }

    private void increaseCdcAddress() {
        if (this.cdcContext.address > 0) {
            this.cdcContext.address = this.cdcContext.address + 1 & 0x1F;
            this.updateCdcMode4();
        }
    }

    @Override
    public void step(int cycles) {
        this.cdcContext.stopwatch = this.cdcContext.stopwatch + 1 & 0xFFF;
        this.setTimerBuffer();
    }

    private void updateCdcMode4() {
        int val = this.cdcContext.address | this.transfer.destination.ordinal() << 8 | this.transfer.ready << 14 | this.transfer.completed << 15;
        BufferUtil.writeBufferRaw(this.memoryContext.getRegBuffer(BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.RegSpecMcd.MCD_CDC_MODE), MegaCdDict.RegSpecMcd.MCD_CDC_MODE.addr, val, Size.WORD);
        BufferUtil.writeBufferRaw(this.memoryContext.getRegBuffer(BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.RegSpecMcd.MCD_CDC_MODE), MegaCdDict.RegSpecMcd.MCD_CDC_MODE.addr, val >> 8, Size.BYTE);
    }

    private void setTimerBuffer() {
        MegaCdDict.writeSysRegWord(this.memoryContext, BufferUtil.CpuDeviceAccess.SUB_M68K, MegaCdDict.RegSpecMcd.MCD_STOPWATCH, this.cdcContext.stopwatch);
        MegaCdDict.writeSysRegWord(this.memoryContext, BufferUtil.CpuDeviceAccess.M68K, MegaCdDict.RegSpecMcd.MCD_STOPWATCH, this.cdcContext.stopwatch);
    }

    @Override
    public void poll() {
        CdcModel.CdcIrq irq = this.cdcContext.irq;
        int pending = 0;
        pending |= irq.decoder.enable & irq.decoder.pending;
        if ((pending |= irq.transfer.enable & irq.transfer.pending) > 0) {
            this.interruptHandler.raiseInterrupt(McdSubInterruptHandler.SubCpuInterrupt.INT_CDC);
        } else {
            this.interruptHandler.lowerInterrupt(McdSubInterruptHandler.SubCpuInterrupt.INT_CDC);
        }
    }

    @Override
    public void decode(int sector) {
        assert (false);
    }

    @Override
    public void cdc_decoder_update(int sector, int track, Cdd.CddStatus cddStatus) {
        if (this.cdcContext.decoder.enable > 0) {
            CueFileParser.toMSF(sector + 150, this.msfHolder);
            this.cdcContext.header.minute = CueFileParser.toBcdByte.apply(this.msfHolder.minute);
            this.cdcContext.header.second = CueFileParser.toBcdByte.apply(this.msfHolder.second);
            this.cdcContext.header.frame = CueFileParser.toBcdByte.apply(this.msfHolder.frame);
            CdModel.ExtendedTrackData etd = ExtendedCueSheet.getExtTrack(this.cueSheet, track);
            this.cdcContext.header.mode = etd.trackDataType == CdModel.TrackDataType.AUDIO ? 0 : 1;
            this.cdcContext.decoder.valid = 1;
            this.cdcContext.irq.decoder.pending = 1;
            if (cddStatus == Cdd.CddStatus.Playing && this.cdcContext.irq.decoder.enable > 0) {
                this.poll();
            }
            if (this.cdcContext.control.writeRequest > 0) {
                this.transfer.pointer += CdModel.SECTOR_2352;
                this.transfer.target += CdModel.SECTOR_2352;
                int offset = this.transfer.pointer & 0x3FFF;
                this.ram.position(offset);
                this.ram.put((byte)this.cdcContext.header.minute);
                this.ram.put((byte)this.cdcContext.header.second);
                this.ram.put((byte)this.cdcContext.header.frame);
                this.ram.put((byte)this.cdcContext.header.mode);
                offset += 4;
                if (sector < 0) {
                    return;
                }
                if (this.cdcContext.header.mode == 1) {
                    assert (etd.trackDataType != CdModel.TrackDataType.AUDIO);
                    this.cdd_read_data(sector, offset, this.track01);
                } else assert (etd.trackDataType == CdModel.TrackDataType.AUDIO);
            }
        }
    }

    private void cdd_read_data(int sector, int offset, CdModel.ExtendedTrackData track) {
        if (track.trackDataType != CdModel.TrackDataType.AUDIO && sector >= 0) {
            if (this.cueSheet.romFileType == SysUtil.RomFileType.ISO) {
                assert (track.trackDataType == CdModel.TrackDataType.MODE1_2048);
                int seekPos = sector * CdModel.SectorSize.S_2048.s_size;
                this.doFileRead(track.file, seekPos, CdModel.SectorSize.S_2048.s_size, offset);
            } else if (this.cueSheet.romFileType == SysUtil.RomFileType.BIN_CUE) {
                assert (track.trackDataType.size == CdModel.SectorSize.S_2352);
                int seekPos = sector * track.trackDataType.size.s_size + 12 + 4;
                assert (this.checkMode1Data(track, this.msfHolder, seekPos));
                this.doFileRead(track.file, seekPos, CdModel.SectorSize.S_2048.s_size, offset);
            }
        }
    }

    private void doFileRead(RandomAccessFile file, int seekPos, int readChunkSize, int ramOffset) {
        block6: {
            assert (ramOffset < 16384);
            try {
                file.seek(seekPos);
                int len = Math.min(16384 - ramOffset, readChunkSize);
                int readN = file.read(this.ram.array(), ramOffset, len);
                assert (readN == len);
                if (len < readChunkSize) {
                    readN += file.read(this.ram.array(), 0, readChunkSize - len);
                }
                assert (readN == readChunkSize);
            }
            catch (Exception e) {
                LOG.error("decode error: {}", (Object)e.getMessage());
                e.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    private boolean checkMode1Data(CdModel.ExtendedTrackData track, CueFileParser.MsfHolder holder, int dataSeekPos) {
        boolean ok;
        block6: {
            byte[] header = new byte[4];
            byte[] syncHeader = new byte[12];
            ok = false;
            try {
                track.file.seek(dataSeekPos - 16);
                int readN = track.file.read(syncHeader, 0, syncHeader.length);
                try {
                    assert (readN == syncHeader.length) : String.valueOf(track) + ",seekPos:" + Util.th(dataSeekPos);
                }
                catch (Error e) {
                    e.printStackTrace();
                }
                readN = track.file.read(header, 0, header.length);
                assert (readN == header.length);
                ok = Integer.parseInt("" + holder.minute, 16) == header[0] && Integer.parseInt("" + holder.second, 16) == header[1] && Integer.parseInt("" + holder.frame, 16) == header[2];
                ok &= header[0] == this.cdcContext.header.minute && header[1] == this.cdcContext.header.second && header[2] == this.cdcContext.header.frame;
                ok &= header[3] == this.cdcContext.header.mode;
                ok &= Arrays.equals(expSync, syncHeader);
            }
            catch (Exception e) {
                LOG.error("decode error: {}", (Object)e.getMessage());
                e.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return ok;
    }

    @Override
    public CdcModel.CdcContext getContext() {
        return this.cdcContext;
    }

    @Override
    public void recalcRegValue(MegaCdDict.RegSpecMcd regSpec) {
        assert (regSpec == MegaCdDict.RegSpecMcd.MCD_CDC_MODE);
        this.updateCdcMode4();
    }

    @Override
    public void dma() {
        this.transferHelper.dma();
    }

    @Override
    public void step75hz() {
        assert (false);
    }
}

