/*
 * Decompiled with CFR 0.152.
 */
package mcd.cdc;

import com.google.common.base.MoreObjects;
import mcd.cdc.Cdc;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public interface CdcModel {
    public static final Logger LOG = LogHelper.getLogger(Cdc.class.getSimpleName());
    public static final int NUM_CDC_REG = 32;
    public static final int NUM_CDC_REG_MASK = 31;
    public static final int NUM_CDC_MCD_REG = 16;
    public static final int NUM_CDC_MCD_REG_MASK = 15;
    public static final CdcAddressRead[] cdcAddrReadVals = CdcAddressRead.values();
    public static final CdcAddressWrite[] cdcAddrWriteVals = CdcAddressWrite.values();

    public static enum CdcAddressRead {
        COMIN,
        IFSTAT,
        DBCL,
        DBCH,
        HEAD0,
        HEAD1,
        HEAD2,
        HEAD3,
        PTL,
        PTH,
        WAL,
        WAH,
        STAT0,
        STAT1,
        STAT2,
        STAT3;

    }

    public static enum CdcAddressWrite {
        SBOUT,
        IFCTRL,
        DBCL,
        DBCH,
        DACL,
        DACH,
        DTRG,
        DTACK,
        WAL,
        WAH,
        CTRL0,
        CTRL1,
        PTL,
        PTH,
        CTRL2,
        RESET;

    }

    public static class CdcContext {
        public int address;
        public int stopwatch;
        public byte[] ram;
        public CdcStatus status = new CdcStatus();
        public CdcDecoder decoder = new CdcDecoder();
        public CdcTransfer transfer = new CdcTransfer();
        public CdcIrq irq = new CdcIrq();
        public CdcControl control = new CdcControl();
        public CdcHeader header = new CdcHeader();

        public String toString() {
            return String.valueOf(this.status) + "\n" + String.valueOf(this.transfer) + "\n" + String.valueOf(this.decoder) + "\n" + String.valueOf(this.irq) + "\n" + String.valueOf(this.control) + "\n" + String.valueOf(this.header);
        }
    }

    public static class CdcControl {
        public int head;
        public int mode;
        public int form;
        public int commandBreak;
        public int modeByteCheck;
        public int erasureRequest;
        public int writeRequest;
        public int pCodeCorrection;
        public int qCodeCorrection;
        public int autoCorrection;
        public int errorCorrection;
        public int edcCorrection;
        public int correctionWrite;
        public int descramble;
        public int syncDetection;
        public int syncInterrupt;
        public int erasureCorrection;
        public int statusTrigger;
        public int statusControl;

        public void reset() {
            this.commandBreak = 1;
            this.edcCorrection = 0;
            this.errorCorrection = 0;
            this.autoCorrection = 0;
            this.erasureRequest = 0;
            this.writeRequest = 0;
            this.qCodeCorrection = 0;
            this.pCodeCorrection = 0;
            this.syncInterrupt = 0;
            this.syncDetection = 0;
            this.descramble = 0;
            this.correctionWrite = 0;
            this.mode = 0;
            this.form = 0;
            this.modeByteCheck = 0;
            this.head = 0;
            this.erasureCorrection = 0;
            this.statusControl = 0;
            this.statusTrigger = 0;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("head_SHDREN", this.head).add("mode", this.mode).add("form", this.form).add("writeRequest_WRRQ", this.writeRequest).toString();
        }
    }

    public static class CdcHeader {
        public int minute;
        public int second;
        public int frame;
        public int mode;

        public void reset() {
            this.mode = 0;
            this.frame = 0;
            this.second = 0;
            this.minute = 0;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("minute", this.minute).add("second", this.second).add("frame", this.frame).add("mode", this.mode).toString();
        }
    }

    public static class CdcIrq
    extends McdIrq {
        public McdIrq decoder = new McdIrq();
        public McdIrq transfer = new McdIrq();

        public void reset() {
            this.transfer.pending = 0;
            this.decoder.pending = 0;
            this.transfer.enable = 0;
            this.decoder.enable = 0;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("decoder_DECEIN+DECI", (Object)this.decoder).add("transfer_DTEIEN+DTEI", (Object)this.transfer).toString();
        }
    }

    public static class McdIrq {
        public int enable;
        public int pending;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("enable", this.enable).add("pending", this.pending).toString();
        }
    }

    public static class CdcTransfer {
        public CdcTransferDestination destination;
        public int address;
        public int source;
        public int target;
        public int pointer;
        public int length;
        public int enable;
        public int active;
        public int busy;
        public int wait;
        public int ready;
        public int completed;

        public void reset() {
            this.busy = 0;
            this.active = 0;
            this.enable = 0;
            this.wait = 1;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("destination", (Object)this.destination).add("address", this.address).add("source", this.source).add("target", this.target).add("pointer", this.pointer).add("length", this.length).add("enable_DOUTEN", this.enable).add("active_DTEN", this.active).add("busy_DTBSY", this.busy).add("wait_DTWAI", this.wait).add("ready_DSR", this.ready).add("completed_EDT", this.completed).toString();
        }
    }

    public static enum CdcTransferDestination {
        NONE_0,
        NONE_1,
        MAIN_READ_2,
        SUB_READ_3,
        DMA_PCM_4,
        DMA_PROGRAM_5,
        NONE_6,
        DMA_SUB_WRAM_7;

        public static CdcTransferDestination[] vals;
        private boolean dmaDestination = this.name().startsWith("DMA");
        private boolean valid = !this.name().startsWith("NONE");

        public boolean isDma() {
            return this.dmaDestination;
        }

        public boolean isValid() {
            return this.valid;
        }

        static {
            vals = CdcTransferDestination.values();
        }
    }

    public static interface CdcTransferAction {
        public void start();

        public void stop();

        public void dma();

        public int read();

        public void complete();
    }

    public static class CdcDecoder {
        public int enable;
        public int mode;
        public int form;
        public int valid;

        public void reset() {
            this.mode = 0;
            this.form = 0;
            this.enable = 0;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("enable_DECEN", this.enable).add("mode", this.mode).add("form", this.form).add("valid_!VALST", this.valid).toString();
        }
    }

    public static class CdcStatus {
        public byte[] fifo = new byte[8];
        public int read;
        public int write;
        public int empty = 1;
        public int enable;
        public int active;
        public int busy;
        public int wait;

        public void reset() {
            this.enable = 0;
            this.busy = 0;
            this.active = 0;
            this.wait = 1;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("enable_SOUTEN", this.enable).add("active_STEN", this.active).add("busy_STBSY", this.busy).add("wait_STWAI", this.wait).toString();
        }
    }

    public static class CdcCommand {
        public byte[] fifo = new byte[8];
        public int read;
        public int write;
        public int empty = 1;
    }
}

