/*
 * Decompiled with CFR 0.152.
 */
package mcd.cdc;

import java.nio.ByteBuffer;
import mcd.cdc.Cdc;
import mcd.cdc.CdcModel;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import mcd.pcm.McdPcm;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;

public class CdcTransferHelper
implements CdcModel.CdcTransferAction {
    private static final Logger LOG = LogHelper.getLogger(CdcTransferHelper.class.getSimpleName());
    public static final int PCM_ADDRESS_MASK = 8191;
    private Cdc cdc;
    private CdcModel.CdcTransfer t;
    private MegaCdMemoryContext memoryContext;
    private ByteBuffer ram;

    public CdcTransferHelper(Cdc cdc, MegaCdMemoryContext memoryContext, ByteBuffer ram) {
        this.cdc = cdc;
        assert (cdc.getContext() != null);
        this.t = cdc.getContext().transfer;
        this.memoryContext = memoryContext;
        this.ram = ram;
    }

    @Override
    public void start() {
        CdcModel.CdcTransfer t = this.cdc.getContext().transfer;
        if (t.enable == 0) {
            return;
        }
        t.active = 1;
        t.busy = 1;
        assert (t.destination.isValid()) : t.destination;
        t.ready = t.destination.isDma() ? 0 : 1;
        t.completed = 0;
        CdcModel.CdcContext ctx = this.cdc.getContext();
        ctx.irq.transfer.pending = 0;
        this.cdc.recalcRegValue(MegaCdDict.RegSpecMcd.MCD_CDC_MODE);
        t.source &= 0x3FFF;
    }

    @Override
    public void stop() {
        if (this.t.active > 0) {
            // empty if block
        }
        this.t.active = 0;
        this.t.busy = 0;
        this.t.ready = 0;
        this.cdc.recalcRegValue(MegaCdDict.RegSpecMcd.MCD_CDC_MODE);
    }

    @Override
    public int read() {
        if (this.t.destination.isDma() && this.t.ready == 0) {
            return 65535;
        }
        short data = this.ram.getShort(this.t.source);
        this.t.source = this.t.source + 2 & 0x3FFF;
        this.t.length -= 2;
        if (this.t.length <= 0) {
            this.t.length = 0;
            this.complete();
        } else if (this.t.length <= 2) {
            assert (this.t.ready == 1);
            this.t.completed = 1;
            this.cdc.recalcRegValue(MegaCdDict.RegSpecMcd.MCD_CDC_MODE);
        }
        return data;
    }

    @Override
    public void dma() {
        if (this.t.active == 0 || !this.t.destination.isDma()) {
            return;
        }
        assert (this.t.destination.isValid());
        int data = this.ram.getShort(this.t.source) & 0xFFFF;
        switch (this.t.destination) {
            case DMA_SUB_WRAM_7: {
                int baseAddr = this.memoryContext.wramSetup.mode == MegaCdMemoryContext.WordRamMode._1M ? 786432 : 524288;
                this.memoryContext.wramHelper.writeWordRamWord(BufferUtil.CpuDeviceAccess.SUB_M68K, baseAddr | this.t.address, data);
                break;
            }
            case DMA_PROGRAM_5: {
                assert ((this.t.address & 1) == 0);
                this.memoryContext.writeProgRam(this.t.address & 0x7FFFF, data, Size.WORD);
                break;
            }
            case DMA_PCM_4: {
                assert (this.t.length > 0);
                this.writePcm(this.t.address, data >> 8);
                if (this.t.length - 1 < 0) break;
                this.writePcm(this.t.address + 2, data & 0xFF);
                this.t.address += 2;
                break;
            }
            default: {
                LOG.warn("TODO CDC DMA mode: {}", (Object)this.t.destination);
                assert (false);
                break;
            }
        }
        this.t.source = this.t.source + 2 & 0x3FFF;
        this.t.address += 2;
        this.t.length -= 2;
        if (this.t.length <= 0) {
            this.t.length = 0;
            this.complete();
        }
        this.cdc.recalcRegValue(MegaCdDict.RegSpecMcd.MCD_CDC_MODE);
    }

    private void writePcm(int address, int data) {
        McdPcm.pcm.pcmDataWriteByte((address &= 0x1FFF) & 0x1FFF, data);
    }

    @Override
    public void complete() {
        this.t.ready = 0;
        this.t.busy = 0;
        this.t.active = 0;
        this.t.completed = 1;
        this.cdc.getContext().irq.transfer.pending = 1;
        this.cdc.recalcRegValue(MegaCdDict.RegSpecMcd.MCD_CDC_MODE);
        this.cdc.poll();
    }
}

