/*
 * Decompiled with CFR 0.152.
 */
package mcd.cdd;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import mcd.bus.McdSubInterruptHandler;
import mcd.cdc.Cdc;
import mcd.cdd.CddImpl;
import mcd.cdd.ExtendedCueSheet;
import mcd.dict.MegaCdDict;
import mcd.dict.MegaCdMemoryContext;
import omegadrive.util.BufferUtil;
import omegadrive.util.Size;
import omegadrive.util.VideoMode;

public interface Cdd
extends BufferUtil.StepDevice {
    public static final int LEADINNUM = 0;
    public static final int LEADOUTNUM = 170;
    public static final int CDD_REG_NUM = 10;
    public static final int CDD_CHECKSUM_BYTE = 9;
    public static final int PREGAP_LEN_LBA = 150;
    public static final int LBA_READAHEAD_LEN = 3;
    public static final int FLAGS_DATA = 4;
    public static final int FLAGS_AUDIO = 0;
    public static final int FLAGS_aEMPHASIS = 2;
    public static final int FLAGS_iEMPHASIS = 0;
    public static final int FLAGS_aMUTE = 1;
    public static final int FLAGS_iMUTE = 0;
    public static final CddStatus[] statusVals = CddStatus.values();
    public static final CddCommand[] commandVals = CddCommand.values();
    public static final CddRequest[] requestVals = CddRequest.values();

    public void tryInsert(ExtendedCueSheet var1);

    public void write(MegaCdDict.RegSpecMcd var1, int var2, int var3, Size var4);

    public int read(MegaCdDict.RegSpecMcd var1, int var2, Size var3);

    public void stepCdda();

    public CddContext getCddContext();

    public void updateVideoMode(VideoMode var1);

    public void newFrame();

    public void logStatus();

    public static Cdd createInstance(MegaCdMemoryContext memoryContext, McdSubInterruptHandler ih, Cdc cdc) {
        return new CddImpl(memoryContext, ih, cdc);
    }

    public static int getCddChecksum(int[] vals) {
        int checksum = 0;
        for (int i = 0; i < vals.length - 1; ++i) {
            checksum += vals[i];
        }
        return ~checksum & 0xF;
    }

    public static enum CddStatus {
        Stopped,
        Playing,
        Seeking,
        Scanning,
        Paused,
        DoorOpened,
        ChecksumError,
        CommandError,
        FunctionError,
        ReadingTOC,
        Tracking,
        NoDisc,
        LeadOut,
        LeadIn,
        TrayMoving,
        Test;

    }

    public static enum CddCommand {
        DriveStatus,
        Stop,
        Request,
        SeekPlay,
        SeekPause,
        None_5,
        Pause,
        Play,
        Forward,
        Reverse,
        TrackSkip,
        TrackCue,
        DoorClose,
        DoorOpen;

    }

    public static enum CddRequest {
        AbsoluteTime,
        RelativeTime,
        TrackInformation,
        DiscCompletionTime,
        DiscTracks,
        TrackStartTime,
        ErrorInformation,
        NONE_7,
        NONE_8,
        NONE_9,
        NONE_A,
        NONE_B,
        NONE_C,
        NONE_D,
        SubcodeError,
        NotReady;

    }

    public static class CddContext {
        public CddIo io;
        public int hostClockEnable;
        public int[] statusRegs = new int[10];
        public int[] commandRegs = new int[10];

        public static CddContext create(CddIo cddIo) {
            CddContext c = new CddContext();
            c.io = cddIo;
            return c;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("io", (Object)this.io).add("hostClockEnable_HOCK", this.hostClockEnable).add("statusRegs", (Object)Arrays.toString(this.statusRegs)).add("commandRegs", (Object)Arrays.toString(this.commandRegs)).toString();
        }
    }

    public static class CddIo {
        public CddStatus status;
        public int seeking;
        public int latency;
        public int sector;
        public int sample;
        public int track;
        public int tocRead;

        public static CddIo create() {
            CddIo c = new CddIo();
            c.status = CddStatus.NoDisc;
            return c;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("seeking", this.seeking).add("latency", this.latency).add("sector", this.sector).add("sample", this.sample).add("track", this.track).add("tocRead", this.tocRead).toString();
        }
    }

    public static enum CddControl_DM_bit {
        MUSIC_0,
        DATA_1;

    }
}

