/*
 * Decompiled with CFR 0.152.
 */
package mcd.util;

import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.Map;
import omegadrive.SystemLoader;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import org.slf4j.Logger;
import s32x.util.BiosHolder;

public class McdBiosHolder {
    private static final Logger LOG = LogHelper.getLogger(McdBiosHolder.class.getSimpleName());
    public static String biosBasePath = System.getProperty("bios.folder", SystemLoader.biosFolder) + "/mcd";
    public static String masterBiosNameUs = "bios_CD_U.bin";
    public static String masterBiosNameEu = "bios_CD_E.bin";
    public static String masterBiosNameJp = "bios_CD_J.bin";
    private Map<RegionDetector.Region, BiosHolder.BiosData> biosData = new EnumMap<RegionDetector.Region, BiosHolder.BiosData>(RegionDetector.Region.class);
    private static McdBiosHolder INSTANCE;

    public static McdBiosHolder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new McdBiosHolder();
        }
        return INSTANCE;
    }

    private McdBiosHolder() {
        this.init();
    }

    private void init() {
        boolean pathOk;
        LOG.info("MCD bios base path: {}", (Object)biosBasePath);
        Path u = Paths.get(biosBasePath, masterBiosNameUs);
        Path e = Paths.get(biosBasePath, masterBiosNameEu);
        Path j = Paths.get(biosBasePath, masterBiosNameJp);
        boolean bl = pathOk = Files.exists(u, new LinkOption[0]) && Files.exists(e, new LinkOption[0]) && Files.exists(j, new LinkOption[0]);
        if (!pathOk) {
            LOG.error("One or more bios not found: \n{}\n{}\n{}", new Object[]{u, e, j});
            return;
        }
        Map<RegionDetector.Region, Path> m = Map.of(RegionDetector.Region.USA, u, RegionDetector.Region.JAPAN, j, RegionDetector.Region.EUROPE, e);
        LOG.info("MCD bios files: {}", m);
        this.biosData.put(RegionDetector.Region.USA, new BiosHolder.BiosData(FileUtil.readFileSafe(u)));
        this.biosData.put(RegionDetector.Region.EUROPE, new BiosHolder.BiosData(FileUtil.readFileSafe(e)));
        this.biosData.put(RegionDetector.Region.JAPAN, new BiosHolder.BiosData(FileUtil.readFileSafe(j)));
        boolean dataOk = this.biosData.entrySet().stream().allMatch(entry -> ((BiosHolder.BiosData)entry.getValue()).buffer.capacity() > 0);
        if (!dataOk) {
            LOG.error("Unable to load one or more bios: {}", this.biosData);
            return;
        }
        LOG.info("MCD bios set loaded: {}", this.biosData);
    }

    public ByteBuffer getBiosBuffer(RegionDetector.Region region) {
        BiosHolder.BiosData bd = this.biosData.get((Object)region);
        LOG.info("{} using bios: {}", (Object)region, (Object)bd);
        return bd.buffer;
    }

    public byte[] getBios(RegionDetector.Region region) {
        return this.biosData.get((Object)((Object)region)).buffer.array();
    }

    public static ByteBuffer loadBios(RegionDetector.Region region, Path p) {
        ByteBuffer bios;
        try {
            assert (Files.exists(p, new LinkOption[0]));
            byte[] b = FileUtil.readBinaryFile(p, ".bin", ".md");
            assert (b.length > 0);
            bios = ByteBuffer.wrap(b);
            LOG.info("Loading bios at {}, region: {}, size: {}", new Object[]{p.toAbsolutePath(), region, b.length});
        }
        catch (Error | Exception e) {
            LOG.error("Unable to load bios at {}", (Object)p.toAbsolutePath());
            bios = ByteBuffer.allocate(131072);
        }
        return bios;
    }
}

