/*
 * Decompiled with CFR 0.152.
 */
package mcd.util;

import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Map;
import java.util.TreeMap;
import mcd.dict.MegaCdMemoryContext;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.vdp.util.MemView;
import org.slf4j.Logger;

public class McdWramCell {
    private static final Logger LOG = LogHelper.getLogger(McdWramCell.class.getSimpleName());
    public static final int[] linearCellMap = new int[131072];
    public static int[] slotBaseAddr = new int[]{0, 65536, 98304, 114688, 122880};

    private static void writeToFile(Map<Integer, Integer> m) {
        TreeMap<Integer, Integer> sm = new TreeMap<Integer, Integer>(m);
        int size = sm.size() * 8;
        ByteBuffer bb = ByteBuffer.allocate(size);
        for (Map.Entry entry : sm.entrySet()) {
            bb.putInt((Integer)entry.getKey());
            bb.putInt((Integer)entry.getValue());
        }
        FileUtil.writeFileSafe(Paths.get("./test.bin", new String[0]), bb.array());
    }

    public static void printMemoryBank(MegaCdMemoryContext ctx, int bank2) {
        StringBuilder sb = new StringBuilder();
        MemView.fillFormattedString(sb, ctx.wordRam01[bank2], 0, ctx.wordRam01[bank2].length);
        System.out.println("\n\n" + String.valueOf(sb));
    }

    public static void main(String[] args) {
        System.out.println("test");
    }

    static {
        int[] limit = new int[]{32768, 49152, 57344, 61440, 65536};
        for (int j = 0; j < 5; ++j) {
            int baseAddr = slotBaseAddr[j];
            int start = baseAddr >> 1;
            int size = 65536 >> j;
            size = Math.max(size, 8192);
            int acc = start;
            int lineStart = start;
            for (int i = 0; i < size - 3; i += 4) {
                if (acc >= limit[j]) {
                    acc = lineStart += 2;
                }
                int val1 = acc;
                int val2 = acc + 1;
                int src1 = slotBaseAddr[j] | val1 << 1;
                int dest1 = slotBaseAddr[j] | baseAddr + i;
                int src2 = slotBaseAddr[j] | val2 << 1;
                int dest2 = slotBaseAddr[j] | baseAddr + i + 2;
                assert (linearCellMap[src1] == 0 && linearCellMap[src2] == 0);
                McdWramCell.linearCellMap[src1] = dest1;
                McdWramCell.linearCellMap[src2] = dest2;
                acc += 128;
            }
        }
    }
}

