/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.md;

import java.util.Objects;
import omegadrive.Device;
import omegadrive.bus.md.BusArbiterImpl;
import omegadrive.cpu.m68k.M68kProvider;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.util.BufferUtil;
import omegadrive.vdp.model.BaseVdpAdapterEventSupport;
import omegadrive.vdp.model.MdVdpProvider;

public interface BusArbiter
extends Device,
BaseVdpAdapterEventSupport.VdpEventListener {
    public static final BusArbiter NO_OP;
    public static final int VDP_IPL1 = 2;
    public static final int VDP_IPL2 = 4;

    public static BusArbiter createInstance(MdVdpProvider vdp, M68kProvider m68k, Z80Provider z80) {
        Objects.requireNonNull(vdp);
        Objects.requireNonNull(m68k);
        Objects.requireNonNull(z80);
        BusArbiterImpl b = new BusArbiterImpl();
        b.vdp = vdp;
        b.m68k = m68k;
        b.z80 = z80;
        if (!2.$assertionsDisabled && z80.getZ80BusProvider() == null) {
            throw new AssertionError();
        }
        z80.getZ80BusProvider().attachDevice(b);
        vdp.addVdpEventListener(b);
        return b;
    }

    public MdVdpProvider.VdpBusyState getVdpBusyState();

    public void setVdpBusyState(MdVdpProvider.VdpBusyState var1);

    public void handleInterrupts(BufferUtil.CpuDeviceAccess var1);

    public boolean is68kRunning();

    public void addCyclePenalty(CpuType var1, int var2);

    public void ackInterrupt68k(int var1);

    public void runLater68k(Runnable var1);

    public static BusArbiter createNoOp() {
        return new BusArbiterImpl(){

            @Override
            public void ackInterrupt68k(int level) {
            }

            @Override
            public void addCyclePenalty(CpuType cpuType, int value) {
            }
        };
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        NO_OP = BusArbiter.createNoOp();
    }

    public static enum InterruptEvent {
        Z80_INT_ON,
        Z80_INT_OFF;

    }

    public static enum CpuState {
        RUNNING,
        HALTED;

    }

    public static enum CpuType {
        M68K,
        Z80;

    }

    public static enum IntState {
        NONE,
        PENDING,
        ASSERTED;

    }
}

