/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.model;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import omegadrive.Device;
import omegadrive.memory.ReadableByteMemory;
import omegadrive.util.Size;

public interface BaseBusProvider
extends Device,
ReadableByteMemory {
    @Override
    public int read(int var1, Size var2);

    public void write(int var1, int var2, Size var3);

    default public void closeRom() {
    }

    public BaseBusProvider attachDevice(Device var1);

    public <T extends Device> Optional<T> getBusDeviceIfAny(Class<T> var1);

    public <T extends Device> Set<T> getAllDevices(Class<T> var1);

    default public void attachDevices(Device ... device) {
        Arrays.stream(device).forEach(this::attachDevice);
    }
}

