/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.model;

import omegadrive.bus.model.MdM68kBusProvider;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.cart.MdCartInfoProvider;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.sound.fm.FmProvider;
import omegadrive.sound.psg.PsgProvider;
import omegadrive.system.SystemProvider;
import omegadrive.util.LogHelper;
import omegadrive.vdp.model.MdVdpProvider;
import org.slf4j.Logger;

public interface MdMainBusProvider
extends MdM68kBusProvider,
Z80BusProvider {
    public static final int[] EMPTY = new int[0];
    public static final int Z80_ADDRESS_SPACE_START = 0xA00000;
    public static final int Z80_ADDRESS_SPACE_END = 0xA0FFFF;
    public static final int IO_ADDRESS_SPACE_START = 0xA10000;
    public static final int IO_ADDRESS_SPACE_END = 10555391;
    public static final int INTERNAL_REG_ADDRESS_SPACE_START = 0xA11000;
    public static final int INTERNAL_REG_ADDRESS_SPACE_END = 0xBFFFFF;
    public static final int MEMORY_MODE_START = 0xA11000;
    public static final int MEMORY_MODE_END = 10555647;
    public static final int Z80_BUS_REQ_CONTROL_START = 0xA11100;
    public static final int Z80_BUS_REQ_CONTROL_END = 0xA111FF;
    public static final int Z80_RESET_CONTROL_START = 10555904;
    public static final int Z80_RESET_CONTROL_END = 10556159;
    public static final int MEGA_CD_EXP_START = 10559488;
    public static final int MEGA_CD_EXP_END = 10559743;
    public static final int TIME_LINE_START = 10563584;
    public static final int SRAM_LOCK = 10563825;
    public static final int TIME_LINE_END = 10563839;
    public static final int TMSS_AREA1_START = 10567680;
    public static final int TMSS_AREA1_END = 10567683;
    public static final int TMSS_AREA2_START = 10567936;
    public static final int TMSS_AREA2_END = 10567937;
    public static final int SVP_REG_AREA_START = 10571776;
    public static final int SVP_REG_AREA_END = 10571784;
    public static final int VDP_ADDRESS_SPACE_START = 0xC00000;
    public static final int VDP_ADDRESS_SPACE_END = 0xDFFFFF;
    public static final int ADDRESS_UPPER_LIMIT = 0xFFFFFF;
    public static final int ADDRESS_RAM_MAP_START = 0xE00000;
    public static final int M68K_TO_Z80_MEMORY_MASK = Short.MAX_VALUE;
    public static final int VDP_VALID_ADDRESS_MASK = 0xE700E0;
    public static final int DEFAULT_ROM_END_ADDRESS = 0x3FFFFF;
    public static final int M68K_RAM_MASK = 65535;
    public static final int NUM_MAPPER_BANKS = 8;
    public static final Logger LOG = LogHelper.getLogger(MdMainBusProvider.class.getSimpleName());

    public void handleVdpInterruptsZ80();

    @Override
    public void resetFrom68k();

    public void setVdpBusyState(MdVdpProvider.VdpBusyState var1);

    public boolean isZ80Running();

    public boolean isZ80ResetState();

    public boolean isZ80BusRequested();

    public void setZ80ResetState(boolean var1);

    public void setZ80BusRequested(boolean var1);

    public PsgProvider getPsg();

    public FmProvider getFm();

    @Override
    public SystemProvider getSystem();

    public MdVdpProvider getVdp();

    default public int[] getMapperData() {
        return EMPTY;
    }

    default public void setMapperData(int[] data) {
    }

    @Override
    default public int readIoPort(int port) {
        return 255;
    }

    @Override
    default public void writeIoPort(int port, int value) {
        LOG.warn("outPort: {}, data: {}", (Object)port, (Object)value);
    }

    @Override
    default public void handleInterrupts(Z80Provider.Interrupt type) {
        LOG.warn("Ignoring interrupt: {}", (Object)type);
    }

    default public boolean isSvp() {
        return false;
    }

    public MdCartInfoProvider getCartridgeInfoProvider();
}

