/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.z80;

import java.nio.file.Path;
import java.nio.file.Paths;
import omegadrive.SystemLoader;
import omegadrive.bus.DeviceAwareBus;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.joypad.ColecoPad;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.vdp.Tms9918aVdp;
import org.slf4j.Logger;

public class ColecoBus
extends DeviceAwareBus<Tms9918aVdp, ColecoPad>
implements Z80BusProvider {
    private static final Logger LOG = LogHelper.getLogger(ColecoBus.class);
    static final boolean verbose = false;
    private static final int BIOS_START = 0;
    private static final int BIOS_END = 8191;
    private static final int RAM_START = 24576;
    private static final int RAM_END = Short.MAX_VALUE;
    private static final int ROM_START = 32768;
    private static final int ROM_END = 65535;
    private static final int RAM_SIZE = 1024;
    private static final int ROM_SIZE = 65536;
    private final byte[] bios;
    private boolean isNmiSet = false;

    public ColecoBus() {
        Path p = Paths.get(SystemLoader.biosFolder, SystemLoader.biosNameColeco);
        this.bios = FileUtil.loadBiosFile(p);
        LOG.info("Loading Coleco bios from: {}", (Object)p.toAbsolutePath());
    }

    @Override
    public int read(int addressL, Size size) {
        int address = addressL;
        if (size != Size.BYTE) {
            LOG.error("Unexpected read, addr : {} , size: {}", (Object)address, (Object)size);
            return 255;
        }
        if (address <= 8191) {
            return this.bios[address];
        }
        if (address >= 24576 && address <= Short.MAX_VALUE) {
            return this.memoryProvider.readRamByte(address &= 0x3FF);
        }
        if (address >= 32768 && address <= 65535) {
            return this.memoryProvider.readRomByte(address -= 32768);
        }
        LOG.error("Unexpected Z80 memory read: {}", (Object)Util.th(address));
        return 255;
    }

    @Override
    public void write(int address, int data, Size size) {
        assert (size == Size.BYTE);
        this.memoryProvider.writeRamByte(address &= 0x3FF, (byte)data);
    }

    @Override
    public void writeIoPort(int port, int value) {
        byte byteVal = (byte)(value & 0xFF);
        switch ((port &= 0xFF) & 0xE1) {
            case 128: 
            case 192: {
                ((ColecoPad)this.joypadProvider).writeDataRegister1(port);
                break;
            }
            case 160: {
                ((Tms9918aVdp)this.vdpProvider).writeVRAMData(byteVal);
                break;
            }
            case 161: {
                ((Tms9918aVdp)this.vdpProvider).writeRegister(byteVal);
                break;
            }
            case 225: {
                this.soundProvider.getPsg().write(byteVal);
                break;
            }
            default: {
                LOG.warn("outPort: {} ,data {}", (Object)Util.th(port), (Object)Util.th(value));
            }
        }
    }

    @Override
    public int readIoPort(int port) {
        switch ((port &= 0xFF) & 0xE1) {
            case 160: {
                return ((Tms9918aVdp)this.vdpProvider).readVRAMData();
            }
            case 161: {
                return ((Tms9918aVdp)this.vdpProvider).readStatus();
            }
            case 224: {
                return ((ColecoPad)this.joypadProvider).readDataRegister1();
            }
            case 225: {
                return ((ColecoPad)this.joypadProvider).readDataRegister2();
            }
        }
        LOG.warn("inPort: {}", (Object)Util.th(port & 0xFF));
        return 255;
    }

    @Override
    public void reset() {
        this.isNmiSet = false;
    }

    @Override
    public void onNewFrame() {
        ((ColecoPad)this.joypadProvider).newFrame();
    }

    @Override
    public void handleInterrupts(Z80Provider.Interrupt type) {
        boolean set;
        boolean bl = set = ((Tms9918aVdp)this.vdpProvider).getStatusINT() && ((Tms9918aVdp)this.vdpProvider).getGINT();
        if (set && !this.isNmiSet) {
            this.z80Provider.triggerNMI();
        }
        this.isNmiSet = set;
    }
}

