/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.z80;

import omegadrive.bus.DeviceAwareBus;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.joypad.TwoButtonsJoypad;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.vdp.Tms9918aVdp;
import org.slf4j.Logger;

public class Sg1000Bus
extends DeviceAwareBus<Tms9918aVdp, TwoButtonsJoypad>
implements Z80BusProvider {
    private static final Logger LOG = LogHelper.getLogger(Sg1000Bus.class);
    private static final int ROM_START = 0;
    private static final int ROM_END = 49151;
    private static final int RAM_START = 49152;
    private static final int RAM_END = 65535;
    private static final int RAM_SIZE = 1024;
    private static final int ROM_SIZE = 49152;
    boolean prev = false;

    @Override
    public int read(int addressL, Size size) {
        int address = addressL;
        if (size != Size.BYTE) {
            LOG.error("Unexpected read, addr : {} , size: {}", (Object)address, (Object)size);
            return 255;
        }
        if (address <= 49151) {
            return this.memoryProvider.readRomByte(address);
        }
        if (address >= 49152 && address <= 65535) {
            return this.memoryProvider.readRamByte(address &= 0x3FF);
        }
        LOG.error("Unexpected Z80 memory read: {}", (Object)Util.th(address));
        return 255;
    }

    @Override
    public void write(int address, int data, Size size) {
        assert (size == Size.BYTE);
        this.memoryProvider.writeRamByte(address &= 0x3FF, (byte)data);
    }

    @Override
    public void writeIoPort(int port, int value) {
        byte byteVal = (byte)(value & 0xFF);
        switch ((port &= 0xFF) & 0xC1) {
            case 64: 
            case 65: {
                this.soundProvider.getPsg().write(byteVal);
                break;
            }
            case 128: {
                ((Tms9918aVdp)this.vdpProvider).writeVRAMData(byteVal);
                break;
            }
            case 129: {
                ((Tms9918aVdp)this.vdpProvider).writeRegister(byteVal);
                break;
            }
            case 192: {
                break;
            }
            case 193: {
                if (port != 223) break;
                LOG.warn("write 0xDF: {}", (Object)Util.th(value & 0xFF));
                break;
            }
            default: {
                LOG.warn("outPort: {} ,data {}", (Object)Util.th(port), (Object)Util.th(value));
            }
        }
    }

    @Override
    public int readIoPort(int port) {
        switch ((port &= 0xFF) & 0xC1) {
            case 64: {
                LOG.warn("VCounter read");
                break;
            }
            case 65: {
                LOG.warn("HCounter read");
                break;
            }
            case 128: {
                return ((Tms9918aVdp)this.vdpProvider).readVRAMData();
            }
            case 129: {
                return ((Tms9918aVdp)this.vdpProvider).readStatus();
            }
            case 192: {
                LOG.debug("read: joy1");
                return ((TwoButtonsJoypad)this.joypadProvider).readDataRegister1();
            }
            case 193: {
                if (port == 223) {
                    LOG.warn("read 0xDF");
                }
                LOG.debug("read: joy2");
                return ((TwoButtonsJoypad)this.joypadProvider).readDataRegister2();
            }
            default: {
                LOG.warn("inPort: {}", (Object)Util.th(port & 0xFF));
            }
        }
        return 255;
    }

    @Override
    public void onNewFrame() {
        ((TwoButtonsJoypad)this.joypadProvider).newFrame();
    }

    @Override
    public void handleInterrupts(Z80Provider.Interrupt type) {
        boolean set = ((Tms9918aVdp)this.vdpProvider).getStatusINT() && ((Tms9918aVdp)this.vdpProvider).getGINT();
        this.z80Provider.interrupt(set);
    }
}

