/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.bus.z80;

import java.nio.ByteBuffer;
import omegadrive.SystemLoader;
import omegadrive.bus.DeviceAwareBus;
import omegadrive.bus.model.Z80BusProvider;
import omegadrive.cart.MediaInfoProvider;
import omegadrive.cart.mapper.MapperSelector;
import omegadrive.cart.mapper.RomMapper;
import omegadrive.cart.mapper.sms.SmsMapper;
import omegadrive.cpu.z80.Z80Provider;
import omegadrive.joypad.TwoButtonsJoypad;
import omegadrive.sound.fm.ym2413.Ym2413Provider;
import omegadrive.util.ArrayEndianUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.RegionDetector;
import omegadrive.util.Size;
import omegadrive.util.Util;
import omegadrive.vdp.SmsVdp;
import org.slf4j.Logger;

public class SmsBus
extends DeviceAwareBus<SmsVdp, TwoButtonsJoypad>
implements Z80BusProvider,
RomMapper {
    private static final Logger LOG = LogHelper.getLogger(SmsBus.class);
    private static final boolean verbose = false;
    public static boolean HW_ENABLE_FM = false;
    public static final boolean HW_ENABLE_BIOS = false;
    protected int hCounter;
    private static final int ROM_START = 0;
    private static final int ROM_END = 49151;
    public static final int RAM_START = 49152;
    public static final int RAM_END = 65535;
    public static final int RAM_SIZE = 8192;
    public static final int RAM_MASK = 8191;
    private static final int ROM_SIZE = 49152;
    public static final int SEGA_MAPPING_CONTROL_ADDRESS = 65532;
    public static final int CODEM_MAPPING_BASE_ADDRESS = 16384;
    public static final int KOREA_MAPPING_CONTROL_ADDRESS = 40960;
    protected static final int OVERSEAS = 64;
    protected static final int DOMESTIC = 0;
    private RomMapper mapper;
    private SmsMapper smsMapper;
    private int audioControl = 0;
    private int portAB;
    private int port3E;
    protected int countryValue = 0;
    private boolean isGG = false;
    private boolean ioEnable = true;
    private boolean prev = false;
    private boolean isNmiSet = false;

    @Override
    public void init() {
        this.handlePortAB(15);
        this.handlePort3E(8);
        this.countryValue = RegionDetector.Region.JAPAN != this.systemProvider.getRegion() ? 64 : 0;
        this.isGG = this.systemProvider.getSystemType() == SystemLoader.SystemType.GG;
        this.mapper = RomMapper.NO_OP_MAPPER;
        this.setupCartHw();
    }

    protected void setupCartHw() {
        MediaInfoProvider cartridgeInfoProvider = MediaInfoProvider.createInstance(this.memoryProvider, this.systemProvider.getRomPath());
        MapperSelector.Entry e = MapperSelector.getMapperData(this.systemProvider.getSystemType(), cartridgeInfoProvider.getCrc32());
        LOG.info(cartridgeInfoProvider.toString());
        String mapperName = SmsMapper.Type.SEGA.name();
        if (e != MapperSelector.MISSING_DATA) {
            LOG.info("Cart db match:\n{}", (Object)e);
            mapperName = e.mapperName;
        } else {
            LOG.info("Unknown rom, assuming {} mapper, crc32: {}", (Object)mapperName, (Object)cartridgeInfoProvider.getCrc32());
        }
        this.smsMapper = SmsMapper.createInstance(cartridgeInfoProvider.getRomName(), this.memoryProvider);
        this.mapper = this.smsMapper.setupRomMapper(mapperName, this.mapper);
    }

    @Override
    public int read(int addressL, Size size) {
        return this.mapper.readData(addressL, size);
    }

    @Override
    public void write(int addressL, int dataL, Size size) {
        this.mapper.writeData(addressL, dataL, size);
    }

    @Override
    public int readData(int addressL, Size size) {
        return this.smsMapper.readDataMapper(addressL, size);
    }

    @Override
    public void writeData(int address, int data, Size size) {
        assert (size == Size.BYTE);
        this.memoryProvider.writeRamByte(address & 0x1FFF, (byte)data);
    }

    @Override
    public void writeIoPort(int port, int value) {
        if (this.isGG && (port &= 0xFF) < 7) {
            return;
        }
        switch (port & 0xC1) {
            case 0: 
            case 1: {
                if ((port & 1) == 0) {
                    this.handlePort3E(value);
                    break;
                }
                this.handlePortAB(value);
                break;
            }
            case 128: {
                ((SmsVdp)this.vdpProvider).dataWrite((byte)value);
                break;
            }
            case 129: {
                ((SmsVdp)this.vdpProvider).controlWrite(value);
                break;
            }
            case 64: 
            case 65: {
                this.soundProvider.getPsg().write(value);
                break;
            }
            case 192: 
            case 193: {
                boolean isFmWrite;
                boolean isAudioControl = HW_ENABLE_FM && !this.ioEnable && port == 242;
                boolean bl = isFmWrite = HW_ENABLE_FM && (port == 240 || port == 241);
                if (isAudioControl) {
                    this.handleAudioControl(value);
                    break;
                }
                if (!isFmWrite) break;
                int fmPort = port == 240 ? Ym2413Provider.FmReg.ADDR_LATCH_REG.ordinal() : Ym2413Provider.FmReg.DATA_REG.ordinal();
                this.soundProvider.getFm().write(fmPort, value);
                break;
            }
            default: {
                LOG.warn("Unexpected writePort: {}, data {}", (Object)Util.th(port), (Object)Util.th(value));
            }
        }
    }

    @Override
    public int readIoPort(int port) {
        if (this.isGG && (port &= 0xFF) < 7) {
            return this.handleGGSerialRead(port);
        }
        switch (port & 0xC1) {
            case 64: {
                return ((SmsVdp)this.vdpProvider).getVCount();
            }
            case 65: {
                return this.hCounter;
            }
            case 128: {
                return ((SmsVdp)this.vdpProvider).dataRead();
            }
            case 129: {
                return ((SmsVdp)this.vdpProvider).controlRead();
            }
            case 192: {
                if (this.ioEnable) {
                    return ((TwoButtonsJoypad)this.joypadProvider).readDataRegister1();
                }
                if (port != 242) break;
                return HW_ENABLE_FM ? this.audioControl & 3 : 255;
            }
            case 193: {
                return this.portAB & 0x80 | (this.portAB & 0x20) << 1 | ((TwoButtonsJoypad)this.joypadProvider).readDataRegister2() & 0x3F;
            }
            default: {
                LOG.warn("Unexpected readPort: {}", (Object)Util.th(port));
            }
        }
        return 255;
    }

    private void handlePort3E(int value) {
        if (value != this.port3E) {
            boolean bEn;
            boolean bl = bEn = (value & 8) == 0;
            if (bEn) {
                LOG.warn("HW_ENABLE_BIOS is {}, unable to set biosEn: {}", (Object)false, (Object)bEn);
                bEn = false;
            }
            this.ioEnable = (value & 4) == 0;
            boolean biosEnable = bEn;
            boolean cartEnabled = (value & 0x20) == 0 || (value & 0x40) == 0;
            LOG.info("Setting port3E, {} -> {},  cartEn: {}, biosEn: {}, ioEn: {}", new Object[]{value, this.port3E, cartEnabled, biosEnable, this.ioEnable});
            if (bEn) {
                LOG.warn("HW_ENABLE_BIOS is {}, unable to set biosEn: {}", (Object)false, (Object)bEn);
            }
            this.port3E = value;
        }
    }

    private void handlePortAB(int value) {
        int thLevA = value & 0x20;
        int thDirA = value & 2;
        int thLevB = value & 0x80;
        int thDirB = value & 8;
        if (this.countryValue == 0) {
            thLevA = thDirA > 0 ? 32 : 0;
            thLevB = thDirB > 0 ? 128 : 0;
            this.portAB = this.portAB & 0x5F | thLevB | thLevA;
        } else if (this.countryValue == 64) {
            boolean levelChange;
            int prevThLevA = this.portAB & 0x20;
            int prevThLevB = this.portAB & 0x80;
            boolean bl = levelChange = thDirA > 0 && prevThLevA != thLevA || thDirB > 0 && prevThLevB != thLevB;
            if (levelChange) {
                this.hCounter = this.getHCount();
            }
            this.portAB = value;
        }
    }

    private int handleGGSerialRead(int port) {
        int res = 255;
        switch (port) {
            case 0: {
                int val = ((TwoButtonsJoypad)this.joypadProvider).readDataRegister3() == 2 ? 128 : 0;
                res = val & 0xBF | this.countryValue;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                res = 0;
                break;
            }
            case 6: {
                res = 255;
            }
        }
        return res;
    }

    private void handleAudioControl(int value) {
        this.audioControl = value;
        boolean psgDisable = (value & 3) == 1 || (value & 3) == 2;
        boolean fmDisable = (value & 3) == 0 || (value & 3) == 2;
        this.soundProvider.setEnabled(this.soundProvider.getPsg(), !psgDisable);
        this.soundProvider.setEnabled(this.soundProvider.getFm(), !fmDisable);
    }

    protected int getHCount() {
        return ((SmsVdp)this.vdpProvider).getHCount();
    }

    @Override
    public void closeRom() {
        this.mapper.closeRom();
    }

    @Override
    public void onNewFrame() {
        ((TwoButtonsJoypad)this.joypadProvider).newFrame();
    }

    @Override
    public void handleInterrupts(Z80Provider.Interrupt type) {
        if (type == Z80Provider.Interrupt.NMI) {
            this.handleNmi();
            return;
        }
        this.handleIM();
    }

    private void handleIM() {
        boolean set = ((SmsVdp)this.vdpProvider).isVINT() || ((SmsVdp)this.vdpProvider).isHINT();
        this.z80Provider.interrupt(set);
    }

    private void handleNmi() {
        boolean set;
        boolean bl = set = ((TwoButtonsJoypad)this.joypadProvider).readDataRegister3() < 2;
        if (set && !this.isNmiSet) {
            this.z80Provider.triggerNMI();
        }
        this.isNmiSet = set;
    }

    public int getMapperControl() {
        return this.smsMapper.getMapperControl();
    }

    public int[] getFrameReg() {
        return this.smsMapper.getFrameReg();
    }

    @Override
    public void saveContext(ByteBuffer buffer) {
        buffer.put((byte)(this.smsMapper.getMapperControl() & 0xFF));
        buffer.put(ArrayEndianUtil.unsignedToByteArray(this.smsMapper.getFrameReg()));
    }

    @Override
    public void loadContext(ByteBuffer buffer) {
        this.write(65532, buffer.get(), Size.BYTE);
        this.write(65533, buffer.get(), Size.BYTE);
        this.write(65534, buffer.get(), Size.BYTE);
        this.write(65535, buffer.get(), Size.BYTE);
    }
}

