/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.loader;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import omegadrive.cart.mapper.MapperSelector;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MsxXmlLoader {
    private static final Logger LOG = LogHelper.getLogger(MsxXmlLoader.class.getSimpleName());
    static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static final String softwareXPath = "//software";
    static final String titleXPath = "title/text()";
    static final String romXPath = "dump/rom";
    static final String megaromXPath = "dump/megarom";
    static final String typeEl = "type";
    static final String hashEl = "hash";
    static final String fileName = "res/romdb/msx_sw_db.xml";

    public static Map<String, MapperSelector.Entry> loadData() {
        HashMap<String, MapperSelector.Entry> map = new HashMap<String, MapperSelector.Entry>();
        long start = System.currentTimeMillis();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(new File(fileName));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xPath.evaluate(softwareXPath, doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node singleNode = nodes.item(i).cloneNode(true);
                String title = xPath.evaluate(titleXPath, singleNode);
                NodeList roms = (NodeList)xPath.evaluate(romXPath, singleNode, XPathConstants.NODESET);
                MsxXmlLoader.addRoms(map, title, roms, false);
                NodeList megaroms = (NodeList)xPath.evaluate(megaromXPath, singleNode, XPathConstants.NODESET);
                MsxXmlLoader.addRoms(map, title, megaroms, true);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to parse: {}", (Object)fileName, (Object)e);
        }
        LOG.info("XML loaded in ms: {}", (Object)(System.currentTimeMillis() - start));
        return map;
    }

    private static void addRoms(Map<String, MapperSelector.Entry> map, String title, NodeList data, boolean megaRoms) {
        for (int i = 0; i < data.getLength(); ++i) {
            NodeList ch = data.item(i).getChildNodes();
            MapperSelector.Entry e = new MapperSelector.Entry();
            e.title = title;
            e.mapperName = "NONE";
            for (int j = 0; j < ch.getLength(); ++j) {
                String text = ch.item(j).getTextContent();
                String name = ch.item(j).getNodeName();
                if (megaRoms && typeEl.equalsIgnoreCase(name)) {
                    e.mapperName = text;
                }
                if (!hashEl.equalsIgnoreCase(name)) continue;
                e.sha1 = text;
            }
            MapperSelector.Entry prev = map.putIfAbsent(e.sha1, e);
            if (prev == null) continue;
            LOG.warn("Hash collision for: {} and {}", (Object)prev, (Object)e);
        }
    }

    static {
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        try {
            dbf.setFeature("http://xml.org/sax/features/namespaces", false);
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception e) {
            LOG.error("Unable to setup xml parser", (Throwable)e);
        }
    }
}

