/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import omegadrive.SystemLoader;
import omegadrive.util.FileUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public abstract class BackupMemoryMapper {
    private static final Logger LOG = LogHelper.getLogger(BackupMemoryMapper.class.getSimpleName());
    public static final byte DEFAULT_SRAM_BYTE = -1;
    protected final String defaultSramFolder;
    protected final String sramFolder;
    protected final String sramFolderProp;
    protected Path backupFile;
    protected byte[] sram = new byte[0];
    protected final String fileType;
    protected final String romName;
    protected final int sramSize;
    protected final int sramMask;

    protected BackupMemoryMapper(SystemLoader.SystemType systemType, String fileType, String romName, int sramSize) {
        this.sramFolderProp = systemType.getShortName().toLowerCase() + ".sram.folder";
        this.defaultSramFolder = this.getDefaultBackupFileFolder(systemType);
        this.sramFolder = System.getProperty(this.sramFolderProp, this.defaultSramFolder);
        this.romName = romName;
        this.fileType = fileType;
        this.sramSize = sramSize;
        this.sramMask = Util.getRomMask(sramSize);
    }

    protected String getDefaultBackupFileFolder(SystemLoader.SystemType type) {
        return System.getProperty("user.home") + File.separator + ".helios" + File.separator + type.getShortName().toLowerCase() + File.separator + "sram";
    }

    protected void initBackupFileIfNecessary() {
        if (this.backupFile == null) {
            try {
                this.backupFile = Paths.get(this.sramFolder, this.romName + "." + this.fileType);
                long size = 0L;
                if (Files.isReadable(this.backupFile)) {
                    size = Files.size(this.backupFile);
                    if (size > 0L) {
                        this.sram = FileUtil.readBinaryFile(this.backupFile, new String[0]);
                    } else {
                        LOG.error("Backup file with size 0, attempting to recreate it");
                        size = this.createBackupFile();
                    }
                } else {
                    size = this.createBackupFile();
                }
                LOG.info("Using sram file: {} size: {} bytes", (Object)this.backupFile, (Object)size);
            }
            catch (Exception e) {
                LOG.error("Unable to create file for: {}", (Object)this.romName);
            }
        }
    }

    private int createBackupFile() {
        LOG.info("Creating backup memory file: {}", (Object)this.backupFile);
        this.sram = new byte[this.sramSize];
        Arrays.fill(this.sram, (byte)-1);
        FileUtil.writeFileSafe(this.backupFile, this.sram);
        return this.sram.length;
    }

    protected void writeFile() {
        this.initBackupFileIfNecessary();
        if (this.sram.length == 0) {
            LOG.error("Unexpected sram length: {}", (Object)this.sram.length);
            return;
        }
        if (Files.isWritable(this.backupFile)) {
            LOG.info("Writing to sram file: {}, len: {}", (Object)this.backupFile, (Object)this.sram.length);
            FileUtil.writeFileSafe(this.backupFile, this.sram);
        }
    }
}

