/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import omegadrive.SystemLoader;
import omegadrive.cart.loader.MsxXmlLoader;
import omegadrive.cart.loader.SmsLoader;

public class MapperSelector {
    public static final Entry MISSING_DATA = new Entry();
    public static final String ROM_DB_BASE_FOLDER = "res/romdb/";
    static final Map<SystemLoader.SystemType, Map<String, Entry>> cache = new HashMap<SystemLoader.SystemType, Map<String, Entry>>();

    public static Entry getMapperData(SystemLoader.SystemType type, String code) {
        if (!cache.containsKey((Object)type)) {
            switch (type) {
                case MSX: {
                    cache.put(type, MsxXmlLoader.loadData());
                    break;
                }
                case SMS: 
                case GG: {
                    cache.put(type, SmsLoader.loadData(type));
                    break;
                }
                default: {
                    cache.put(type, Collections.emptyMap());
                }
            }
        }
        return cache.get((Object)type).getOrDefault(code, MISSING_DATA);
    }

    public static class Entry {
        public String title;
        public String mapperName;
        public String sha1;
        public String crc32;

        public String toString() {
            return "Entry{title='" + this.title + "', mapperName='" + this.mapperName + "'" + (String)(Strings.isNullOrEmpty((String)this.sha1) ? "" : ", sha1='" + this.sha1 + "'") + (String)(Strings.isNullOrEmpty((String)this.crc32) ? "" : ", crc32='" + this.crc32 + "'") + "}";
        }
    }
}

