/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.md;

import java.util.Arrays;
import omegadrive.cart.mapper.RomMapper;
import omegadrive.memory.IMemoryProvider;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import omegadrive.util.Util;
import org.slf4j.Logger;

public abstract class Ssf2Mapper
implements RomMapper,
RomMapper.StateAwareMapper {
    private static final Logger LOG = LogHelper.getLogger(Ssf2Mapper.class.getSimpleName());
    public static final int BANK_SET_START_ADDRESS = 10563827;
    public static final int BANK_SET_END_ADDRESS = 10563839;
    public static final int BANK_SIZE = 524288;
    public static final int BANK_MASK = 524287;
    public static final int BANKABLE_START_ADDRESS = 524288;
    public static final int BANK_SHIFT = 19;
    public static final int BANK_REG_MASK = 15;
    public static final int SSF2_BANKS_TOTAL = 64;
    protected int[] banks = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    protected final int bankSelMask;
    protected RomMapper baseMapper;
    protected IMemoryProvider memory;
    private static final boolean verbose = false;

    protected Ssf2Mapper() {
        this(64);
    }

    protected Ssf2Mapper(int banksTotal) {
        this.bankSelMask = banksTotal - 1;
    }

    @Override
    public int readData(int addressL, Size size) {
        if (addressL >= 524288 && addressL <= 0x3FFFFF) {
            int address = addressL & 0xFFFFFF;
            address = this.banks[address >> 19] << 19 | address & 0x7FFFF;
            return Util.readDataMask(this.memory.getRomData(), address, this.memory.getRomMask(), size);
        }
        return this.baseMapper.readData(addressL, size);
    }

    @Override
    public void writeData(int addressL, int data, Size size) {
        if (addressL >= 10563827 && addressL <= 10563839) {
            this.writeBankData(addressL, data);
            return;
        }
        this.baseMapper.writeData(addressL, data, size);
    }

    @Override
    public void writeBankData(int addressL, int data) {
        int val = addressL & 0xF;
        int index = val >> 1;
        if ((val & 1) == 1 && index > 0) {
            this.banks[index] = data & this.bankSelMask;
        } else if (val == 1) {
            this.baseMapper.writeData(addressL, data, Size.BYTE);
        }
    }

    @Override
    public int[] getState() {
        assert (Arrays.stream(this.banks).allMatch(v -> v == (byte)v));
        return this.banks;
    }

    @Override
    public void setState(int[] bankData) {
        this.banks = Arrays.copyOf(bankData, bankData.length);
    }
}

