/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.md.eeprom;

import omegadrive.cart.loader.MdRomDbModel;
import omegadrive.cart.mapper.md.eeprom.EepromBase;
import omegadrive.util.ArrayEndianUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Size;
import org.slf4j.Logger;

public class I2cEeprom
implements EepromBase {
    private static final Logger LOG = LogHelper.getLogger(I2cEeprom.class.getSimpleName());
    private static final boolean verbose = false;
    private static final boolean logReadWrite = false;
    protected final EepromContext ctx = new EepromContext();
    private byte[] sram;

    public static EepromBase createInstance(MdRomDbModel.RomDbEntry entry, byte[] sram) {
        EepromBase eb = NO_OP;
        if (entry.hasEeprom()) {
            I2cEeprom e = new I2cEeprom();
            e.ctx.lineMap = entry.eeprom.getEepromLineMap();
            e.ctx.spec = entry.eeprom.getEepromType();
            e.sram = sram;
            LOG.info("Init {}", (Object)entry.eeprom);
            eb = e;
        }
        return eb;
    }

    @Override
    public int readEeprom(int address, Size size) {
        int res = this.eeprom_i2c_out() << this.ctx.lineMap.sda_out_bit;
        assert (size != Size.LONG);
        if (size == Size.BYTE) {
            res = ArrayEndianUtil.getByteInWordBE(res, address & 1);
        }
        return res;
    }

    @Override
    public void writeEeprom(int address, int data, Size size) {
        assert (size != Size.LONG);
        if (size == Size.BYTE) {
            data = this.ctx.writeLatch = ArrayEndianUtil.setByteInWordBE(this.ctx.writeLatch, data, address & 1);
        }
        this.writeWordEeprom(data);
    }

    private void writeWordEeprom(int data) {
        this.ctx.scl = data >> this.ctx.lineMap.scl_in_bit & 1;
        this.ctx.sda = data >> this.ctx.lineMap.sda_in_bit & 1;
        this.eeprom_i2c_update();
    }

    private int eeprom_i2c_out() {
        int res = 0;
        if (this.ctx.state == EepromState.READ_DATA) {
            if (this.ctx.cycles < 9) {
                int index = this.ctx.wordAddress & 0xFFFF;
                res = this.sram[(this.ctx.deviceAddress | this.ctx.wordAddress) & 0xFFFF] >> 8 - this.ctx.cycles & 1;
            }
        } else if (this.ctx.cycles != 9) {
            res = this.ctx.sda >> this.ctx.lineMap.sda_out_bit & 1;
        }
        return res;
    }

    void eeprom_i2c_update() {
        switch (this.ctx.state) {
            case STAND_BY: {
                this.checkStart();
                break;
            }
            case WAIT_STOP: {
                this.checkStop();
                break;
            }
            case GET_WORD_ADR_7BITS: {
                this.checkStart();
                this.checkStop();
                if (this.ctx.prevScl > this.ctx.scl) {
                    if (this.ctx.cycles < 9) {
                        ++this.ctx.cycles;
                        break;
                    }
                    this.ctx.cycles = 1;
                    this.ctx.state = this.ctx.rw > 0 ? EepromState.READ_DATA : EepromState.WRITE_DATA;
                    this.ctx.buffer = 0;
                    break;
                }
                if (this.ctx.prevScl >= this.ctx.scl) break;
                if (this.ctx.cycles < 8) {
                    this.ctx.wordAddress |= this.ctx.sda << 7 - this.ctx.cycles;
                    break;
                }
                if (this.ctx.cycles != 8) break;
                this.ctx.rw = this.ctx.sda;
                break;
            }
            case GET_DEVICE_ADR: {
                this.checkStart();
                this.checkStop();
                if (this.ctx.prevScl > this.ctx.scl) {
                    if (this.ctx.cycles < 9) {
                        ++this.ctx.cycles;
                        break;
                    }
                    this.ctx.deviceAddress <<= this.ctx.spec.addressBits;
                    this.ctx.cycles = 1;
                    if (this.ctx.rw > 0) {
                        this.ctx.state = EepromState.READ_DATA;
                        break;
                    }
                    this.ctx.wordAddress = 0;
                    this.ctx.state = this.ctx.spec.addressBits == 16 ? EepromState.GET_WORD_ADR_HIGH : EepromState.GET_WORD_ADR_LOW;
                    break;
                }
                if (this.ctx.prevScl >= this.ctx.scl) break;
                if (this.ctx.cycles > 4 && this.ctx.cycles < 8) {
                    this.ctx.deviceAddress |= this.ctx.sda << 7 - this.ctx.cycles;
                    break;
                }
                if (this.ctx.cycles != 8) break;
                this.ctx.rw = this.ctx.sda;
                break;
            }
            case GET_WORD_ADR_HIGH: {
                this.checkStart();
                this.checkStop();
                if (this.ctx.prevScl > this.ctx.scl) {
                    if (this.ctx.cycles < 9) {
                        ++this.ctx.cycles;
                        break;
                    }
                    this.ctx.cycles = 1;
                    this.ctx.state = EepromState.GET_WORD_ADR_LOW;
                    break;
                }
                if (this.ctx.prevScl >= this.ctx.scl || this.ctx.cycles >= 9) break;
                if (this.ctx.spec.sizeMask < 1 << 16 - this.ctx.cycles) {
                    this.ctx.deviceAddress >>= 1;
                    break;
                }
                this.ctx.wordAddress |= this.ctx.sda << 16 - this.ctx.cycles;
                break;
            }
            case GET_WORD_ADR_LOW: {
                this.checkStart();
                this.checkStop();
                if (this.ctx.prevScl > this.ctx.scl) {
                    if (this.ctx.cycles < 9) {
                        ++this.ctx.cycles;
                        break;
                    }
                    this.ctx.cycles = 1;
                    this.ctx.state = EepromState.WRITE_DATA;
                    this.ctx.buffer = 0;
                    break;
                }
                if (this.ctx.prevScl >= this.ctx.scl || this.ctx.cycles >= 9) break;
                if (this.ctx.spec.sizeMask < 1 << 8 - this.ctx.cycles) {
                    this.ctx.deviceAddress >>= 1;
                    break;
                }
                this.ctx.wordAddress |= this.ctx.sda << 8 - this.ctx.cycles;
                break;
            }
            case READ_DATA: {
                this.checkStart();
                this.checkStop();
                if (this.ctx.prevScl > this.ctx.scl) {
                    if (this.ctx.cycles < 9) {
                        ++this.ctx.cycles;
                        break;
                    }
                    this.ctx.cycles = 1;
                    break;
                }
                if (this.ctx.prevScl >= this.ctx.scl || this.ctx.cycles != 9) break;
                if (this.ctx.sda > 0) {
                    this.ctx.state = EepromState.WAIT_STOP;
                    break;
                }
                this.ctx.wordAddress = this.ctx.wordAddress + 1 & this.ctx.spec.sizeMask;
                break;
            }
            case WRITE_DATA: {
                this.checkStart();
                this.checkStop();
                if (this.ctx.prevScl > this.ctx.scl) {
                    if (this.ctx.cycles < 9) {
                        ++this.ctx.cycles;
                        break;
                    }
                    this.ctx.cycles = 1;
                    break;
                }
                if (this.ctx.prevScl >= this.ctx.scl) break;
                if (this.ctx.cycles < 9) {
                    this.ctx.buffer = (byte)(this.ctx.buffer | this.ctx.sda << 8 - this.ctx.cycles);
                    break;
                }
                this.sram[(this.ctx.deviceAddress | this.ctx.wordAddress) & 0xFFFF] = this.ctx.buffer;
                this.ctx.buffer = 0;
                this.ctx.wordAddress = this.ctx.wordAddress & ~this.ctx.spec.pagewriteMask | this.ctx.wordAddress + 1 & this.ctx.spec.pagewriteMask;
            }
        }
        this.ctx.prevScl = this.ctx.scl;
        this.ctx.prevSda = this.ctx.sda;
    }

    private void checkStart() {
        if ((this.ctx.prevScl & this.ctx.scl) > 0 && this.ctx.prevSda > this.ctx.sda) {
            this.ctx.cycles = 0;
            if (this.ctx.spec.addressBits == 7) {
                this.ctx.state = EepromState.GET_WORD_ADR_7BITS;
                this.ctx.wordAddress = 0;
            } else {
                this.ctx.deviceAddress = 0;
                this.ctx.state = EepromState.GET_DEVICE_ADR;
            }
        }
    }

    private void checkStop() {
        if ((this.ctx.prevScl & this.ctx.scl) > 0 && this.ctx.sda > this.ctx.prevSda) {
            this.ctx.state = EepromState.STAND_BY;
        }
    }

    @Override
    public void setSram(byte[] sram) {
        this.sram = sram;
    }

    protected static class EepromContext {
        public int scl;
        public int prevScl;
        public int sda;
        public int prevSda;
        public int cycles;
        public int rw;
        public int writeLatch;
        public byte buffer;
        public int wordAddress = 0;
        public int deviceAddress = 0;
        public EepromState state = EepromState.STAND_BY;
        public MdRomDbModel.EepromType spec;
        public MdRomDbModel.EepromLineMap lineMap;

        protected EepromContext() {
        }
    }

    static enum EepromState {
        STAND_BY,
        WAIT_STOP,
        GET_DEVICE_ADR,
        GET_WORD_ADR_7BITS,
        GET_WORD_ADR_HIGH,
        GET_WORD_ADR_LOW,
        WRITE_DATA,
        READ_DATA;

    }
}

