/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cart.mapper.msx;

import omegadrive.cart.mapper.RomMapper;
import omegadrive.cart.mapper.msx.KonamiMapperImpl;
import omegadrive.util.LogHelper;
import org.slf4j.Logger;

public class KonamiMapper
extends KonamiMapperImpl {
    public static final int BLOCK_NUM = 32;
    public static final int MAPPER_START_ADDRESS = 16384;
    public static final int MAPPER_END_ADDRESS = 49151;
    public static final int PAGES_8KB = 4;
    private static final KonamiType[] list = KonamiType.values();
    private static final Logger LOG = LogHelper.getLogger(KonamiMapper.class.getSimpleName());

    private KonamiMapper(byte[] rom, KonamiType type) {
        super(rom, type);
    }

    public static RomMapper createMapper(byte[] rom, String type) {
        KonamiType t = KonamiMapper.getMapperType(type);
        if (t == null) {
            LOG.error("Mapper not supported: {}", (Object)type);
            return NO_OP_MAPPER;
        }
        return KonamiMapper.createMapper(rom, t);
    }

    public static RomMapper createMapper(byte[] rom, KonamiType type) {
        return new KonamiMapperImpl(rom, type);
    }

    public static KonamiType getMapperType(String mapperName) {
        for (KonamiType t : list) {
            if (!mapperName.equalsIgnoreCase(t.toString())) continue;
            return t;
        }
        return null;
    }

    public static enum KonamiType {
        KONAMI,
        KONAMISCC;

    }
}

