/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class CpuFastDebug {
    private static final Logger LOG = LogHelper.getLogger(CpuFastDebug.class.getSimpleName());
    private static final boolean logToSysOut = Boolean.parseBoolean(System.getProperty("helios.logToSysOut", "true"));
    public static final DebugMode[] debugModeVals = DebugMode.values();
    public static final PcInfoWrapper NOT_VISITED = new PcInfoWrapper(0, 0);
    private final CpuDebugContext ctx;
    public final PcInfoWrapper[][] pcInfoWrapper;
    public DebugMode debugMode = DebugMode.NONE;
    private final CpuDebugInfoProvider debugInfoProvider;
    private int delay;
    private boolean isBusy;
    private final String logHead;
    private static final boolean VERBOSE = false;
    public static final int CK_DELAY_ON_LOOP = 50;
    private static final int pcHistorySize = 12;
    private int FRONT = 0;
    private int BACK = 1;
    private final int[][] opcodesHistory = new int[2][12];
    private final int[][] pcHistory = new int[2][12];
    private int pcHistoryPointer = 0;
    private int loops;
    private boolean looping = false;
    private boolean isKnownLoop;
    private int loopsCounter = 0;

    public CpuFastDebug(CpuDebugInfoProvider debugInfoProvider, CpuDebugContext ctx) {
        this.debugInfoProvider = debugInfoProvider;
        this.ctx = ctx;
        this.pcInfoWrapper = new PcInfoWrapper[ctx.pcAreasNumber][0];
        this.logHead = Optional.ofNullable(ctx.cpuCode).orElse("");
        this.init();
    }

    public void init() {
        assert (this.ctx.debugMode < debugModeVals.length) : this.ctx.debugMode;
        this.debugMode = debugModeVals[this.ctx.debugMode];
        this.resetWrapper();
    }

    public void resetWrapper() {
        LOG.warn("{} Resetting known and visited PCs!!", (Object)this.logHead);
        for (int i = 0; i < this.ctx.pcAreasMaskMap.length; ++i) {
            int pcAreaSize = this.ctx.pcAreasMaskMap[i] + 1;
            if (pcAreaSize <= 1) continue;
            this.pcInfoWrapper[i] = new PcInfoWrapper[pcAreaSize];
            Arrays.fill(this.pcInfoWrapper[i], NOT_VISITED);
        }
    }

    public void printDebugMaybe() {
        switch (this.debugMode) {
            case STATE: {
                this.log(this.debugInfoProvider.getCpuState(this.ctx.cpuCode), "");
                break;
            }
            case INST_ONLY: {
                this.doPrintInst("", this.debugInfoProvider.getInstructionOnly());
                break;
            }
            case NEW_INST_ONLY: {
                this.printNewInstruction();
                break;
            }
        }
    }

    private void printNewInstruction() {
        boolean isReplaced;
        int pc = this.debugInfoProvider.getPc();
        int area = pc >>> this.ctx.pcAreaShift;
        int mask = this.ctx.pcAreasMaskMap[area];
        assert (mask > 0) : Util.th(pc);
        int pcMasked = pc & mask;
        int opcode = this.debugInfoProvider.getOpcode();
        PcInfoWrapper piw = this.pcInfoWrapper[area][pcMasked];
        if (piw == NOT_VISITED) {
            String instOnly = this.debugInfoProvider.getInstructionOnly(pc, opcode);
            this.pcInfoWrapper[area][pcMasked] = this.createPcWrapper(pcMasked, area, opcode);
            this.pcInfoWrapper[area][pcMasked].str = instOnly;
            this.doPrintInst(" [NEW]", instOnly);
            return;
        }
        boolean bl = isReplaced = piw != NOT_VISITED && piw.opcode != opcode;
        if (isReplaced) {
            piw.opcode = opcode;
            piw.str = this.debugInfoProvider.getInstructionOnly(pc, opcode);
            this.doPrintInst(" [NEW-R]", piw.str);
        }
    }

    private void doPrintInst(String tail, String instOnly) {
        this.log(this.logHead + " " + instOnly, tail);
    }

    private PcInfoWrapper createPcWrapper(int pcMasked, int area, int opcode) {
        PcInfoWrapper piw = new PcInfoWrapper(area, pcMasked);
        piw.opcode = opcode;
        return piw;
    }

    private void log(String s1, String s2) {
        if (logToSysOut) {
            System.out.println(s1 + s2);
        } else {
            LOG.info("{}{}", (Object)s1, (Object)s2);
        }
    }

    public int isBusyLoop(int pc, int opcode) {
        this.pcHistory[this.FRONT][this.pcHistoryPointer] = pc;
        this.opcodesHistory[this.FRONT][this.pcHistoryPointer] = opcode;
        this.pcHistoryPointer = (this.pcHistoryPointer + 1) % 12;
        if (this.pcHistoryPointer == 0) {
            if (Arrays.equals(this.pcHistory[this.FRONT], this.pcHistory[this.BACK])) {
                if (Arrays.equals(this.opcodesHistory[this.FRONT], this.opcodesHistory[this.BACK])) {
                    ++this.loops;
                    if (!this.looping && this.loops > 12) {
                        this.handleLoop(pc, opcode);
                        this.looping = this.isBusy;
                    }
                } else {
                    this.handleStopLoop(pc);
                }
            } else {
                if (this.looping) {
                    this.handleStopLoop(pc);
                }
                this.loops = 0;
            }
            this.FRONT = this.FRONT + 1 & 1;
            this.BACK = this.BACK + 1 & 1;
        }
        assert (!this.looping ? this.delay == 0 : this.delay > 0) : this.looping + "," + this.delay;
        return this.delay;
    }

    private void handleStopLoop(int pc) {
        this.looping = false;
        this.loops = 0;
        this.delay = 0;
        if (!this.isKnownLoop) {
            // empty if block
        }
    }

    private void handleLoop(int pc, int opcode) {
        int[] opcodes = Arrays.stream(this.opcodesHistory[this.FRONT]).distinct().sorted().toArray();
        this.isBusy = CpuFastDebug.isBusyLoop(this.ctx.isLoopOpcode, opcodes);
        this.delay = this.isBusy ? 50 : 0;
        int area = pc >>> this.ctx.pcAreaShift;
        int mask = this.ctx.pcAreasMaskMap[area];
        int pcMasked = pc & mask;
        PcInfoWrapper piw = this.pcInfoWrapper[area][pcMasked];
        if (piw != NOT_VISITED && piw.pcLoops > 0) {
            if (!this.isKnownLoop && this.isBusy) {
                this.printLoopInfo();
            }
            this.isKnownLoop = true;
            return;
        }
        if (piw == NOT_VISITED) {
            this.pcInfoWrapper[area][pcMasked] = piw = this.createPcWrapper(pcMasked, area, opcode);
        }
        assert (piw != NOT_VISITED) : Util.th(pc) + "," + String.valueOf(piw);
        this.isKnownLoop = false;
        ++this.loopsCounter;
        piw.pcLoops = this.loopsCounter;
    }

    private void printLoopInfo() {
        int[] pcs = Arrays.stream(this.pcHistory[this.FRONT]).distinct().sorted().toArray();
        String s = Arrays.stream(pcs).mapToObj(this.debugInfoProvider::getInstructionOnly).collect(Collectors.joining("\n"));
        System.out.println(this.logHead + "\t" + pcs.length + " Loop, isBusy: " + this.isBusy + "\n" + s + "\n" + this.debugInfoProvider.getCpuState(""));
    }

    public static boolean isBusyLoop(Predicate<Integer> isLoopOpcode, int[] opcodes) {
        for (int i = 0; i < opcodes.length; ++i) {
            if (isLoopOpcode.test(opcodes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isIgnore(Predicate<Integer> isIgnoredOpcode, int[] opcodes) {
        for (int i = 0; i < opcodes.length; ++i) {
            if (!isIgnoredOpcode.test(opcodes[i])) continue;
            return true;
        }
        return false;
    }

    public static enum DebugMode {
        NONE,
        INST_ONLY,
        NEW_INST_ONLY,
        STATE;

    }

    public static interface CpuDebugInfoProvider {
        public String getInstructionOnly(int var1, int var2);

        public String getInstructionOnly(int var1);

        public String getCpuState(String var1);

        public int getPc();

        public int getOpcode();

        default public String getInstructionOnly() {
            return this.getInstructionOnly(this.getPc(), this.getOpcode());
        }
    }

    public static class CpuDebugContext {
        public final int[] pcAreasMaskMap;
        public final int pcAreasNumber;
        public int pcAreaShift;
        public Predicate<Integer> isLoopOpcode = i -> false;
        public Predicate<Integer> isIgnoreOpcode = i -> true;
        public int debugMode;
        public String cpuCode;

        public CpuDebugContext(Map<Integer, Integer> areaMaskMap) {
            this.pcAreasNumber = 1 + areaMaskMap.keySet().stream().mapToInt(Integer::intValue).max().orElseThrow();
            this.pcAreasMaskMap = new int[this.pcAreasNumber];
            for (Map.Entry<Integer, Integer> e : areaMaskMap.entrySet()) {
                this.pcAreasMaskMap[e.getKey().intValue()] = e.getValue();
            }
        }
    }

    public static class PcInfoWrapper {
        public final int area;
        public final int pcMasked;
        public final int hc;
        public int opcode;
        public int pcLoops;
        public String str;

        public PcInfoWrapper(int area, int pcMasked) {
            this.area = area;
            this.pcMasked = pcMasked;
            this.hc = Objects.hashCode((Object[])new Object[]{area, pcMasked});
        }

        public String toString() {
            return new StringJoiner(", ", PcInfoWrapper.class.getSimpleName() + "[", "]").add("area=" + this.area).add("pcMasked=" + this.pcMasked).add("opcode=" + this.opcode).add("pcLooops=" + this.pcLoops).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PcInfoWrapper that = (PcInfoWrapper)o;
            return this.area == that.area && this.pcMasked == that.pcMasked;
        }

        public int hashCode() {
            return this.hc;
        }
    }
}

