/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.m68k.debug;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import m68k.cpu.Cpu;
import omegadrive.bus.model.MdM68kBusProvider;
import omegadrive.cpu.CpuFastDebug;
import omegadrive.cpu.m68k.MC68000Helper;
import omegadrive.cpu.m68k.MC68000Wrapper;
import omegadrive.cpu.m68k.debug.McdHacks;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class MC68000WrapperFastDebug
extends MC68000Wrapper
implements CpuFastDebug.CpuDebugInfoProvider {
    private static final Logger LOG = LogHelper.getLogger(MC68000WrapperFastDebug.class.getSimpleName());
    private static final int debugMode = Integer.parseInt(System.getProperty("helios.68k.debug.mode", String.valueOf(CpuFastDebug.DebugMode.NONE.ordinal())));
    private static final boolean busyLoopDetection = Boolean.parseBoolean(System.getProperty("helios.68k.busy.loop", "false"));
    private final CpuFastDebug fastDebug;
    private int opcode;
    private int intLevel;
    private static final Map<Integer, Integer> areaMaskMap = ImmutableMap.of((Object)0, (Object)1048575, (Object)1, (Object)1048575, (Object)2, (Object)1048575, (Object)3, (Object)1048575, (Object)8, (Object)1048575, (Object)9, (Object)1048575, (Object)15, (Object)1048575);
    private static final Predicate<Integer> isBranch = op -> (op & 0x6000) == 24576 || (op & 0xFFC0) == 20160;
    private static final Predicate<Integer> isTest = op -> (op & 0xFFC0) == 2048 || (op & 0xFF00) == 18944 || (op & 0xFFC0) == 1280;
    private static final Predicate<Integer> isMov = op -> (op & 0xC1F8) == 16 || (op & 0xC1F8) == 56 || (op & 0xC1F8) == 40;
    private static final Predicate<Integer> isAndi = op -> (op & 0xFF38) == 512 || (op & 0xF138) == 49168 || (op & 0xF138) == 49208;
    private static final Predicate<Integer> isCmp = op -> (op & 0xFF38) == 3128 || (op & 0xFF38) == 3112 || (op & 0xFF38) == 3072 || (op & 0xFF38) == 3088 || (op & 0xF138) == 45112 || (op & 0xF138) == 45096 || (op & 0xF138) == 45072;
    private static final Predicate<Integer> isNop = op -> op == 20081;
    public static final Predicate<Integer> isLoopOpcode = isBranch.or(isTest).or(isMov).or(isAndi).or(isCmp).or(isNop);
    public static final Predicate<Integer> isIgnoreOpcode = op -> (op & 0xF0F8) == 20680 || (op & 0xFF00) == 1024 || (op >> 8 & 0xF1) == 81 && (op & 0xC0) != 192;

    public MC68000WrapperFastDebug(BufferUtil.CpuDeviceAccess cpu, MdM68kBusProvider busProvider) {
        super(cpu, busProvider);
        this.fastDebug = new CpuFastDebug(this, MC68000WrapperFastDebug.createContext(cpu));
        this.init();
    }

    public static CpuFastDebug.CpuDebugContext createContext(BufferUtil.CpuDeviceAccess cpu) {
        CpuFastDebug.CpuDebugContext ctx = new CpuFastDebug.CpuDebugContext(areaMaskMap);
        ctx.pcAreaShift = 20;
        ctx.isLoopOpcode = isLoopOpcode;
        ctx.isIgnoreOpcode = isIgnoreOpcode;
        ctx.debugMode = debugMode;
        ctx.cpuCode = cpu.cpuShortCode;
        return ctx;
    }

    @Override
    public int runInstruction() {
        this.currentPC = this.m68k.getPC() & 0xFFFFFF;
        this.opcode = this.m68k.readMemoryWord(this.currentPC);
        this.fastDebug.printDebugMaybe();
        if (this.currentPC == this.opcode && this.opcode == 0) {
            throw new RuntimeException("oops");
        }
        if (!busyLoopDetection) {
            McdHacks.runMcdHacks(this.fastDebug, this.cpu, this.currentPC, (Cpu)this.m68k);
            return super.runInstruction();
        }
        return this.fastDebug.isBusyLoop(this.currentPC, this.opcode) + super.runInstruction();
    }

    private void checkInterruptLevelChange() {
        int pl = this.m68k.getInterruptLevel();
        if (pl != this.intLevel) {
            LOG.info("{}, intLevel: {} -> {}", new Object[]{this.getInfo(), this.intLevel, pl});
            this.intLevel = pl;
        }
    }

    @Override
    public String getCpuState(String head) {
        return MC68000Helper.getCpuState((Cpu)this.m68k, head);
    }

    @Override
    public int getPc() {
        return this.currentPC;
    }

    @Override
    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public String getInstructionOnly(int pc, int opcode) {
        try {
            return MC68000Helper.dumpOp((Cpu)this.m68k, pc, opcode);
        }
        catch (Exception e) {
            LOG.warn("Unable to dump the instruction at PC: {}", (Object)Util.th(pc & 0xFFFFFF), (Object)e);
            return "????";
        }
    }

    @Override
    public String getInstructionOnly(int pc) {
        try {
            return MC68000Helper.dumpOp((Cpu)this.m68k, pc);
        }
        catch (Exception e) {
            LOG.warn("Unable to dump the instruction at PC: {}", (Object)Util.th(pc & 0xFFFFFF), (Object)e);
            return "????";
        }
    }

    public CpuFastDebug getFastDebug() {
        return this.fastDebug;
    }
}

