/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.m68k.debug;

import m68k.cpu.Cpu;
import mcd.cdd.CdBiosHelper;
import omegadrive.cpu.CpuFastDebug;
import omegadrive.util.BufferUtil;
import omegadrive.util.LogHelper;
import omegadrive.util.Util;
import org.slf4j.Logger;

public class McdHacks {
    private static final Logger LOG = LogHelper.getLogger(McdHacks.class.getSimpleName());

    public static void runMcdHacks(CpuFastDebug fastDebug, BufferUtil.CpuDeviceAccess cpu, int currentPC, Cpu m68k) {
        if (cpu == BufferUtil.CpuDeviceAccess.SUB_M68K) {
            CdBiosHelper.logCdPcInfo(currentPC, m68k);
        }
        McdHacks.mcdVerHacks(fastDebug, cpu, currentPC, m68k);
    }

    public static void biosUs_Errors(BufferUtil.CpuDeviceAccess cpu, int currentPC) {
        if (cpu == BufferUtil.CpuDeviceAccess.M68K) {
            return;
        }
        if (currentPC == 3872 || currentPC == 3890) {
            LOG.warn("BIOS US error: {}, PC:{}", (Object)"Abort CDD transfers", (Object)Util.th(currentPC));
            assert (false);
        } else if (currentPC == 6522) {
            LOG.warn("BIOS US error: {}, PC:{}", (Object)"_cdctrn timeout", (Object)Util.th(currentPC));
            assert (false);
        }
    }

    public static void mcdVerHacks(CpuFastDebug fastDebug, BufferUtil.CpuDeviceAccess cpu, int currentPC, Cpu m68k) {
        boolean match = false;
        boolean sentinel = false;
        if (cpu == BufferUtil.CpuDeviceAccess.M68K && currentPC == 82262 && m68k.getDataRegisterLong(1) == 34) {
            LOG.warn("{} skipping code at {} -> {}", new Object[]{cpu, Util.th(currentPC), Util.th(currentPC + 4)});
            match = true;
            assert (sentinel);
        } else if (cpu == BufferUtil.CpuDeviceAccess.M68K && currentPC == 82662 && m68k.getAddrRegisterLong(0) == 10559488) {
            LOG.warn("{} skipping code at {} -> {}", new Object[]{cpu, Util.th(currentPC), Util.th(currentPC + 4)});
            match = true;
            m68k.setDataRegisterLong(7, 0);
            assert (sentinel);
        } else if (cpu == BufferUtil.CpuDeviceAccess.M68K && currentPC == 83122 && m68k.getAddrRegisterLong(1) == 10559488) {
            LOG.warn("{} skipping code at {} -> {}", new Object[]{cpu, Util.th(currentPC), Util.th(currentPC + 4)});
            match = true;
            assert (sentinel);
        } else if (cpu == BufferUtil.CpuDeviceAccess.M68K && currentPC == 75436 && m68k.getDataRegisterLong(1) != 9) {
            LOG.warn("{} skipping code at {} -> {}", new Object[]{cpu, Util.th(currentPC), Util.th(currentPC + 4)});
            m68k.setDataRegisterLong(1, 9);
            assert (sentinel);
        }
        if (match) {
            m68k.setPC(currentPC += 4);
            fastDebug.printDebugMaybe();
            assert (sentinel);
        }
    }
}

