/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.ssp16;

import omegadrive.cpu.ssp16.Ssp16Impl;
import omegadrive.cpu.ssp16.Ssp16Types;
import omegadrive.memory.IMemoryProvider;
import omegadrive.util.ArrayEndianUtil;

public interface Ssp16 {
    public static final int SSP_PMC_HAVE_ADDR = 1;
    public static final int SSP_PMC_SET = 2;
    public static final int SSP_HANG = 4096;
    public static final int SSP_WAIT_PM0 = 8192;
    public static final int SSP_WAIT_30FE06 = 16384;
    public static final int SSP_WAIT_30FE08 = 32768;
    public static final int SSP_WAIT_MASK = 61440;
    public static final int SSP_RAM_SIZE_WORDS = 256;
    public static final int SSP_RAM_MASK_WORDS = 255;
    public static final int SSP_POINTER_REGS_MASK = 255;
    public static final int MASK_16BIT = 65535;
    public static final int PC_MASK = 65535;
    public static final int IRAM_ROM_SIZE_WORDS = 65536;
    public static final int IRAM_SIZE_WORDS = 1024;
    public static final int ROM_SIZE_WORDS = 64512;
    public static final int DRAM_SIZE_WORDS = 65536;
    public static final int SVP_ROM_START_ADDRESS_BYTE = 2048;
    public static final int SVP_ROM_START_ADDRESS_WORD = 1024;
    public static final int SVP_ROM_BOOTSTRAP_PC_WORD = 255;
    public static final Ssp16 NO_SVP = new Ssp16(){

        @Override
        public void ssp1601_reset(Ssp16Types.Ssp1601_t ssp) {
        }

        @Override
        public void ssp1601_run(int cycles) {
        }
    };

    public static Ssp16 createSvp(IMemoryProvider memoryProvider) {
        Ssp16Types.Cart svpCart = new Ssp16Types.Cart();
        Ssp16Types.Ssp1601_t sspCtx = new Ssp16Types.Ssp1601_t();
        Ssp16Types.Svp_t svpCtx = new Ssp16Types.Svp_t(sspCtx);
        Ssp16.loadCart(svpCart, memoryProvider.getRomData());
        Ssp16Impl ssp16 = Ssp16Impl.createInstance(svpCtx, svpCart);
        ssp16.ssp1601_reset(sspCtx);
        return ssp16;
    }

    public static void loadCart(Ssp16Types.Cart cart, byte[] romBytes) {
        cart.rom = new int[romBytes.length >> 1];
        int k = 0;
        int i = 0;
        while (i < romBytes.length) {
            ArrayEndianUtil.setWordFromBytesBE(romBytes, cart.rom, i, k);
            i += 2;
            ++k;
        }
    }

    public void ssp1601_reset(Ssp16Types.Ssp1601_t var1);

    public void ssp1601_run(int var1);

    default public Ssp16Types.Svp_t getSvpContext() {
        return Ssp16Types.NO_SVP_CONTEXT;
    }

    default public void loadSvpContext(Ssp16Types.Svp_t svpCtx) {
    }
}

