/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.ssp16;

public class Ssp16Disasm {
    static final String[] reg = new String[]{"-", "X", "Y", "A", "ST", "STACK", "PC", "P", "EXT0", "EXT1", "EXT2", "EXT3", "EXT4", "EXT5", "EXT6", "AL"};
    static final String[] rij = new String[]{"r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7"};
    static final String[] modifier = new String[]{"", "+!", "-", "+"};
    static final String[] modifier_sf = new String[]{"|00", "|01", "|10", "|11"};
    static final String[] cond = new String[]{"always", "RESERVED", "gpi0", "gpi1", "l", "z", "ov", "n", "diof", "gpi2", "gpi3", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED"};
    static final String[] acc_op = new String[]{"ror", "rol", "shr", "shl", "inc", "dec", "neg", "abs"};
    static final String[] flag_op = new String[]{"?", "?", "resl", "setl", "resie", "setie", "?", "?", "resop", "setop", "?", "?", "?", "?", "res", "set"};
    static final String[] arith_ops = new String[]{"", "sub", "", "cmp", "add", "and", "or", "eor"};
    static final int DASMFLAG_STEP_OUT = 8;
    static final int DASMFLAG_STEP_OVER = 16;
    static final int DASMFLAG_SUPPORTED = 32;

    static int BIT_B(int op) {
        return op >> 8 & 1;
    }

    static String RIJ(int op) {
        return rij[(Ssp16Disasm.BIT_B(op) << 2) + (op & 3)];
    }

    static String RI(int i) {
        return rij[i & 3];
    }

    static String RJ(int i) {
        return rij[(i & 3) + 4];
    }

    static String MODIFIER(int mod, int r3) {
        return r3 == 3 ? modifier_sf[mod] : modifier[mod];
    }

    static String MODIFIER_LOW(int op) {
        return Ssp16Disasm.MODIFIER(op >> 2 & 3, op & 3);
    }

    static String MODIFIER_HIGH(int op) {
        return Ssp16Disasm.MODIFIER(op >> 6 & 3, op >> 4 & 3);
    }

    static int READ_OP_DASM_BYTE(int[] base_oprom, int p) {
        return base_oprom[p] << 8 | base_oprom[p + 1];
    }

    static int READ_OP_DASM_WORD(int[] base_oprom, int pc, int byteOffset) {
        return base_oprom[pc + (byteOffset >> 1)] & 0xFFFF;
    }

    static String get_cond(int op) {
        StringBuilder sb = new StringBuilder();
        if ((op & 0xF0) > 0) {
            sb.append(String.format("%s=%d", cond[op >> 4 & 0xF], Ssp16Disasm.BIT_B(op)));
        } else {
            sb.append(String.format("%s", cond[op >> 4 & 0xF]));
        }
        return sb.toString();
    }

    public static int dasm_ssp1601(StringBuilder sb, int pc, int[] oprom) {
        int size = 1;
        int flags = 0;
        int[] base_oprom = oprom;
        int op = Ssp16Disasm.READ_OP_DASM_WORD(base_oprom, pc, 0);
        switch (op >> 9) {
            case 0: {
                if (op == 0) {
                    sb.append("nop");
                    break;
                }
                if ((op & 0xFF) == 101) {
                    sb.append("ret");
                    flags |= 8;
                    break;
                }
                sb.append(String.format("ld %s, %s", reg[op >> 4 & 0xF], reg[op & 0xF]));
                break;
            }
            case 1: {
                sb.append(String.format("ld %s, (%s%s)", reg[op >> 4 & 0xF], Ssp16Disasm.RIJ(op), Ssp16Disasm.MODIFIER_LOW(op)));
                break;
            }
            case 2: {
                sb.append(String.format("ld (%s%s), %s", Ssp16Disasm.RIJ(op), Ssp16Disasm.MODIFIER_LOW(op), reg[op >> 4 & 0xF]));
                break;
            }
            case 3: {
                sb.append(String.format("ld A, %X", op & 0x1FF));
                break;
            }
            case 4: {
                sb.append(String.format("ld %s, %X", reg[op >> 4 & 0xF], Ssp16Disasm.READ_OP_DASM_WORD(base_oprom, pc, 2)));
                size = 2;
                break;
            }
            case 5: {
                sb.append(String.format("ld %s, ((%s%s))", reg[op >> 4 & 0xF], Ssp16Disasm.RIJ(op), Ssp16Disasm.MODIFIER_LOW(op)));
                break;
            }
            case 6: {
                sb.append(String.format("ld (%s%s), %X", Ssp16Disasm.RIJ(op), Ssp16Disasm.MODIFIER_LOW(op), Ssp16Disasm.READ_OP_DASM_WORD(base_oprom, pc, 2)));
                size = 2;
                break;
            }
            case 7: {
                sb.append(String.format("ld %X, A", op & 0x1FF));
                break;
            }
            case 9: {
                sb.append(String.format("ld %s, %s%s", reg[op >> 4 & 0xF], Ssp16Disasm.RIJ(op), Ssp16Disasm.MODIFIER_LOW(op)));
                break;
            }
            case 10: {
                sb.append(String.format("ld %s%s, %s", Ssp16Disasm.RIJ(op), Ssp16Disasm.MODIFIER_LOW(op), reg[op >> 4 & 0xF]));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                sb.append(String.format("ldi %s, %X", rij[op >> 8 & 7], op & 0xFF));
                break;
            }
            case 16: 
            case 48: 
            case 64: 
            case 80: 
            case 96: 
            case 112: {
                sb.append(String.format("%s A, %s", arith_ops[op >> 13], reg[op & 0xF]));
                break;
            }
            case 17: 
            case 49: 
            case 65: 
            case 81: 
            case 97: 
            case 113: {
                sb.append(String.format("%s A, (%s%s)", arith_ops[op >> 13], Ssp16Disasm.RIJ(op), Ssp16Disasm.MODIFIER_LOW(op)));
                break;
            }
            case 19: 
            case 51: 
            case 67: 
            case 83: 
            case 99: 
            case 115: {
                sb.append(String.format("%s A, %X", arith_ops[op >> 13], op & 0x1FF));
                break;
            }
            case 20: 
            case 52: 
            case 68: 
            case 84: 
            case 100: 
            case 116: {
                sb.append(String.format("%si A, %X", arith_ops[op >> 13], Ssp16Disasm.READ_OP_DASM_WORD(base_oprom, pc, 2)));
                size = 2;
                break;
            }
            case 21: 
            case 53: 
            case 69: 
            case 85: 
            case 101: 
            case 117: {
                sb.append(String.format("%s A, ((%s%s))", arith_ops[op >> 13], Ssp16Disasm.RIJ(op), Ssp16Disasm.MODIFIER_LOW(op)));
                break;
            }
            case 25: 
            case 57: 
            case 73: 
            case 89: 
            case 105: 
            case 121: {
                sb.append(String.format("%s A, %s%s", arith_ops[op >> 13], Ssp16Disasm.RIJ(op), Ssp16Disasm.MODIFIER_LOW(op)));
                break;
            }
            case 27: {
                sb.append(String.format("mpya (%s%s), (%s%s), %d", Ssp16Disasm.RJ(op >> 4), Ssp16Disasm.MODIFIER_HIGH(op), Ssp16Disasm.RI(op), Ssp16Disasm.MODIFIER_LOW(op), Ssp16Disasm.BIT_B(op)));
                break;
            }
            case 28: 
            case 60: 
            case 76: 
            case 92: 
            case 108: 
            case 124: {
                sb.append(String.format("%si %X", arith_ops[op >> 13], op & 0xFF));
                break;
            }
            case 36: {
                sb.append(String.format("call %s, %X", Ssp16Disasm.get_cond(op), Ssp16Disasm.READ_OP_DASM_WORD(base_oprom, pc, 2)));
                flags |= 0x10;
                size = 2;
                break;
            }
            case 37: {
                sb.append(String.format("ld %s, (A)", reg[op >> 4 & 0xF]));
                break;
            }
            case 38: {
                sb.append(String.format("bra %s, %X", Ssp16Disasm.get_cond(op), Ssp16Disasm.READ_OP_DASM_WORD(base_oprom, pc, 2)));
                size = 2;
                break;
            }
            case 72: {
                sb.append(String.format("mod %s, %s", Ssp16Disasm.get_cond(op), acc_op[op & 7]));
                break;
            }
            case 74: {
                sb.append(String.format("%s", flag_op[op & 0xF]));
                break;
            }
            case 75: {
                sb.append(String.format("mpya (%s%s), (%s%s), %d", Ssp16Disasm.RJ(op >> 4), Ssp16Disasm.MODIFIER_HIGH(op), Ssp16Disasm.RI(op), Ssp16Disasm.MODIFIER_LOW(op), Ssp16Disasm.BIT_B(op)));
                break;
            }
            case 91: {
                sb.append(String.format("mld (%s%s), (%s%s), %d", Ssp16Disasm.RJ(op >> 4), Ssp16Disasm.MODIFIER_HIGH(op), Ssp16Disasm.RI(op), Ssp16Disasm.MODIFIER_LOW(op), Ssp16Disasm.BIT_B(op)));
                break;
            }
            default: {
                sb.append(String.format("Unknown OP = %04X", op));
            }
        }
        return size | flags | 0x20;
    }
}

