/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.z80;

import omegadrive.bus.model.Z80BusProvider;
import omegadrive.memory.IMemoryRam;
import omegadrive.util.Size;
import omegadrive.util.Util;
import z80core.IMemIoOps;

public class Z80MemIoOps
implements IMemIoOps {
    private Z80BusProvider z80BusProvider;
    private long tstatesCount = 0L;
    private boolean activeInterrupt;
    private byte[] ram;
    private int ramSizeMask;
    private int pcUpperLimit = 65535;
    public int lastFetch;

    public static Z80MemIoOps createMdInstance(Z80BusProvider z80BusProvider) {
        return Z80MemIoOps.createMdInstanceInternal(new Z80MemIoOps(), z80BusProvider);
    }

    public static Z80MemIoOps createDebugMdInstance(Z80BusProvider z80BusProvider, StringBuilder sb, int logAddressAccess) {
        return Z80MemIoOps.createMdInstanceInternal(Z80MemIoOps.createDbgMemIoOps(sb, logAddressAccess), z80BusProvider);
    }

    private static Z80MemIoOps createMdInstanceInternal(Z80MemIoOps m, Z80BusProvider z80BusProvider) {
        m.z80BusProvider = z80BusProvider;
        IMemoryRam mem2 = z80BusProvider.getBusDeviceIfAny(IMemoryRam.class).orElseThrow(() -> new RuntimeException("Invalid setup"));
        m.ram = mem2.getRamData();
        m.ramSizeMask = m.ram.length - 1;
        m.pcUpperLimit = Short.MAX_VALUE;
        return m;
    }

    public static Z80MemIoOps createInstance(Z80BusProvider z80BusProvider) {
        Z80MemIoOps m = new Z80MemIoOps(){

            @Override
            public int fetchOpcode(int address) {
                return this.fetchOpcodeBus(address);
            }
        };
        m.z80BusProvider = z80BusProvider;
        return m;
    }

    public static Z80MemIoOpsDbg createDbgMemIoOps(final StringBuilder sb, final int logAddressAccess) {
        return new Z80MemIoOpsDbg(){

            @Override
            public int fetchOpcode(int address) {
                int res = super.fetchOpcode(address);
                this.traceAndCheck("READ , ", Size.BYTE, address, res);
                return res;
            }

            @Override
            public int peek8(int address) {
                int res = super.peek8(address);
                this.traceAndCheck("READ , ", Size.BYTE, address, res);
                return res;
            }

            public int peek16(int address) {
                int res = super.peek8(address + 1) << 8 | super.peek8(address);
                this.traceAndCheck("READ , ", Size.WORD, address, res);
                return res;
            }

            @Override
            public void poke8(int address, int value) {
                this.traceAndCheck("WRITE, ", Size.BYTE, address, value);
                super.poke8(address, value);
            }

            @Override
            public int peek8Ext(int address) {
                int res = super.peek8(address);
                this.traceAndCheck("68k READ , ", Size.BYTE, address, res);
                return res;
            }

            @Override
            public void poke8Ext(int address, int value) {
                this.traceAndCheck("68k WRITE, ", Size.BYTE, address, value);
                super.poke8(address, value);
            }

            public void poke16(int address, int word) {
                this.traceAndCheck("WRITE, ", Size.WORD, address, word);
                super.poke8(address, word);
                super.poke8(address + 1, word >>> 8);
            }

            private void traceAndCheck(String head, Size size, int address, int data) {
                sb.append(head).append((Object)size).append(", ").append(Util.th(address)).append(", ").append(Util.th(data)).append("\n");
                if (logAddressAccess < 0 || address == logAddressAccess) {
                    // empty if block
                }
            }
        };
    }

    protected final int fetchOpcodeBus(int address) {
        this.tstatesCount += 4L;
        this.lastFetch = this.z80BusProvider.read(address, Size.BYTE) & 0xFF;
        return this.lastFetch;
    }

    public int getPcUpperLimit() {
        return this.pcUpperLimit;
    }

    public int peek8(int address) {
        this.tstatesCount += 3L;
        return this.z80BusProvider.read(address, Size.BYTE) & 0xFF;
    }

    public void poke8(int address, int value) {
        this.tstatesCount += 3L;
        this.z80BusProvider.write(address, value & 0xFF, Size.BYTE);
    }

    public int inPort(int port) {
        this.tstatesCount += 4L;
        return this.z80BusProvider.readIoPort(port) & 0xFF;
    }

    public void outPort(int port, int value) {
        this.tstatesCount += 4L;
        this.z80BusProvider.writeIoPort(port, value & 0xFF);
    }

    public boolean isActiveINT() {
        return this.activeInterrupt;
    }

    public boolean setActiveINT(boolean value) {
        this.activeInterrupt = value;
        return true;
    }

    public void addressOnBus(int address, int tstates) {
        this.tstatesCount += (long)tstates;
    }

    public void interruptHandlingTime(int tstates) {
        this.tstatesCount += (long)tstates;
    }

    public long getTstates() {
        return this.tstatesCount;
    }

    public void reset() {
        this.tstatesCount = 0L;
    }

    public int fetchOpcode(int address) {
        this.tstatesCount += 4L;
        return this.ram[address & this.ramSizeMask] & 0xFF;
    }

    public static abstract class Z80MemIoOpsDbg
    extends Z80MemIoOps {
        public abstract void poke8Ext(int var1, int var2);

        public abstract int peek8Ext(int var1);
    }
}

