/*
 * Decompiled with CFR 0.152.
 */
package omegadrive.cpu.z80.disasm;

import java.util.Arrays;
import omegadrive.cpu.z80.disasm.Z80DasmIntf;
import z80core.IMemIoOps;

public class Z80Dasm
extends Z80DasmIntf {
    private final int[] opcodes = new int[5];

    private static String toOpcodesStr(int[] opcodes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < opcodes.length && opcodes[i] != -1; ++i) {
            sb.append(String.format("%02X", opcodes[i])).append(" ");
        }
        return sb.toString();
    }

    static char sign(int offset) {
        return offset < 0 ? (char)'-' : '+';
    }

    static int offs(int offset) {
        if (offset < 0) {
            return -offset;
        }
        return offset;
    }

    public String disassemble(int pc, IMemIoOps memIoOps) {
        return Z80Dasm.disassemble(pc, this.opcodes, memIoOps);
    }

    public static String disassemble(int pc, int[] opcodes, IMemIoOps memIoOps) {
        Arrays.fill(opcodes, -1);
        int offset = 0;
        int opIdx = 0;
        int pos = pc &= memIoOps.getPcUpperLimit();
        StringBuilder stream = new StringBuilder();
        String ixy = "oops!!";
        Z80DasmIntf.z80dasmStruct d = null;
        int op = memIoOps.peek8(pos++);
        opcodes[opIdx++] = op;
        switch (op) {
            case 203: {
                op = memIoOps.peek8(pos++);
                opcodes[opIdx++] = op;
                d = mnemonic_cb[op];
                break;
            }
            case 237: {
                op = memIoOps.peek8(pos++);
                opcodes[opIdx++] = op;
                d = mnemonic_ed[op];
                if (d.mnemonic != Z80DasmIntf.e_mnemonics.zDB) break;
                --pos;
                break;
            }
            case 221: {
                ixy = "ix";
                int op1 = memIoOps.peek8(pos++);
                opcodes[opIdx++] = op1;
                if (op1 == 203) {
                    offset = memIoOps.peek8(pos++);
                    op1 = memIoOps.peek8(pos++);
                    opcodes[opIdx++] = op1;
                    d = mnemonic_xx_cb[op1];
                    break;
                }
                d = mnemonic_xx[op1];
                if (d.mnemonic != Z80DasmIntf.e_mnemonics.zDB) break;
                --pos;
                break;
            }
            case 253: {
                ixy = "iy";
                int op1 = memIoOps.peek8(pos++);
                opcodes[opIdx++] = op1;
                if (op1 == 203) {
                    offset = memIoOps.peek8(pos++);
                    op1 = memIoOps.peek8(pos++);
                    opcodes[opIdx++] = op1;
                    d = mnemonic_xx_cb[op1];
                    break;
                }
                d = mnemonic_xx[op1];
                if (d.mnemonic != Z80DasmIntf.e_mnemonics.zDB) break;
                --pos;
                break;
            }
            default: {
                d = mnemonic_main[op];
            }
        }
        if (d.arguments != null) {
            stream.append(String.format("%-1s ", s_mnemonic[d.mnemonic.ordinal()]));
            char[] src = d.arguments.toCharArray();
            block16: for (int i = 0; i < src.length; ++i) {
                switch (src[i]) {
                    case '?': {
                        stream.append(String.format("$%02x", op));
                        continue block16;
                    }
                    case 'B': 
                    case 'P': {
                        int data = memIoOps.peek8(pos++);
                        opcodes[opIdx++] = data & 0xFF;
                        stream.append(String.format("$%02X", data));
                        continue block16;
                    }
                    case 'A': 
                    case 'N': 
                    case 'W': {
                        int data = memIoOps.peek16(pos);
                        opcodes[opIdx++] = data & 0xFF;
                        opcodes[opIdx++] = data >> 8 & 0xFF;
                        stream.append(String.format("$%04X", data));
                        pos += 2;
                        continue block16;
                    }
                    case 'O': {
                        int data = memIoOps.peek8(pos++);
                        opcodes[opIdx++] = data & 0xFF;
                        stream.append(String.format("$%04X", pc + (byte)data + 2 & 0xFFFF));
                        continue block16;
                    }
                    case 'V': {
                        stream.append(String.format("$%02X", op & 0x38));
                        continue block16;
                    }
                    case 'X': {
                        offset = memIoOps.peek8(pos++);
                        opcodes[opIdx++] = offset & 0xFF;
                    }
                    case 'Y': {
                        stream.append(String.format("(%s%c$%02x)", ixy, Character.valueOf(Z80Dasm.sign(offset)), Z80Dasm.offs(offset)));
                        continue block16;
                    }
                    case 'I': {
                        stream.append(String.format("%s", ixy));
                        continue block16;
                    }
                    default: {
                        stream.append(src[i]);
                    }
                }
            }
        } else {
            stream.append(String.format("%s", s_mnemonic[d.mnemonic.ordinal()]));
        }
        return String.format("%08x   %12s   %s", pc, Z80Dasm.toOpcodesStr(opcodes), stream);
    }
}

